function Ttree(oop){	
	var _op = {
		id : false,
		data : false,
		classname : "TTREE",
		fct : false,
		default_item : false,
		click_first : true
	};
	this.options = _op;
    if(oop) $.extend(this.options,oop);
	
	/****** TREE *****/
	
	this.trim = function(_str){		
        return _str.replace(/^\s+|\s+$/g, '').replace(/(\r\n|\n|\r)/gm,'');
    };
	this.support = document.getElementById(this.options.id);
	this.items = {};
	this.items_list = {};
	this.length = 0;
	this.id_unique = function(_max){
        var text = "";
        var max = (_max)? _max : 20;
        var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for( var i=0; i < max; i++ ) text += possible.charAt(Math.floor(Math.random() * possible.length));
        return text;
    } 
	this._elements = function(node,tag,root) {						
		try{
			var children = false;
			var childNodes = node.getElementsByTagName(tag);		
			for(var i = 0; i < childNodes.length; i++){
				var _elt = childNodes[i];
				_elt.style.display = "none";
				if(typeof _elt.id_unique == "undefined"){
					
					if(_elt.getAttribute && _elt.getAttribute("ID_UNIQUE")) _elt.id_unique = _elt.getAttribute("ID_UNIQUE");
					else _elt.id_unique = this.id_unique();
					
					_elt.div = _elt.getElementsByTagName("div")[0];
					_elt.div.root = _elt;											
				}
				
				if(children === false) children = {};										
				if(root !== false && root.items[_elt.id_unique]) delete root.items[_elt.id_unique];
				
				children[_elt.id_unique] = _elt;
			}
			return children;
		}catch(e){
			//console.log(e);			
		}
	};
	this.parse = function(node,root) {	

		node.items = this._elements(node,"li",root);
		
		for(var key in node.items)this.parse(node.items[key],node);
		
		if(root === false) node.id_unique = this.id_unique();			
				
		node.support = this.support;
		node.root = root;
		node.isroot = (root !== false && root.id === this.support.id)? true : false;
		node.parent_root = (node.parent_root === false) ? node : node.parent_root;
		node.directory = (node.items === false) ? false : true;								
		node.issupport = (node.id !== this.support.id) ? false : true;
		if(node.issupport === false ){
			if(node.isroot === false) node.className = (node.directory === true) ? "sub_directory "  : "sub_file ";	 		
			else node.className = (node.directory === true) ? "directory "  : "file ";	 		
		}
		
		node.close = function(){			
			if(this.div) this.div.className = me.trim(this.div.className.replace(/open/g, ''));
			this.className = me.trim(this.className.replace(/open/g, ''));
		};
		node.open = function(){
			if(this.div){
				this.div.className = me.trim(this.div.className.replace(/open/g, ''));
				this.div.className += " open";
			}
			this.className = me.trim(this.className.replace(/open/g, ''));
			this.className += " open";
		};
		
		node.hide = function(){ this.style.display = "none";};
		node.show = function(){ this.style.display = "";};
		
		node.show_first_level = function(){
			if(this.support.current_item.id_unique !== this.id_unique){// autre item
				if(this.root.id_unique === this.support.current_item.root.id_unique){//même branche
					this.support.current_item.close();
					this.root.show_items();
					//console.log(":::001 : même branche");
				}
				else if(this.root.id_unique === this.support.current_item.id_unique){//le précédent est le parent
					this.support.current_item.show_items();
					//console.log(":::002 : le précédent est le parent");
				}
				else if(this.root.parent_root === this.support.current_item.root.parent_root){//le précédent est un ancêtre autre que mon parent
					this.root.show_items();
					//console.log(":::003 : le précédent est un ancêtre autre que mon parent");
				}
				else{
					//console.log(":::004");	
					this.support.current_item.hide_items();
				}
			}
			this.show_items();
			this.support.current_item = this;
		};		
		node.hide_items = function(){			
			if(this.isroot === false) this.hide();
			this.close();
			if(this.directory === true){
				for(var i in  this.items){					
					this.items[i].close();
					this.items[i].hide();
					if(this.items[i].directory === true)this.items[i].hide_items();					
				}
			}			
		};
		node.show_items = function(){						
			this.show();
			this.open();
			if(this.directory === true){
				for(var i in  this.items){										
					if(this.items[i].directory === true)this.items[i].hide_items();						
					this.items[i].show();
				}
			}			
		};
		node.div_open = function(){
			this.div.click();
		};
		
		if(root !== false){			
			node.div.onclick = function(){								
				this.root.show_first_level();
				if(me.options.fct !== false){					
					me.options.fct({ID : this.root.id_unique, NAME : escape(this.innerHTML)});				
				}
			};						
		}	
		
		this.items_list[node.id_unique] = node;
		if(node.div)this.support.current_item = node;
		
		return node;
	};	
	this.open_first_item = function(){
		if(this.support.current_item !== false)	this.support.current_item.div_open();		
	};
	this.open_item = function(item){		
		if(this.items_list[item]){
			var _list = [];
			var node = this.items_list[item];
			do{				
				_list.push(node);
				node = node.root;				
			}while (node !== false && node.issupport === false);
						
			for(var i = _list.length - 1; i >= 0; i--) _list[i].show_first_level();
			
			this.items_list[item].div_open();
			return true;
		}
		return false;
	};
	this.obj_to_html = function(obj){
		var _li = "<li ID_UNIQUE='"+obj.id_unique+"'><div ID_UNIQUE='"+obj.id_unique+"'>"+((obj.name)?unescape(obj.name):"")+"</div>";
		if(obj.items !== false){
			_li += "<ul>";
			for(var key in obj.items){
				var _item = obj.items[key]; 
				if(_item.items !== false){
					_li += this.obj_to_html(_item);
					continue;
				}
				_li += "<li ID_UNIQUE='"+_item.id_unique+"'><div ID_UNIQUE='"+_item.id_unique+"'>"+((_item.name)?unescape(_item.name):"")+"</div></li>";
			}
			_li += "</ul>";
		}
		_li += "</li>";
		return _li;
	};
	this.display = function(){
		if(this.options.data !== false){
			//console.log(this.options.data);
			var _html = "<ul>";
			for(var key in this.options.data) _html += this.obj_to_html(this.options.data[key]);
			_html += "</ul>";
			this.support.innerHTML = _html;
		}
		this.support.className = (this.trim(this.support.className) !== "")? this.support.className +"  "+this.options.classname : this.options.classname;
		
		this.support.current_item = false;
		this.items = this.parse(this.support,false);				
		this.items.show_items();

		if(this.options.default_item !== false) return this.open_item(this.options.default_item);
		if(this.options.click_first === true )this.open_first_item();		
	};
	/************ DESTROY **********/
		
	this.destroy = function(){  
		for(var fct in this){
			this[fct] = null;
			delete this[fct];		
		}
	};
	
	var me  = this;
	this.display();
}