<?php
session_start();

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Cache-Control: no-cache");
header("Pragma: no-cache");
header('Content-Type: text/html; charset=ISO-8859-15');

require_once("library/Mobile_Detect.php");

/**** UPLOAD CHECK ERROR ****/

function image_resize($sourceImage, $targetImage, $maxWidth = false, $maxHeight = false,$params_text = false){
	try{
		
		if(! list($origWidth, $origHeight) = getimagesize($sourceImage)) return "Format image non support&eacute; !";

		$type = strtolower(substr(strrchr($sourceImage,"."),1));
		if($type == 'jpeg') $type = 'jpg';
	/*	
		$required_memory = Round($origWidth * $origHeight * filesize($sourceImage) * 8);		
		$new_limit	=	memory_get_usage() + $required_memory;
		ini_set("memory_limit", $new_limit);
*/
		switch($type){
			case 'bmp': $image = imagecreatefromwbmp($sourceImage); break;
			case 'gif': $image = imagecreatefromgif($sourceImage); break;
			case 'jpg': $image = imagecreatefromjpeg($sourceImage); break;
			case 'png': $image = imagecreatefrompng($sourceImage); break;
			default : return "Type image non support&eacute;!";
		}
	/*
		ini_restore ("memory_limit");
		
	*/
		// Obtain image from given source file.
		//if (!$image ) return false;
	
		if ($maxWidth === false)  $maxWidth  = $origWidth;
		if ($maxHeight === false) $maxHeight = $origHeight;

		// Calculate ratio of desired maximum sizes and original sizes.
		$widthRatio = $maxWidth / $origWidth;
		$heightRatio = $maxHeight / $origHeight;

		// Ratio used for calculating new image dimensions.
		$ratio = min($widthRatio, $heightRatio);

		// Calculate new image dimensions.
		$newWidth  = (int)$origWidth  * $ratio;
		$newHeight = (int)$origHeight * $ratio;

		// Create final image with new dimensions.
		$newImage = imagecreatetruecolor($newWidth, $newHeight);

		// preserve transparency
		if($type == "gif" or $type == "png"){
			imagecolortransparent($newImage, imagecolorallocatealpha($newImage, 0, 0, 0, 127));
			imagealphablending($newImage, false);
			imagesavealpha($newImage, true);
		}

		imagecopyresampled($newImage, $image, 0, 0, 0, 0, $newWidth, $newHeight, $origWidth, $origHeight);

		// AJOUT DE TEXTE
		if($params_text !== false){
			// Création de quelques couleurs
			$white = imagecolorallocate($newImage, 255, 255, 255);
			$grey = imagecolorallocate($newImage, 128, 128, 128);
			$black = imagecolorallocate($newImage, 0, 0, 0);

			$color = $white;
			if(isset($params_text->color) && isset($params_text->color->r) && isset($params_text->color->g) && isset($params_text->color->b) ){
				$color = imagecolorallocate($newImage, $params_text->color->r, $params_text->color->g, $params_text->color->b);
			}     
			// Le texte à dessiner
			date_default_timezone_set("UTC");

			$text = (($params_text !== false) && isset($params_text->text))? $params_text->text : "@copyright ".date("Y")." Michael MOTZ";
			// Remplacez le chemin par votre propre chemin de police
			$font = (($params_text !== false) && isset($params_text->font))? $params_text->font : 'config/arial.ttf';
			$rotation = (($params_text !== false) && isset($params_text->rotation))? $params_text->rotation : 0;
			$size = (($params_text !== false) && isset($params_text->size))? $params_text->size: 40;
			$x_text = (($params_text !== false) && isset($params_text->x))? $params_text->x : 100;
			$y_text = (($params_text !== false) && isset($params_text->y))? $params_text->y : 150;

			$max_x = imagesx($newImage);
			$x_text = ($x_text >= $max_x)? $max_x - 10 : $x_text;
			$max_y = imagesy($newImage);
			$y_text = ($y_text >= $max_y)? $max_y - 10 : $y_text;

			// Ajout d'ombres au texte
			imagettftext($newImage, $size, $rotation, $x_text + 1, $y_text + 1, $grey, $font, $text);
			// Ajout du texte
			imagettftext($newImage, $size, $rotation, $x_text , $y_text, $color, $font, $text);                     
		}

		$quality = 100;
		switch($type){
			case 'bmp': imagewbmp($newImage, $targetImage, $quality); break;
			case 'gif': imagegif($newImage, $targetImage, $quality); break;
			case 'jpg': imagejpeg($newImage, $targetImage, $quality); break;
			case 'png': imagepng($newImage,$targetImage, $quality); break;
		}             

		// Free up the memory.
		imagedestroy($image);
		imagedestroy($newImage); 
		return true;
	}
	catch (Exception $e) {
        return false;
    }	
}
function parse_upload($file_upload_content,$header,$session){
	try{
		
		$types = Array("image/jpg","image/jpeg");	
		$type = $header["X-File-Type"];
		
		if(!in_array($type,$types)){        
			$result = new stdClass;
			$result->error = true;
			$result->CONTENT = "Format [ ".$type."] non supporté";
			$result->SAVE = false;			
			return $result;
		}				
		$key_crt = $session->CRT;
		  
		$files_vignette = substr(md5("files_vignette".$key_crt),0,10);
		$files_original = substr(md5("files_original".$key_crt),0,10);
			
		$files_normal = substr(md5("files_normal".$key_crt),0,10);
		$files_normal_notext = substr(md5("files_normal_notext".$key_crt),0,10);
		
		$files_tmp = substr(md5("files_tmp".$key_crt),0,10);
		$file_decrypt = substr(md5("file_decrypt".$key_crt),0,10);
		$file_download = substr(md5("file_download".$key_crt),0,10);
		
		date_default_timezone_set("UTC");
		$path = "___/".substr(md5(date("Ymd").$key_crt),0,10);
	   
		if (!file_exists($path)) {
			mkdir("$path/$files_vignette/", 0777, true);
			mkdir("$path/$files_original/", 0777, true);
			mkdir("$path/$files_normal/", 0777, true);
			mkdir("$path/$files_normal_notext/", 0777, true);
			mkdir("$path/$files_tmp/", 0777, true);
			mkdir("$path/$file_decrypt/", 0777, true);
		}
						
		$originalname = $header["X-File-Name"];
		$cryptname = md5($originalname.$key_crt); 
		$extension = substr($originalname,strrpos($originalname, ".") + 1,strlen($originalname)); 
		$name = $cryptname.substr($originalname, strrpos($originalname, "."), strlen($originalname));
	  
		$tmp_url = "$path/$files_tmp/".md5($name.$key_crt).".".$extension;
		$url_crypt = "$path/$files_original/".md5($name.$key_crt.$key_crt);		
		$url_decrypt = "$path/$file_decrypt/".md5($file_decrypt.$name.$key_crt.$key_crt).".".$extension;  
		$_url_small = "$path/$files_vignette/".md5($cryptname.$key_crt.$key_crt.$key_crt.$key_crt).".".$extension;     
		$_url_big = "$path/$files_normal/".md5($cryptname.$key_crt.$key_crt.$key_crt).".".$extension;	  
		$_url_big_notext = "$path/$files_normal_notext/".md5($cryptname.$key_crt.$key_crt.$key_crt).".".$extension;	  
		

		if(file_exists($_url_big)) unlink($_url_big);
		if(file_exists($_url_big_notext)) unlink($_url_big_notext);				
		if(file_exists($_url_small)) unlink($_url_small);
		if(file_exists($url_crypt)) unlink($url_crypt);

		$fp = fopen($tmp_url, "w"); //ouverture du fichier en mode écriture, création du fichier s'il n'existe pas. 
		fwrite($fp,$file_upload_content); // insert le texte: Un texte dans votre fichier. 
		fclose($fp);
		unset($file_upload_content);
						
		if (true !== ($res = image_resize($tmp_url, $_url_small, 150, false))){//VIGNETTE                           
			unlink($tmp_url);
			$result = new stdClass;
			$result->error = true;
			$result->CONTENT = "Création vignette 150x150 impossible";						
			$result->SAVE = false;				
			return $result;
		}

		$params_copyright = load_params();
		if (true !== ($res = image_resize($tmp_url, $_url_big, 1024, false, $params_copyright->image_copyright))){//NORMAL AVEC TEXTE PAR DESSUS                           
			unlink($tmp_url);
			unlink($_url_small);	
			$result = new stdClass;
			$result->error = true;
			$result->CONTENT = "Création de l'image au format 1200x750 impossible";				
			$result->SAVE = false;				
			return $result;
		}
		if (true !== ($res = image_resize($tmp_url, $_url_big_notext, 1024, false))){//NORMAL AVEC TEXTE PAR DESSUS                           
			unlink($tmp_url);
			unlink($_url_small);
			unlink($_url_big);	
			$result = new stdClass;
			$result->error = true;
			$result->CONTENT = "Création de l'image au format 1200x750 impossible";				
			$result->SAVE = false;				
			return $result;
		}  		
		if(true !== encrypt_file($tmp_url, $url_crypt,$key_crt)){//FICHIER ORIGINAL CRYPTE
			unlink($tmp_url);
			unlink($_url_small);
			unlink($_url_big);
			unlink($_url_big_notext);
			$result = new stdClass;
			$result->error = true;
			$result->CONTENT = "Création de l'image cryptée impossble";					
			$result->SAVE = false;				
			return $result;
		}		
		unlink($tmp_url);
		list($origWidth, $origHeight) = getimagesize($_url_big);
		
		$result = new stdClass;
		$result->name = $header["X-File-Name"];
		$result->bigname = "src/".$_url_big;
		$result->bigname_notext = "src/".$_url_big_notext;
		$result->smallname = "src/".$_url_small;
		$result->cryptname = $url_crypt;
		$result->id_unique = get_id();;
		$result->usercreate = $session->INFOS->id_unique;
		$result->datecreate = date('Y-m-d H:i:s');
		$result->width = $origWidth;
		$result->height = $origHeight;
		$result->error = false;	
			
		return $result;
		
	} catch (Exception $e) {
        $result = new stdClass;
		$result->error = true;
		$result->CONTENT = "Impossible d'enregistrer l'image";					
		$result->SAVE = false;				
		return $result;
    }		
}

/**** SQL MANGER ****/

function sql_table_exists($table){
	try{			
		return sql_execute("SHOW TABLES LIKE '$table' ");
	} catch (Exception $e) {
        return false;
    }	
}
function sql_execute($query, $select = true,$list = false){
	try{
		
		$host_name  = "gt96101-001.privatesql";
		$database   = "production";
		$user_name  = "admin";
		$password   = "Admin1024";
		$port		= 35260;
		
		$db = new mysqli($host_name, $user_name, $password, $database,$port);
		if ($db->connect_errno) {			
			return false;
		}
		mysqli_set_charset($db,"utf8");
		if ( !($result = $db->query($query))){
			mysqli_close($db);
			return false;
		}
		if($select === false){
			mysqli_close($db);
			return true;
		}
		if($result->num_rows > 0){
			if($list === false){
				$obj = mysqli_fetch_object($result);
				mysqli_close($db);
				return $obj;
			}
			$data = new stdClass;
			$data->DATA = $result;         
			$data->LINK = $db;
			return $data;
		}
		mysqli_close($db);
		return false;  
	} catch (Exception $e) {
        return false;
    }	
}

/****** DEVICE MANAGER ***/

function get_device_info(){
	$obj = new stdClass;
	$obj->PROPERTIES = new Mobile_Detect;
	$obj->IS_DESKTOP = false;
	if( $obj->PROPERTIES->isMobile()) $css = ( $obj->PROPERTIES->isTablet())? "tablet" : "mobile";
	else{
		$css = "desktop";
		$obj->IS_DESKTOP = true;
	}		
	$obj->TYPE = strtoupper($css);
	$obj->IS = new stdClass;
	$obj->IS->TABLET = ($css == "tablet") ? true : false;
	$obj->IS->DESKTOP = ($css == "desktop") ? true : false;
	$obj->IS->MOBILE = ($css == "mobile") ? true : false;	
	return $obj;
}

/**** ID UNIQUE MANGER ****/

function get_id($limit = false){
    if($limit === false)return md5(uniqid("BR-CONSULT-ENTER-",true)."-OUTER-BR-CONSULT");
	return substr(md5(uniqid("BR-CONSULT-ENTER-",true)."-OUTER-BR-CONSULT"),0,$limit);
}
function get_string_id($length = 32){
	$characters = 'defghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
function get_id_process($val){
    return md5($val."-OUTER-BR-CONSULT");
}

/**** MODULES FUNCTION ****/

function get_modules (&$root,$path = "modules/") {
    $Class = new stdClass;
    $handler = opendir($path);
    while ($file = readdir($handler)) {
        if ($file != "." && $file != "..") {
            if(is_dir ( $path.$file)) continue;
            $info = pathinfo($file);
			if(strtoupper($info['extension']) !== "PHP") continue;
            require_once($path.$file);         
            $file_name =  basename($file,'.'.$info['extension']);			
            $Class->$file_name = new $file_name($root);
        }      
    }
    closedir($handler);
    return $Class;
}

/**** IMPORT FTP FILE ****/

function get_import_images($count_only = false,$CMD,$path_import = "modules/images_import/tmp/") {
    
	$files = array();		
	if($count_only === true){
		$tr = "";
		$count = 0;
		$impair = "impair";
	}
	
	$params_copyright = load_params();
    $handler = opendir($path_import);
    $path_small = "modules/images_import/tmp_small/";
	$path_big = "modules/images_import/tmp_big/";
	$path_big_notext = "modules/images_import/tmp_big_notext/";
	
	$path_crypt = "modules/images_import/tmp_crypt/";
	
	$file_list = array();
	while ($file = readdir($handler)) {
		if(is_dir ( $path_import.$file)) continue;
		$info = pathinfo($file);
		if(strtoupper($info['extension']) === "JPG" || strtoupper($info['extension']) === "JPEG"){
			$file_list[$info['basename']] = $file; // put in array.
		}   
	}
	closedir($handler);
	
	natsort($file_list); // sort.

	foreach($file_list as $key => $file){
			
            $info = pathinfo($file);
	
			$_url_small = $path_small.$file;
			$_url_big = $path_big.$file;
			$_url_big_notext = $path_big_notext.$file;
			$_url_crypt = $path_crypt.$file;									
			$tmp_url = $path_import.$file;
			
			if(! list($origWidth, $origHeight) = getimagesize($tmp_url)) continue;
			
			$item =  new stdClass;
			$item->idx = md5($tmp_url);
			$item->path = $tmp_url;
			$item->extension = strtoupper($info['extension']);
			$item->name = $info['basename'];
			$item->info = $info;
			$item->roles = false;	
			$item->size = filesize($tmp_url);
			$item->size_str = formatSizeUnits($item->size);
			$item->width = $origWidth;
			$item->height = $origHeight;				
			$item->datecreate = date("d/m/Y H:i:s", filemtime($tmp_url));
			$item->ready = false;
			$item->url_big = "";
			$item->url_small = "";
			$item->_url_big = $_url_big;
			$item->_url_big_notext = $_url_big_notext;
			$item->_url_small = $_url_small;
	
			if(file_exists($_url_small) && file_exists($_url_big) && file_exists($_url_crypt)){
				$item->ready = true;
				$item->url_big = "src/".$_url_big;
				$item->url_small = "src/".$_url_small;					
			}										

			if($count_only === true){
				$tr .="<tr ID_UNIQUE_TR='{$item->idx}' class='{$impair}'>";					
				$tr .= "<td class='remove' valign=middle  ><div class='remove' {$CMD->ID_UNIQUE_STRING}_REMOVE=true ID_UNIQUE='{$item->idx}'></div></td>";
				$tr .= ($item->ready === true)? "<td class='view' {$CMD->ID_UNIQUE_STRING}_VIEWER=true BANK_VIEWER='{$item->idx}' ><div ID_UNIQUE='{$item->idx}'  BANK_VIEWER_PABEL='{$item->idx}'></div></td>" : "<td class='view_no' {$CMD->ID_UNIQUE_STRING}_VIEWER=false BANK_VIEWER='{$item->idx}' ><div ID_UNIQUE='{$item->idx}'></div></td>";
				$tr .= "<td class='name' valign=middle  UN_ESCAPE=true>".$info["filename"]."</td>";
				$tr .= "<td class='extension' valign=middle UN_ESCAPE=true>". strtoupper($info['extension'])."</td>";
				$tr .= "<td class='dimenssion' valign=middle  UN_ESCAPE=true>".$origWidth." x ".$origHeight."</td>";
				$tr .= "<td class='size' valign=middle  UN_ESCAPE=true>".formatSizeUnits(filesize($tmp_url))."</td>";					
				$tr .= "<td class='dateupdate' valign=middle  >".date("d/m/Y H:i:s", filemtime($tmp_url))."</td>";
				$tr .= "</tr>";
				
				$impair = ($impair === "impair")? "pair" : "impair";
				++$count;
									
				$files[$item->idx] = $item; 		
				continue;
			}						
																			
			if(!file_exists($_url_small)){					
				if(image_resize($tmp_url, $_url_small, 150, false !== true)) continue;                       
			}
			if(!file_exists($_url_big)){
				if(image_resize($tmp_url, $_url_big, 1024, false, $params_copyright->image_copyright) !== true) continue;
			}
			if(!file_exists($_url_big_notext)){
				if(image_resize($tmp_url, $_url_big_notext, 1024, false) !== true) continue;
			}
			if(!file_exists($_url_crypt)){
				if(encrypt_file($tmp_url, $_url_crypt,$key_crt) !== true) continue;
			}
			$item->ready = true;
			$item->url_big = "src/".$_url_big;
			$item->url_big_notext= "src/".$_url_big_notext;
			$item->url_small = "src/".$_url_small;				
			$files[$item->idx] = $item; 
		             
    }
	unset($file_list);	
	if($count_only === true){
		$result = new stdClass;
		$result->TABLE = $table = "<table class='LIST_FILE_IMPORT' cellspacing=0 cellpadding=0 border=0 style='width:100%;height:auto;'>{$tr}</table>";
		$result->COUNT = $count;
		$result->LIST = $files;
		return $result;
	}
    return $files;
}
function get_import_image_one($session,$tmp_url) {	
	try{
		if(!file_exists ( $tmp_url))return false;
		$info = pathinfo($tmp_url);
		
		if(strtoupper($info['extension']) === "JPG" || strtoupper($info['extension']) === "JPEG"){
			if(! list($origWidth, $origHeight) = getimagesize($tmp_url)) return false;
			
			$file = $info['basename'];
			$_url_small = "modules/images_import/tmp_small/".$file;
			$_url_big = "modules/images_import/tmp_big/".$file;
			$_url_big_notext = "modules/images_import/tmp_big_notext/";
			$_url_crypt = "modules/images_import/tmp_crypt/".$file;																									
			
			if(!file_exists($_url_small)){
				$params_copyright = load_params();
				if(image_resize($tmp_url, $_url_small, 150, false) !== true) return false;                       
			}
			if(!file_exists($_url_big)){
				if(image_resize($tmp_url, $_url_big, 1024, false, $params_copyright->image_copyright) !== true) return false;
			}
			if(!file_exists($_url_big_notext)){
				if(image_resize($tmp_url, $_url_big_notext, 1024, false) !== true) return false;
			}			
			if(!file_exists($_url_crypt)){
				if(encrypt_file($tmp_url, $_url_crypt,$session->CRT) !== true) return false;
			}
			
			$item =  new stdClass;
			$item->name = $info['basename'];
			$item->idx = md5($tmp_url);
			$item->path = $tmp_url;
			$item->info = $info;
			$item->roles = false;	
			$item->size = filesize($tmp_url);
			$item->size_str = formatSizeUnits($item->size);
			$item->width = $origWidth;
			$item->height = $origHeight;				
			$item->url_big = "src/".$_url_big;		
			$item->url_big_notext = "src/".$_url_big_notext;		
			$item->url_small = "src/".$_url_small;
			$item->ready = true;
			$item->_url_big = $_url_big;
			$item->_url_big_notext = $_url_big_notext;
			$item->_url_small = $_url_small;
			$item->_url_crypt = $_url_crypt;
			return $item;
		}
				
		return false; 		
	} catch (Exception $e) {
        return false;
    }
}
function remove_import_image($item) {	
	try{
		if(file_exists($item->path)) unlink($item->path);
		if(file_exists($item->_url_small)) unlink($item->_url_small);
		if(file_exists($item->_url_big)) unlink($item->_url_big);		
		if(file_exists($item->_url_big_notext)) unlink($item->_url_big_notext);		
		return true; 		   
	} catch (Exception $e) {
        return false;
    }
}
function do_import_image($session,$item) {	
	try{
		$tmp_url = $item->path;	
		if(!file_exists ( $tmp_url))return false;

		$key_crt = $session->CRT;
		  
		$files_vignette = substr(md5("files_vignette".$key_crt),0,10);
		$files_original = substr(md5("files_original".$key_crt),0,10);
		$files_normal = substr(md5("files_normal".$key_crt),0,10);
		$files_normal_notext = substr(md5("files_normal_notext".$key_crt),0,10);
		
		$file_decrypt = substr(md5("file_decrypt".$key_crt),0,10);

		date_default_timezone_set("UTC");
		$path = "___/".substr(md5(date("Ymd").$key_crt),0,10);
	   
		if (!file_exists($path)) {
			mkdir("$path/$files_vignette/", 0777, true);
			mkdir("$path/$files_original/", 0777, true);
			mkdir("$path/$files_normal/", 0777, true);
			mkdir("$path/$files_normal_notext/", 0777, true);
			mkdir("$path/$file_decrypt/", 0777, true);
		}

		$originalname = $item->name;
		$cryptname = md5($originalname.$key_crt); 
		$extension = $item->extension;
		$name = $cryptname.substr($originalname, strrpos($originalname, "."), strlen($originalname));	  
		
		$_url_small = "$path/$files_vignette/".md5($cryptname.$key_crt.$key_crt.$key_crt.$key_crt).".".$extension;     
		$_url_big = "$path/$files_normal/".md5($cryptname.$key_crt.$key_crt.$key_crt).".".$extension;	  
		$_url_big_notext = "$path/$files_normal_notext/".md5($cryptname.$key_crt.$key_crt.$key_crt).".".$extension;	  
		$_url_crypt = "$path/$files_original/".md5($name.$key_crt.$key_crt);
		
		if($item->ready === true){			
			if(file_exists($item->_url_small)){
				if( rename($item->_url_small, $_url_small) === false) return false;
			}elseif(image_resize($tmp_url, $_url_small, 150, false) !== true) return false;    
			
			if(file_exists($item->_url_big)){
				if( rename($item->_url_big, $_url_big) === false) return false;
			}else{
				$params_copyright = load_params();
				if(image_resize($tmp_url, $_url_big, 1024, false, $params_copyright->image_copyright) !== true) return false;
			}
			
			if(file_exists($item->_url_big_notext)){
				if( rename($item->_url_big_notext, $_url_big_notext) === false) return false;
			}else{
				$params_copyright = load_params();
				if(image_resize($tmp_url, $_url_big_notext, 1024, false) !== true) return false;
			}
			
			if(file_exists($item->_url_crypt)){
				if( rename($item->_url_crypt, $_url_crypt) === false) return false;
			}elseif(encrypt_file($tmp_url, $_url_crypt,$session->CRT) !== true) return false;
						
		}
		else{
			if(!file_exists($_url_small)){			
				if(image_resize($tmp_url, $_url_small, 150, false) !== true) return false;                       
			}
			if(!file_exists($_url_big)){
				$params_copyright = load_params();
				if(image_resize($tmp_url, $_url_big, 1024, false, $params_copyright->image_copyright) !== true) return false;
			}	
			if(!file_exists($_url_big_notext)){
				$params_copyright = load_params();
				if(image_resize($tmp_url, $_url_big_notext, 1024, false) !== true) return false;
			}			
			if(!file_exists($_url_crypt)){
				if(encrypt_file($tmp_url, $_url_crypt,$session->CRT) !== true) return false;
			}
		}
		
		unlink($item->path);
		
		$result = new stdClass;		
		$result->id_unique = get_id();	
		$result->idx = $result->id_unique;
		$result->name = $item->name;	
		$result->bigname = "src/".$_url_big;
		$result->bigname_notext = "src/".$_url_big_notext;
		
		$result->smallname = "src/".$_url_small;
		$result->roles = false;
		$result->url_big = $result->bigname;
		$result->url_big_notext = $result->bigname_notext;
		
		$result->url_small = $result->smallname;
				
		$result->cryptname = $_url_crypt;		
		$result->usercreate = $session->INFOS->id_unique;
		$result->datecreate = date('Y-m-d H:i:s');
		$result->width = $item->width;
		$result->height = $item->height;
		$result->error = false;			
		return $result; 		
		
	} catch (Exception $e) {
        return false;
    }
}

/**** GENERIC FUNCTION ****/

function my_trim2($str){return trim(rawurldecode($str));}
function my_trim($str){return rawurlencode(trim(rawurldecode($str)));}

function formatSizeUnits($bytes){
	if ($bytes >= 1073741824){
		$bytes = number_format($bytes / 1073741824, 2) . ' GB';
	}
	elseif ($bytes >= 1048576){
		$bytes = number_format($bytes / 1048576, 2) . ' MB';
	}
	elseif ($bytes >= 1024){
		$bytes = number_format($bytes / 1024, 2) . ' kB';
	}
	elseif ($bytes > 1){
		$bytes = $bytes . ' bytes';
	}
	elseif ($bytes == 1){
		$bytes = $bytes . ' byte';
	}
	else{
		$bytes = '0 bytes';
	}
	return $bytes;
}
function decrypt_file_download($filepathSrc,$path,$key){
	try{
		$error = new stdClass;		
		$error->file_not_exists = false;	
		if(!file_exists($filepathSrc)){
			$error->file_not_exists = true;
			return $error;
		}
		$path_parts = pathinfo($path);	
		if (!file_exists($path_parts['dirname'])) mkdir($path_parts['dirname'], 0777, true);		
		$files = glob($path_parts['dirname']); // get all file names
		foreach($files as $file){ // iterate files
			if(is_file($file)) unlink($file);
		}	
		
		$crypt = new Encryption($key); 
		$data = $crypt->decrypt(file_get_contents($filepathSrc));		
        $fh = fopen($path,'w');
        fwrite($fh,$data);
        fclose($fh);
        
		return $path;
	} catch (Exception $e) {
        $error = new stdClass;		
		$error->error_system = true;
		$error->error_msg = $e;
		return $error;
    }
}
function local_images_exists($img){
	try{
		$_name = str_replace("src/","",$img->smallname);
		if(!file_exists($_name)) return false;

		$_name = str_replace("src/","",$img->bigname);
		if(!file_exists($_name)) return false;

		$_name = str_replace("src/","",$img->cryptname);
		if(!file_exists($_name)) return false;
			
		return true;
	} catch (Exception $e) {
        return false;
    }	
}

function str_replace_first($from, $to, $subject){
	$from = '/'.preg_quote($from, '/').'/';
	return preg_replace($from, $to, $subject, 1);
}
function validateDate($date, $format = 'Y-m-d H:i:s'){
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) == $date;
}
function parse_object($array) {
	$obj = new stdClass;
	foreach($array as $k => $v) {
		if(strlen($k)) {
			if(is_array($v) || is_object($v)) $obj->{$k} = parse_object($v);
			else {
				if(strtoupper($v) == "TRUE") $v = true;
				elseif(strtoupper($v) == "FALSE") $v = false;
				//elseif(is_numeric($v)) $v = $v + 0;
				$obj->{$k} = $v;
			}
		}
	}
	return $obj;
}
function send($result){
    exit(json_encode($result));
}
function get_json_file_content($path){
	try{
		if(!file_exists($path)) return false;
		$string = file_get_contents($path);
		if(isJSON($string) === false) return false;
		return json_decode($string);
    }
	catch (Exception $e) {
        return false;
    } 	
}
function isJSON($string){
	try{
		return is_string($string) && is_array(json_decode($string, true)) && (json_last_error() == JSON_ERROR_NONE) ? true : false;
    }
	catch (Exception $e) {
        return false;
    } 	
}
function datePARIS_UK_TO_FR($dt = ""){	
	if(!isset($dt) || empty($dt) || trim($dt) === "")return "";
	if(strpos($dt," ",0) === false)return "";
	if(strpos($dt,"-",0) === false)return "";
	if(strpos($dt,":",0) === false)return "";
	
	$val = explode(" ",$dt);	
	$val1 = explode("-",$val[0]);
	
	return $val1[2]."-".$val1[1]."-".$val1[0]." ".$val[1];
}
function datePARIS_FR_INT()	{
	$dateTime = new DateTime("now", new DateTimeZone('Europe/Paris'));
	return $dateTime->format("Ymd");
}
function TimePARIS_FR_INT()	{
	$t = microtime(true);
	$micro = sprintf("%06d",($t - floor($t)) * 1000000);
	$dateTime = new DateTime( date('Y-m-d H:i:s.'.$micro, $t), new DateTimeZone('Europe/Paris') );
	return $dateTime->format("Hisu");
}

function dateTimePARIS_FR()	{
	$dateTime = new DateTime("now", new DateTimeZone('Europe/Paris'));
	return $dateTime->format("Y-m-d H:i:s");
}
function getHolidays($year = null){
	if ($year === null) $year = intval(date('Y'));	
	$easterDate  = easter_date($year);
	$easterDay   = date('j', $easterDate);
	$easterMonth = date('n', $easterDate);
	$easterYear   = date('Y', $easterDate);
	$holidays = array(
		mktime(0, 0, 0, 1,  1,  $year) => "1er janvier",
		mktime(0, 0, 0, 5,  1,  $year) => "F. du travail",
		mktime(0, 0, 0, 5,  8,  $year) => "V. des alliés",
		mktime(0, 0, 0, 7,  14, $year) => "F. nationale",
		mktime(0, 0, 0, 8,  15, $year) => "Assomption",
		mktime(0, 0, 0, 11, 1,  $year) => "Toussaint",
		mktime(0, 0, 0, 11, 11, $year) => "Armistice",
		mktime(0, 0, 0, 12, 25, $year) => "Noel",
		mktime(0, 0, 0, $easterMonth, $easterDay + 1,  $easterYear) => "Pâques ",
		mktime(0, 0, 0, $easterMonth, $easterDay + 39, $easterYear) => "Ascension",
		mktime(0, 0, 0, $easterMonth, $easterDay + 50, $easterYear) => "Pentecôte"
	);	
	return $holidays;
}
function is_holiday($date){
	$holdays = getHolidays($date->YEAR);
	return( isset($holdays[mktime(0, 0, 0, $date->MONTH,  $date->DAY,  $date->YEAR)] ))? true : false;
}
function dateTimePARIS_FR_to_object(){
	$dateTime = new DateTime("now", new DateTimeZone('Europe/Paris'));
	$obj = new stdClass;
	$obj->YEAR = (int)$dateTime->format("Y");
	$obj->MONTH = (int)$dateTime->format("m");
	$obj->DAY = (int)$dateTime->format("d");
	$obj->HEAR = (int)$dateTime->format("H");
	$obj->MINUTE = (int)$dateTime->format("i");
	$obj->SECONDE = (int)$dateTime->format("s");
	return $obj;
}

/**** ROOT MANAGER ****/

function get_root($key){	
	try{
		$_new = "config/".md5("root-crypt");
		$_current = "config/".md5("root");	
		if(file_exists($_new)){
			if(encrypt_file($_new,$_current,$key) === false) return false;
			unlink($_new);		
		}				
		if(file_exists($_current)){
			$data = decrypt_file($_current,false,$key);
			if(!isJSON($data)) return false;			
			return json_decode($data);			
		}		
		return false;
	}
	catch (Exception $e) {
        return $e;
    } 	
}
function update_root($login = false,$pwd = false,$key){	
	try{
		$_new = "config/".md5("root-crypt");
		$_current = "config/".md5("root");		
		if(file_exists($_new)){
			if(encrypt_file($_new,$_current,$key) === false) return false;
			unlink($_new);		
		}				
		if(file_exists($_current)){
			$data = decrypt_file($_current,false,$key);
			if(!isJSON($data)) return false;
			$data = json_decode($data);
			$data->email = trim($login);
			$data->pwd = $pwd;
			
			date_default_timezone_set('UTC'); 
            $date = date('Ymd_Hisu');
			
			if( rename($_current,$_current."-".$date) === false) return false;
			if(encrypt_file($_current."-".$date,$_current,$key) === false) return false;
			
			$mem_name = $_current."_mem";
			
			$fh = fopen($mem_name,'w');
			fwrite($fh,json_encode($data));
			fclose($fh);
			if(encrypt_file($mem_name,$_current,$key) === false) return false;
			unlink($mem_name);
			return true;
		}		
		return false;
	}
	catch (Exception $e) {
        return false;
    } 	
}

/**** PARAMS SYSTEM MANAGER (OPTIONS) ****/

function update_config($data){	
	try{
		$val = load_params();
		if(isset($val->image_copyright)){
			if(isset($data->image_copyright->color))$val->image_copyright->color = $data->image_copyright->color; 
			if(isset($data->image_copyright->text))$val->image_copyright->text = urldecode($data->image_copyright->text); 
			if(isset($data->image_copyright->rotation))$val->image_copyright->rotation = $data->image_copyright->rotation; 		
			if(isset($data->image_copyright->size))$val->image_copyright->size = $data->image_copyright->size; 
			if(isset($data->image_copyright->x))$val->image_copyright->x = $data->image_copyright->x; 
			if(isset($data->image_copyright->y))$val->image_copyright->y = $data->image_copyright->y; 
		}
		if(isset($data->paypal)){
			if(isset($data->paypal->login)) $val->paypal->login = $data->paypal->login; 
			if(isset($data->paypal->pwd)) $val->paypal->pwd = $data->paypal->pwd; 
			if(isset($data->paypal->signature)) $val->paypal->signature = $data->paypal->signature; 
			if(isset($data->paypal->price)) $val->paypal->price = $data->paypal->price; 
		}
		return save_params($val);
	}
	catch (Exception $e) {
        return false;
    } 	
}	
function load_params(){	
	try{
		return json_decode(file_get_contents("config/config.json"));
	}
	catch (Exception $e) {
        return false;
    } 	
}	
function save_params($data){	
	try{
		$dateTime = new DateTime("now", new DateTimeZone('Europe/Paris'));
		$date = $dateTime->format("YmdHis");		
		$name = "config/config.json";
		rename($name,$name."-".$date);		
		$fh = fopen($name,'w');
		fwrite($fh,json_encode($data));
		fclose($fh);			
		return true;
	}
	catch (Exception $e) {
        return false;
    } 	
}	

/**** MAIL MANAGER ****/

function send_mail_to($config,$to,$name,$Subject,$message,$attach = array()){
	try{
		$headers  = "MIME-Version: 1.0 \n";
		$headers .= "Content-type: text/html; charset=iso-8859-1 \n";		
		$headers .= "From: {$config->NAME} <{$config->EMAIL}>  \n";
		$headers .= "Disposition-Notification-To: $from  \n";
		$headers .= "X-Priority: 1  \n";
		$headers .= "X-MSMail-Priority: High \n";				
		$CR_Mail = TRUE;
		$CR_Mail = @mail ($to, $Subject, $message, $headers);
		if ($CR_Mail === FALSE) return false;
		return true;   
	}catch(Exception $e){return false;}
}

/**** FILE MANAGER ****/

class Encryption{
   const CIPHER = MCRYPT_RIJNDAEL_128; // Rijndael-128 is AES
   const MODE   = MCRYPT_MODE_CBC;
 
   private $key;
   public function __construct($key) {
      $this->key = $key;
   }
   public function encrypt($plaintext) {
        $ivSize = mcrypt_get_iv_size(self::CIPHER, self::MODE);
        $iv = mcrypt_create_iv($ivSize, MCRYPT_DEV_URANDOM);
        $ciphertext = mcrypt_encrypt(self::CIPHER, $this->key, $plaintext, self::MODE, $iv);
        return base64_encode($iv.$ciphertext);
   }
   public function decrypt($ciphertext) {
      $ciphertext = base64_decode($ciphertext);
      $ivSize = mcrypt_get_iv_size(self::CIPHER, self::MODE);
      if (strlen($ciphertext) < $ivSize) {
            throw new Exception('Missing initialization vector');
      }
      $iv = substr($ciphertext, 0, $ivSize);
      $ciphertext = substr($ciphertext, $ivSize);
      $plaintext = mcrypt_decrypt(self::CIPHER, $this->key, $ciphertext, self::MODE, $iv);
      return rtrim($plaintext, "\0");
   }
}
function encrypt_file($filepathSrc,$filepathDest = false,$key){                 
    try{  
      $crypt = new Encryption($key);          
	  $data = $crypt->encrypt(file_get_contents($filepathSrc));
	  if($filepathDest === false) return $data;
      $fh = fopen($filepathDest,'w');
      fwrite($fh,$data);
      fclose($fh);
      return true;
    } catch (Exception $e) {
        return false;
    }
}
function decrypt_file($filepathSrc,$filepathDest = false,$key){
    try{                           
        $crypt = new Encryption($key); 
		$data = $crypt->decrypt(file_get_contents($filepathSrc));
		if($filepathDest === false) return $data;
        $fh = fopen($filepathDest,'w');
        fwrite($fh,$data);
        fclose($fh);
        return true;
    } catch (Exception $e) {
        return false;
    }      
}
function decrypt_file_content($filepathSrc,$key){
	try{
		$crypt = new Encryption($key); 
		return $crypt->decrypt(file_get_contents($filepathSrc));
	} catch (Exception $e) {
        return false;
    }
}
function get_file_data_content($path){		
	try{
		if(!file_exists($path)) return false;
		return json_decode(file_get_contents($path));
	}
	catch (Exception $e) {
        return false;
    } 
}
function decrypt_content($str,$key){
	try{
		$crypt = new Encryption($key); 
		return $crypt->decrypt($str);
	} catch (Exception $e) {
        return $e;
    }
}
function encrypt_content($str,$key){
	try{
		$crypt = new Encryption($key); 
		return $crypt->encrypt($str);
	} catch (Exception $e) {
        return $e;
    }
}

/*********** COMMAND MANAGER *******/

function go_home(&$session,$refresh = false){
	try{
		purge_session($session,$refresh);
		$result = new_cmd($session->ID_SESSION);	
		$result->RUN = "RUN";
		$result->MODULE = "CONTENT";
		$result->PRECISION = "SHOW_HOME";		
		$result->URL = "src/process.php";
		$result->IS_LAUNCHER = $refresh;
		$result->IS_MAIN = true;

		$result->IS_DESKTOP = $session->DEVICE->IS_DESKTOP;
		$result->DEVICE_TYPE = $session->DEVICE->TYPE;
		$result->DEVICE_INFOS = $session->DEVICE->PROPERTIES;		
		$result->TOKEN_HOME = $result->TOKEN;
		
		$result->dungle = ($refresh === false)? "PROCESS" : "MAIN" ;	
		$result->IDX = $session->ID;
		$result->error = false;		
			
		$session->TOKENS[$result->TOKEN] = $result;				
		session_save($session);			
		send($result);
		
	} catch (Exception $e) {
        $test = new stdClass;
		$test->error = true;
		send($test);
    }
}
function get_cmd($token,$session){
	try{
		if(!isset($session)) return false;
		return (!isset($session->TOKENS[$token])) ? false : $session->TOKENS[$token];
	} catch (Exception $e) {
        return false;
    }
}
function new_cmd($session_id){
	$obj = new stdClass;
	$obj->ACTION = false;
	$obj->TOKEN = false;
	$obj->IS_LAUNCHER = false;
	$obj->IS_MAIN = false;
	$obj->ID = $session_id;
	$obj->TOKEN = get_id();
	return $obj;
}

/*********** SESSION MANAGER *******/

function purge_session(&$session,$refresh = false){	
	if(isset($session->TOKENS) && count($session->TOKENS) > 0){
		$list = array();
		if($refresh === true){
			foreach($session->TOKENS as $key => $value){
				if(isset($value->IS_LAUNCHER) && $value->IS_LAUNCHER === true) continue;
				$list[] = $key;
			}
		}
		else{
			foreach($session->TOKENS as $key => $value){
				if(isset($value->IS_LAUNCHER) && $value->IS_LAUNCHER === true || $value->IS_MAIN === true ) continue;
				$list[] = $key;
			}
		}
		if(count($list) > 0){
			for($i = 0; $i < count($list); $i++) unset($session->TOKENS[$list[$i]]);
			unset($list);
			session_save($session);	
		}
	}
}
function get_session($session_id){
	try{		
		$sql = "select id_unique,datecreate,dateupdate,UNCOMPRESS(`data`) as data from sessions where id_unique='$session_id'";
		if( ($data=sql_execute($sql)) === false) return false;		
		return $data;
	}catch(Exception $e){return false;}
}
function del_session($session_id){
	try{
		$sql = "delete from sessions where id_unique='$session_id'";
		return sql_execute($sql,false);	
	}catch(Exception $e){return false;}
}

function session_info($session_id,$is_task = false,$path = "",$external = false){ // CREATE OR REACTIVE SESSION
	
	if(init_table_session() === false) return false;

	if(($data = get_session($session_id))!== false){ // REACTIVE SESSION		
		$session = unserialize(urldecode($data->data));								
		$session->IS_NEW = false;
			
		$session->DEVICE_EXTERNAL = $external;
		$session->CRT = md5(file_get_contents($path."config/numerar.txt"));
		$session->PARAMS = json_decode(file_get_contents($path."config/config.json"));				
		$session->PARAMS_MAIL = json_decode(file_get_contents("config/mail.json"));
		$session->DEVICE = ($session->DEVICE_EXTERNAL === false) ? get_device_info() : $session->DEVICE_EXTERNAL;	
		
	}
	else{ // CREATE NEW SESSION
		$session = new stdClass;
		
		$session->PANIER = array();
		$session->PANIER_DETAIL = array();
		$session->PANIER_COUNT = 0;
			
		$session->IS_NEW = true;
		$session->STAND_BY = false;
		$session->CONNECTED = false;
		$session->IS_ROOT = false;
		$session->INFOS = false;
		$session->ADMIN = false;
		$session->ID = get_id();
		$session->ID_SESSION = $session_id;
		$session->TOKENS = array();
		
		$obj = new_cmd($session_id);
		$obj->ACTION = "INIT";
		$obj->IS_LAUNCHER = true;
				
		$session->TOKENS[$obj->TOKEN] = $obj;
		$session->INIT_TOKEN = $obj->TOKEN;			
		
		$session->DEVICE_EXTERNAL = $external;
		$session->CRT = md5(file_get_contents($path."config/numerar.txt"));
		$session->PARAMS = json_decode(file_get_contents($path."config/config.json"));				
		$session->PARAMS_MAIL = json_decode(file_get_contents("config/mail.json"));
		$session->DEVICE = ($session->DEVICE_EXTERNAL === false) ? get_device_info() : $session->DEVICE_EXTERNAL;
		
		session_save($session);			
	}
			
	$path = substr(md5($session->CRT),0,10);
	$file_download = substr(md5("file_download".$session->CRT),0,10);
	$session->DOWNLOAD_PATH = "../___/".md5("download_tmp")."/$file_download/$path/";

	if (!file_exists($session->DOWNLOAD_PATH )) mkdir($session->DOWNLOAD_PATH, 0777, true);	
				
	return $session;
}

function set_session($session_id, $session,$session_extend = false){
	try{				
		$data = urlencode(serialize($session));
			
		if(($current  = get_session($session_id)) !== false){			
			$sql = "update sessions set data=COMPRESS('$data'),dateupdate='".dateTimePARIS_FR()."' where id_unique='$session_id'";			
			return sql_execute($sql,false);	
		}
		$sql = "insert into sessions(id_unique,data,datecreate,session_datetime_out) values('$session_id',COMPRESS('$data'),'".dateTimePARIS_FR()."',0)";
		return sql_execute($sql,false);	
	}catch(Exception $e){return false;}
}
function set_session_id($session_id, $id_user){
	try{
		if(($current  = get_session($session_id)) !== false){			
			remove_session_id($session_id,$id_user);
			$sql = "update sessions set id_task='$id_user',dateupdate='".dateTimePARIS_FR()."' where id_unique='$session_id'";
			return sql_execute($sql,false);	
		}
	}catch(Exception $e){return false;}
}
function remove_session_id($session_id,$id_user){
	try{		
		$sql = "delete from sessions where id_task='$id_user' and id_unique<>'$session_id'";
		return sql_execute($sql,false);	
	}catch(Exception $e){return false;}
}
function session_save($_session,$session_extend = false){
	try{	
		$session = clone $_session;
		if(isset($session->DEVICE))unset($session->DEVICE);		
		return set_session($session->ID_SESSION, $session);
	}catch(Exception $e){return false;}
}
function session_remove(&$session){
	del_session($session->ID_SESSION);
	$session = session_info($session->ID_SESSION);
	set_session_info($session);
}
function get_table_session_struct(){		
	return array(		
		"id_unique" => "VARCHAR(50)",
		"session_datetime_out" => "VARCHAR(30)",	
		"datecreate" => "VARCHAR(25)",
		"dateupdate" => "VARCHAR(25)",
		"data" => "LONGBLOB"
	);
}
function init_table_session(){
	try{
		$table = "sessions";
		$fields = get_table_session_struct();
		if(sql_table_exists($table) === false){
			$str = "";
			foreach($fields as $key => $val) $str .= ($str === "")? $key." ".$val : ",".$key." ".$val;
			return sql_execute("CREATE TABLE {$table} (
						id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
						{$str}
					)",false);
		}
		return true;
	}catch(Exception $e){
		return false;
	}
}

/*********** PAYAPAL MANAGER *******/

function check_paypal_return($_get,$session){
	try{
		if(isset($session->BASKET_PAY) && isset($session->BASKET_PAY->PAY_PROCESS) && $session->BASKET_PAY->PAY_PROCESS === true && $session->BASKET_PAY->ALREADY_USED === false){
			$result = new stdClass;
			$result->error =true;
			$result->cancel = false;
			$result->buy = false;
			$result->nb_error  = 0;
			$result->code_error  = 0;
			$result->fatal_error  = false;
			$session->BASKET_PAY->ALREADY_USED = true;

			$PAY_TOKEN_PAYPAL = (isset($_get[$session->BASKET_PAY->PAY_TOKEN_PAYPAL]))? $_get[$session->BASKET_PAY->PAY_TOKEN_PAYPAL] : false;		
			$PAY_TOKEN_ID = (isset($_get[$session->BASKET_PAY->PAY_TOKEN_ID]))? $_get[$session->BASKET_PAY->PAY_TOKEN_ID] : false;		
			$PAY_TOKEN_RESULT = (isset($_get[$session->BASKET_PAY->PAY_TOKEN_RESULT]))? $_get[$session->BASKET_PAY->PAY_TOKEN_RESULT] : false;
			
			if($PAY_TOKEN_PAYPAL !== $session->BASKET_PAY->PAY_TRANSACTION_ID){
				$result->code_error  = 2026;
				$result->fatal_error  = true;
				$session->BASKET_PAY->RESULT = $result;
				session_save($session);	
				return $result; 
			}
			if($PAY_TOKEN_ID !== $session->BASKET_PAY->PAY_USER_ID){
				$result->code_error  = 1028;
				$result->fatal_error  = true;
				$session->BASKET_PAY->RESULT = $result;
				session_save($session);	
				return $result;
			}	

			$path = "modules/images_buy/".md5($session->BASKET_PAY->PAY_USER_ID);	   
			$files_vignette = "src/$path/".md5("files_vignette")."/";
			$files_normal = "src/$path/".md5("files_normal")."/";
			$files_normal_notext = "src/$path/".md5("files_normal_notext")."/";
			$files_original = "$path/".md5("files_original")."/";			
			$file_decrypt = "$path/".md5("file_decrypt")."/";
			
			if (!file_exists("src/".$path)) {
				mkdir($files_vignette, 0777, true);
				mkdir($files_normal, 0777, true);				
				mkdir($files_normal_notext, 0777, true);
				mkdir("src/".$files_original, 0777, true);				
				mkdir("src/".$file_decrypt, 0777, true);
			}

			if($PAY_TOKEN_RESULT === $session->BASKET_PAY->PAY_TOKEN_KO){
	
				$result->error = false;
				$result->cancel = true;
				$session->BASKET_PAY->RESULT = $result;
				session_save($session);	
			}
			elseif($PAY_TOKEN_RESULT === $session->BASKET_PAY->PAY_TOKEN_OK){
				
				$id_unique = $session->BASKET_PAY->PAY_USER_ID;
				
				$result->__BASKET = array();
				$sql = "select UNCOMPRESS(`data`) as data from users where id_unique='$id_unique' limit 1";				
				if( ($query = sql_execute($sql)) !== false ){
					if(isset($query->data) && my_trim($query->data) !== ""){
						$result->__BASKET = (array)parse_object(json_decode($query->data));
					}
				}

				$idx = array_keys((array)$session->PANIER);
				$result->__BASKET__ =  parse_object($session->PANIER);
				$data_source = json_encode($result->__BASKET__);
				
				$price = (float)$session->BASKET_PAY->PAY_TOTAL_TO_PAY;
				$reduce = (float)$session->BASKET_PAY->PAY_TOTAL_REDUCE;
				$price_pay = $price - $reduce;
				
				
				$sql = "select * from images WHERE id_unique IN ('".join("','",$idx)."')";	

				if( ($query = sql_execute($sql,true,true)) === false){
										
					$error_msg = "Impossible de récupérer les images";
					$sql_achat = "insert into achats(userid,id_unique,email,name,firstname,nbimages,nberror,amount,price,reduce,error_msg,datecreate,succes,images_source) values('$id_unique','".get_id()."','".$session->BASKET_PAY->PAY_USER_EMAIL."','".$session->BASKET_PAY->PAY_USER_NAME."','".$session->BASKET_PAY->PAY_USER_FIRSTNAME."',".count($idx).",1,$price_pay,$price,$reduce,'$error_msg','".dateTimePARIS_FR()."',0,COMPRESS('$data_source'))";
					
					$result->code_error  = 4028;
					$result->fatal_error  = true;
					$result->query = $sql_achat;
					$session->BASKET_PAY->RESULT = $result;
					session_save($session);	
				
					sql_execute($sql_achat,false);
					return $result;
				}

				//echo "00A1<br>";	
				$count = 0;
				while ($value = mysqli_fetch_object($query->DATA)) {
					
					//echo $value->name." :: START<br>";
					$key = $value->id_unique;
					
					$image = clone $value; 	
					$image->exists_small = file_exists($value->smallname);
					$image->exists_big = file_exists($value->bigname);
					$image->exists_big_notext = file_exists($value->bigname_notext);
					$image->exists_crypt = file_exists("src/".$value->cryptname);
					
					$image->copy_small = false;
					$image->copy_big = false;
					$image->copy_big_notext = false;
					$image->copy_crypt = false;
					
					$info = pathinfo($value->smallname);
					
					//echo $value->name." :: 1<br>";
					
					if($image->exists_small === true){
						
						$file_upload_content = file_get_contents($value->smallname);
						
						$name = $files_vignette.$key.".".$info['extension'];
						
						$fp = fopen($name, "w"); //ouverture du fichier en mode écriture, création du fichier s'il n'existe pas. 
						fwrite($fp,$file_upload_content); // insert le texte: Un texte dans votre fichier. 
						fclose($fp);
						unset($file_upload_content);
						$image->copy_small = true;
					}
					//echo $value->name." :: 2<br>";
					if($image->exists_big === true){
						$file_upload_content = file_get_contents($value->bigname);
						
						$name = $files_normal.$key.".".$info['extension'];
						
						$fp = fopen($name, "w"); //ouverture du fichier en mode écriture, création du fichier s'il n'existe pas. 
						fwrite($fp,$file_upload_content); // insert le texte: Un texte dans votre fichier. 
						fclose($fp);
						unset($file_upload_content);
						$image->copy_big = true;
					}
					//echo $value->name." :: 3<br>";
					if($image->exists_big_notext === true){
						$file_upload_content = file_get_contents($value->bigname_notext);
						
						$name = $files_normal_notext.$key.".".$info['extension'];
						
						$fp = fopen($name, "w"); //ouverture du fichier en mode écriture, création du fichier s'il n'existe pas. 
						fwrite($fp,$file_upload_content); // insert le texte: Un texte dans votre fichier. 
						fclose($fp);
						unset($file_upload_content);
						$image->copy_big_notext = true;
					}
					//echo $value->name." :: 4<br>";
					if( $image->exists_crypt === true){						
						$file_upload_content = file_get_contents("src/".$value->cryptname);
						
						$name = "src/".$files_original.$key;
						
						$fp = fopen($name, "w"); //ouverture du fichier en mode écriture, création du fichier s'il n'existe pas. 					
						fwrite($fp,$file_upload_content); // insert le texte: Un texte dans votre fichier. 
						fclose($fp);
						unset($file_upload_content);
						$image->copy_crypt = true;
					}
					//echo $value->name." :: 5<br>";
					if( $image->copy_small === true && $image->copy_big === true && $image->copy_crypt === true && $image->copy_big_notext === true ){						
						
						//echo $value->name." :: 6<br>";
						
						$image->idx = $key;
						$image->for_user_only = true;
						$image->user_buyer =  $session->BASKET_PAY->PAY_USER_ID;						
						$image->isfree = true;
						$image->galeryid = null;
						
						//echo $value->name." :: 7<br>";
						
						$image->smallname = $files_vignette.$key.".".$info['extension'] ;
						$image->bigname = $files_normal_notext.$key.".".$info['extension'];
						$image->bigname_notext = $files_normal_notext.$key.".".$info['extension'];
						$image->cryptname =  $files_original.$key;
					
						//echo $value->name." :: 8<br>";
						
						$result->__BASKET[$key] = $image;	
						++$count;
						//echo $value->name." :: 9<br>";
					}
					else{
						++$result->nb_error;	
					}
					//echo $value->name."::: END <br>";	
				}

				mysqli_free_result($query->DATA);  
				mysqli_close($query->db);

				$data = json_encode($result->__BASKET);
				
				//echo "00A<br>";
								
				$error_msg = ($result->nb_error > 0)? "Achat effectué avec {$result->nb_error} erreur(s)" :"Aucune erreur" ;
				$succes = ($result->nb_error > 0)? 0:1 ;
				
				if(isset($session->PANIER) && $session->PANIER !== false){
					foreach($session->PANIER as $key => $img)unset($session->PANIER[$key]);
					$session->PANIER_COUNT = 0;
				}
				$session->MY_IMAGES = $result->__BASKET;
				
				//echo "00B<br>";
				
				$sql_achat = "insert into achats(userid,id_unique,email,name,firstname,nbimages,nberror,amount,price,reduce,error_msg,datecreate,succes,images,images_source) values('$id_unique','".get_id()."','".$session->BASKET_PAY->PAY_USER_EMAIL."','".$session->BASKET_PAY->PAY_USER_NAME."','".$session->BASKET_PAY->PAY_USER_FIRSTNAME."',$count,{$result->nb_error},$price_pay,$price,$reduce,'$error_msg','".dateTimePARIS_FR()."',$succes,COMPRESS('$data'),COMPRESS('$data_source'))";
		
				$result->achat_save = sql_execute($sql_achat,false);

				$sql = "update users  set data=COMPRESS('$data'),dateupdate='".dateTimePARIS_FR()."' where id_unique='{$id_unique}';";
			
				$result->query = $sql;
				$result->error = (sql_execute($sql,false) === false)? true : false;
				$result->buy = true;
				$session->BASKET_PAY->RESULT = $result;
				session_save($session);	
				
				//echo "00 ENND<br>";
			}	
			
			return $result;	
		}
		return false;
	}catch(Exception $e){
		return false;
	}	
}

?>


 