<?php
class TMODULE{    
    public $ROOT = false;
    public $ERROR = false;
    public $SYSTEM = false;
    public $NAME = "MODULE";
    public $DEFAULT_DIRECT = true;	
    function __construct( &$PARENT ){
        $this->ROOT = $PARENT;
    }    	
	
	/******* GALERY****/
	
	private function get_info_cmd_simple($CMD){
		$obj = new stdClass;
		if(isset($CMD->RUN))$obj->RUN = $CMD->RUN;
		if(isset($CMD->CALL_BACK_RUN))$obj->CALL_BACK_RUN = $CMD->CALL_BACK_RUN;
		if(isset($CMD->RUN_LIST))$obj->RUN_LIST = $CMD->RUN_LIST;		
		$obj->TOKEN = $CMD->TOKEN;
		$obj->DATA = $CMD->DATA;
		$obj->error = $CMD->error;
		$obj->CONTENT = $CMD->CONTENT;
		return $obj;
	}	
	private function refresh_solde(){
		try{
			
			$solde = new stdClass;
			$solde->DETAIL = false;
			$solde->AMOUNT = 0.0;
			$solde->BASKET = "";
			$solde->COUNT = 0;
			
			if( ($result = $this->SYSTEM->galery_list(true,true,true))  === false) return $solde; 						
				 												
			$galeries = $result->GALERY_LIST;
			$images = $this->ROOT->PANIER;
			$count = 0;
			$_amounts = array();
			
			foreach($images as $key => $_root){														
				++$count;				
				$_idx = $_root->root;							
				$_root = $galeries[$_idx];
				
				if(!isset( $_amounts[$_idx])){							
					$_amounts[$_idx] = new stdClass;
					$_amounts[$_idx]->name = $_root->name;															
					$_amounts[$_idx]->price = 0.0;					
					$_amounts[$_idx]->nb_free = 0;
					$_amounts[$_idx]->nb_nofree = 0; 
					$_amounts[$_idx]->nb_total = 0;									
					$_amounts[$_idx]->reduce_price = 0.0;
					
					$_amounts[$_idx]->degressivity_free_2 = false;
					$_amounts[$_idx]->degressivity_free_3 = false;
					
					$_amounts[$_idx]->reduce_price = 0.0;
					
					$price_default = 0.0;
					if($_root->prices->DEFAULT === true) $price_default = (float)$_root->prices->PRICE;					
					elseif($_root->prices->DEGRESSIVITY === true){
						$price_default = (float)$_root->prices->LIMIT_PRICE_1;
						$_amounts[$_idx]->degressivity_free_2 = ($_root->prices->LIMIT_PRICE_2 === 0)? true : false;
						$_amounts[$_idx]->degressivity_free_3 = ($_root->prices->LIMIT_PRICE_3 === 0)? true : false;
					}
					
					$_amounts[$_idx]->main_price = $price_default; 
				}
				++$_amounts[$_idx]->nb_total;				
				if($_root->prices->FREE === true) ++$_amounts[$_idx]->nb_free;
				else{					
					if($_root->prices->DEGRESSIVITY === true ){	
						
						if($_root->prices->LIMIT_PRICE_IMAGECOUNT_2 > 0 && $_amounts[$_idx]->nb_total > $_root->prices->LIMIT_PRICE_IMAGECOUNT_2){
							if($_root->prices->LIMIT_PRICE_IMAGECOUNT_3 > 0 && $_amounts[$_idx]->nb_total > $_root->prices->LIMIT_PRICE_IMAGECOUNT_3){
								$_amounts[$_idx]->price  += $_root->prices->LIMIT_PRICE_3;
								if( $_root->prices->LIMIT_PRICE_3 === 0) ++$_amounts[$_idx]->nb_free;
								else ++$_amounts[$_idx]->nb_nofree;
							}
							else{ 
								$_amounts[$_idx]->price  += $_root->prices->LIMIT_PRICE_2;
								if( $_root->prices->LIMIT_PRICE_2 === 0) ++$_amounts[$_idx]->nb_free;
								else ++$_amounts[$_idx]->nb_nofree;
							}
						}						
						else{
							$_amounts[$_idx]->price  += $_root->prices->LIMIT_PRICE_1;
							++$_amounts[$_idx]->nb_nofree;
						}						
						
					}
					else{
						$_amounts[$_idx]->price  += (float)$_root->prices->PRICE;						
						++$_amounts[$_idx]->nb_nofree;
					}
				}
				$_amounts[$_idx]->default_price  += $_amounts[$_idx]->main_price;					
			}
			
			$_amount_pay = 0.0;			
			$_amount_default = 0.0;
			$_nb_free = 0;
			$_nb_nofree = 0;
			
			$_info = array();
			
			foreach($_amounts as $key => $value){
				$_amount_pay 	+= $value->price;
				$_amount_default+= $value->default_price;
				$_nb_free 		+= $value->nb_free;
				$_nb_nofree 	+= $value->nb_nofree;
				
				$_total = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/GALERY/IHM/SOLDE_GALERY.html",$CMD); 			
				$_total = str_replace("@@DEFAULT_NB_IMAGES@@",$value->nb_total,$_total);//Total image
				$_total = str_replace("@@DEFAULT_NB_IMAGES_NOFREE@@",$value->nb_nofree,$_total);//Images payantes
				$_total = str_replace("@@DEFAULT_NB_IMAGES_FREE@@",$value->nb_free,$_total);//Images gratuites			
				$_total = str_replace("@@DEFAULT_TOTAL_AMOUNT@@",round($value->default_price,2),$_total);//Montant total
				$_total = str_replace("@@DEFAULT_REDUCE_PRICE@@",round($value->default_price - $value->price,2),$_total);//Réduction			
				$_total = str_replace("@@DEFAULT_TOTAL_SOLDE@@",$value->price,$_total);//Total à payer
				
				$obj = new stdClass;
				$obj->name = $value->name;
				$obj->info = $_total;
				$_info[$key] = $obj;
			}
			
			$_total = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/GALERY/IHM/SOLDE.html",$CMD); 			
			$_total = str_replace("@@DEFAULT_NB_IMAGES@@",$count,$_total);//Total image
			$_total = str_replace("@@DEFAULT_NB_IMAGES_NOFREE@@",$_nb_nofree,$_total);//Images payantes
			$_total = str_replace("@@DEFAULT_NB_IMAGES_FREE@@",$_nb_free,$_total);//Images gratuites			
			$_total = str_replace("@@DEFAULT_TOTAL_AMOUNT@@",round($_amount_default,2),$_total);//Montant total
			$_total = str_replace("@@DEFAULT_REDUCE_PRICE@@",round($_amount_default - $_amount_pay,2),$_total);//Réduction			
			$_total = str_replace("@@DEFAULT_TOTAL_SOLDE@@",$_amount_pay,$_total);//Total à payer
			 
			$_total_inline = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/GALERY/IHM/SOLDE_INLINE.html",$CMD); 			
			$_total_inline = str_replace("@@DEFAULT_NB_IMAGES@@",$count,$_total_inline);//Total image
			$_total_inline = str_replace("@@DEFAULT_NB_IMAGES_NOFREE@@",$_nb_nofree,$_total_inline);//Images payantes
			$_total_inline = str_replace("@@DEFAULT_NB_IMAGES_FREE@@",$_nb_free,$_total_inline);//Images gratuites			
			$_total_inline = str_replace("@@DEFAULT_TOTAL_AMOUNT@@",round($_amount_default,2),$_total_inline);//Montant total
			$_total_inline = str_replace("@@DEFAULT_REDUCE_PRICE@@",round($_amount_default - $_amount_pay,2),$_total_inline);//Réduction			
			$_total_inline = str_replace("@@DEFAULT_TOTAL_SOLDE@@",$_amount_pay,$_total_inline);//Total à payer
			
			$totals = new stdClass;
			$totals->DEFAULT_NB_IMAGES = $count;
			$totals->DEFAULT_NB_IMAGES_NOFREE = $_nb_nofree;
			$totals->DEFAULT_NB_IMAGES_FREE = $_nb_free;
			$totals->DEFAULT_TOTAL_AMOUNT = round($_amount_default,2);
			$totals->DEFAULT_REDUCE_PRICE = round($_amount_default - $_amount_pay,2);
			$totals->DEFAULT_TOTAL_SOLDE = $_amount_pay;
			
			$solde->DETAIL = $_info;			
			$solde->AMOUNT = $_amount_total;
			$solde->BASKET = $_total;
			$solde->BASKET_INLINE = $_total_inline;
			$solde->COUNT = $count;
			$solde->TOTALS = $totals;			
			return $solde;
			
		}catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }	
	}
	public function INIT_BASKET($CMD){
		try{
			if($CMD->DATA !== false){
				if(isset($this->ROOT->PANIER_DETAIL[$CMD->DATA])) unset($this->ROOT->PANIER_DETAIL[$CMD->DATA]);	
				$this->ROOT->PANIER_COUNT = 0;
				foreach($this->ROOT->PANIER as $key => $img){
					if($img->root === $CMD->DATA){
						unset($this->ROOT->PANIER[$key]);
						continue;
					}
					++$this->ROOT->PANIER_COUNT;
				}
			}
			else{
				$this->ROOT->PANIER = array();
				$this->ROOT->PANIER_DETAIL = array();
				$this->ROOT->PANIER_COUNT = 0;
			}
			$CMD->DATA->SOLDE = $this->refresh_solde();		
            return $this->get_info_cmd_simple($CMD);
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}
	public function GET_BASKET_SOLDE($CMD){
		try{
			$CMD->DATA = $this->refresh_solde();		
            return $this->get_info_cmd_simple($CMD);
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}
	public function GET_GALERY_MENU_ONLY($CMD){
		try{			
			$CMD->MENU = $this->SYSTEM->get_galery_li($CMD,(isset($CMD->PUBLIC))? $CMD->PUBLIC : false)->LI;				
            return $CMD;
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}	
	public function GET_GALERY_MENU($CMD){
		try{
			$this->SYSTEM->purge_images();	
			$galery = $this->SYSTEM->get_galery_li($CMD,(isset($CMD->PUBLIC))? $CMD->PUBLIC : false,true);
			$obj = new stdClass;
			$obj->MENU = $galery->LI;
			$obj->GALERY = $this->SYSTEM->get_galery_images($galery->GALERIES,array_keys($this->ROOT->PANIER),(isset($CMD->PUBLIC))? $CMD->PUBLIC : false);
			$obj->PANIER = $this->ROOT->PANIER;
			$obj->PANIER_DETAIL = $this->ROOT->PANIER_DETAIL;
			$obj->PANIER_COUNT = $this->ROOT->PANIER_COUNT;
			$CMD->CONTENT = $obj;	
			$CMD->DATA->SOLDE = $this->refresh_solde();		
            return $this->get_info_cmd_simple($CMD);
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}	
	public function ADD_IMG_TO_BASKET($CMD){
		try{			
			if(!isset($this->ROOT->PANIER_DETAIL[$CMD->DATA->IMAGE->root])) $this->ROOT->PANIER_DETAIL[$CMD->DATA->IMAGE->root] = array();
			
			++$this->ROOT->PANIER_COUNT;
			$this->ROOT->PANIER_DETAIL[$CMD->DATA->IMAGE->root][$CMD->DATA->IMAGE->idx] = $CMD->DATA->IMAGE;
			$this->ROOT->PANIER[$CMD->DATA->IMAGE->idx] = $CMD->DATA->IMAGE;					
			
			$CMD->DATA->PANIER_COUNT = $this->ROOT->PANIER_COUNT;
			$CMD->DATA->SOLDE = $this->refresh_solde();	
			$CMD->DATA->PANIER = $this->ROOT->PANIER;	
            return $this->get_info_cmd_simple($CMD);
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}
	public function REMOVE_IMG_TO_BASKET($CMD){
		try{				
			if(isset($this->ROOT->PANIER[$CMD->DATA->IMAGE->idx])) unset($this->ROOT->PANIER[$CMD->DATA->IMAGE->idx]);
			if(isset($this->ROOT->PANIER_DETAIL[$CMD->DATA->IMAGE->root][$CMD->DATA->IMAGE->idx])) unset($this->ROOT->PANIER_DETAIL[$CMD->DATA->IMAGE->root][$CMD->DATA->IMAGE->idx]);
			--$this->ROOT->PANIER_COUNT;
			$CMD->DATA->PANIER_COUNT = $this->ROOT->PANIER_COUNT;
			$CMD->DATA->SOLDE = $this->refresh_solde();
            return $this->get_info_cmd_simple($CMD);
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}
	
	/************** DOWNLOAD **************/
	
	public function DOWNLOAD_MY_IMAGE($CMD){
		try{			
			$image = $this->ROOT->MY_IMAGES[$CMD->DATA];
			$CMD->__img = $image;
			$img = new stdClass;
			$img->NAME = basename($image->bigname);		
			$img->CONTAINER = $CMD->CONTAINER;
			$path = $this->ROOT->DOWNLOAD_PATH . md5($this->ROOT->CRT.$this->ROOT->INFOS->id_unique) ."/". $img->NAME;
			
			if( ($result =  decrypt_file_download($image->cryptname,$path,$this->ROOT->CRT)) === false){
				$CMD->error = true;
				$CMD->CONTENT = "Impossible de télécharger l'image";
				return $CMD;
			} 			
			if( isset($result->file_not_exists) &&  $result->file_not_exists === true){
				$CMD->error = true;
				$CMD->CONTENT = "Impossible de télécharger l'image<br>Erreur(1012)";
				return $CMD;
			}
			if( isset($result->error_system) &&  $result->error_system === true){
				$CMD->error = true;
				//$CMD->CONTENT = "Impossible de télécharger l'image<br>Erreur(1015)<br>{$result->error_msg}";
				$CMD->CONTENT = "Impossible de télécharger l'image<br>Erreur(1015)";
				return $CMD;
			} 	
			$img->URL = $result;
						
			$CMD->DATA = $img;				
			return $this->get_info_cmd_simple($CMD);
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}
	public function DOWNLOAD_IMAGE($CMD){
		try{
			 
			$id_unique = $CMD->DATA;		
			$sql = "select * from images where id_unique='{$id_unique}' limit 1";
			if( ($img = $this->SYSTEM->sql_select_one($sql)) === false){
				$CMD->error = true;
				$CMD->CONTENT = "(2) Impossible de télécharger l'image ";
				return $CMD;
			}
			$image = new stdClass;
			$image->NAME = basename($img->bigname);		
			$image->CONTAINER = $CMD->CONTAINER;
			$path = $this->ROOT->DOWNLOAD_PATH . md5($this->ROOT->CRT.$this->ROOT->INFOS->id_unique) ."/". $image->NAME;
			
			if( ($result =  decrypt_file_download($img->cryptname,$path,$this->ROOT->CRT)) === false){
				$CMD->error = true;
				$CMD->CONTENT = "Impossible de télécharger l'image";
				return $CMD;
			} 			
			if( isset($result->file_not_exists) &&  $result->file_not_exists === true){
				$CMD->error = true;
				$CMD->CONTENT = "Impossible de télécharger l'image<br>Erreur(1012)";
				return $CMD;
			} 
			if( isset($result->error_system) &&  $result->error_system === true){
				$CMD->error = true;
				$CMD->CONTENT = "Impossible de télécharger l'image<br>Erreur(1015)";
				return $CMD;
			} 
			$image->URL = $result;
						
			$CMD->DATA = $image;				
			return $this->get_info_cmd_simple($CMD);
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}
	
	/************* SOLDE & BUY **********/
	
	public function GET_SOLDE($CMD){
		try{
			
			if($this->ROOT->CONNECTED === true){				
				$data = $this->refresh_solde();
				
				$this->ROOT->BASKET_PAY = new stdClass;
				
				$this->ROOT->BASKET_PAY->PAY_ROOT_EMAIL = load_params()->paypal->login;
				
				$this->ROOT->BASKET_PAY->PAY_USER_ID = $this->ROOT->INFOS->id_unique;
				$this->ROOT->BASKET_PAY->PAY_USER_EMAIL = $this->ROOT->INFOS->email;
				$this->ROOT->BASKET_PAY->PAY_USER_NAME = $this->ROOT->INFOS->nom;
				$this->ROOT->BASKET_PAY->PAY_USER_FIRSTNAME = $this->ROOT->INFOS->prenom;
				
				
				$this->ROOT->BASKET_PAY->PAY_TOTAL_REDUCE = $data->TOTALS->DEFAULT_REDUCE_PRICE;
				$this->ROOT->BASKET_PAY->PAY_TOTAL_TO_PAY = $data->TOTALS->DEFAULT_TOTAL_AMOUNT;
				
				$this->ROOT->BASKET_PAY->PAY_TRANSACTION_ID = get_id();				
				$this->ROOT->BASKET_PAY->PAY_TOKEN_PAYPAL = get_id();
				$this->ROOT->BASKET_PAY->PAY_TOKEN_ID = get_id();
				$this->ROOT->BASKET_PAY->PAY_TOKEN_RESULT = get_id();
				$this->ROOT->BASKET_PAY->PAY_TOKEN_OK = get_id();
				$this->ROOT->BASKET_PAY->PAY_TOKEN_KO = get_id();
				
				
				$CMD->CONTENT = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/GALERY/BASKET_BUY.html",$CMD); 				
				foreach($this->ROOT->BASKET_PAY as $key => $value){
					$CMD->CONTENT = str_replace("@@{$key}@@",$value,$CMD->CONTENT);
				}
				$this->ROOT->BASKET_PAY->PAY_BASKET = (array)parse_object($this->ROOT->PANIER);
				$this->ROOT->BASKET_PAY->ALREADY_USED = false;
				$this->ROOT->BASKET_PAY->PAY_PROCESS = false;				
				
			}else $CMD->CONTENT = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/GALERY/BASKET_BUY_NO_CONNECTED.html",$CMD);            
			
			return $CMD;
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}
	public function DO_BUY($CMD){
		try{							
			$this->ROOT->BASKET_PAY->PAY_PROCESS = true;
			$CMD->DATA = $this->ROOT->BASKET_PAY;
			$CMD->EXECUTE = true;
			return $CMD;
        }catch(Exception $e){
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}	
	public function GET_GALERY_DATA($CMD){
		try{

			$CMD->EXECUTE = false;
			if( ($result = $this->SYSTEM->sql_select_one("select * from galery where id_unique='{$CMD->ID_UNIQUE}'")) === false){					
				$error = "La galérie n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			
			$obj = new stdClass;
			
			$prices = json_decode($result->prices);	
		
			$obj->NAME = $result->name;
			$obj->DESCRIPTION = $result->description;
			$obj->CREATE_DATE = $result->datecreate;
			$obj->UPDATE_DATE = (isset($result->dateupdate) && trim($result->dateupdate) !== "")? $result->dateupdate : "";
			
			$obj->ROOT = (isset($result->root) && trim($result->root) !== "")? $result->root : "";
			
			$obj->IMAGES = $this->SYSTEM->galery_images($result->id_unique,"",$prices->FREE);	
			$obj->IMAGES_COUNT = ($obj->IMAGES === false)? 0 : count((array)$obj->IMAGES);
			
			$roles = (isJSON($result->roles) === true)? json_decode($result->roles): array();								
			$obj->ROLES = (isJSON($result->roles) === true)? json_decode($result->roles): array();								
			$obj->ROLES_FREE = (isJSON($result->roles_free) === true)?json_decode($result->roles_free): array();	
			
			$obj->DEFAULT = $prices->DEFAULT;
			$obj->DEGRESSIVITY = $prices->DEGRESSIVITY;
			$obj->FREE = $prices->FREE;			
			
			$obj->PUBLISH = ((int)$result->ispublic === 1)? true : false;				
			
			$obj->PRICE = 0.0;			
			$obj->LIMIT_PRICE_1 = 0.0;
			$obj->LIMIT_PRICE_IMAGECOUNT_1 = 0;			
			$obj->LIMIT_PRICE_2 = 0.0;
			$obj->LIMIT_PRICE_IMAGECOUNT_2 = 0;			
			$obj->LIMIT_PRICE_3 = 0.0;
			$obj->LIMIT_PRICE_IMAGECOUNT_3 = 0;						
			
			if($obj->DEGRESSIVITY === true){
				$obj->LIMIT_PRICE_1 = $prices->LIMIT_PRICE_1;
				$obj->LIMIT_PRICE_IMAGECOUNT_1 = $prices->LIMIT_PRICE_IMAGECOUNT_1;			
				$obj->LIMIT_PRICE_2 = $prices->LIMIT_PRICE_2;
				$obj->LIMIT_PRICE_IMAGECOUNT_2 = $prices->LIMIT_PRICE_IMAGECOUNT_2;			
				$obj->LIMIT_PRICE_3 = $prices->LIMIT_PRICE_3;
				$obj->LIMIT_PRICE_IMAGECOUNT_3 = $prices->LIMIT_PRICE_IMAGECOUNT_3;	
			}elseif($obj->DEFAULT === true) $obj->PRICE = $prices->PRICE;	
			
			$obj->HAS_ROOT = true;			
			$CMD->EXECUTE = true; 
							
			$CMD->CONTENT = parse_object($obj); 
			
            return $CMD;
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	
	/******* GALERY EDITION ****/
	
	public function CREATE_GALERY($CMD){
        try{
			
			$CMD->LOG= true;
			$CMD->CLEAR= true;
			
			$CMD->EXECUTE = false;
			if( $this->SYSTEM->has_role("GALERY_CREATE") === false ){
				$MSG_ERROR = "(2)Imposible de créer la galérie, accès refusé";
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
				return $CMD;
			}
			
			$CMD->INPUT = "INPUT-NAME";
			$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_IMAGECOUNT_3').addClass('error').focus();</script>Une erreur(102) est survenue lors de l'exécution de la commande";			
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";

			if(!isset($CMD->DATA->NAME) || my_trim($CMD->DATA->NAME) === ""){
				$MSG_ERROR = "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La saisie du nom de la galérie est obligatoire";
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
				return $CMD;
			}
			if(!isset($CMD->DATA->DESCRIPTION) || my_trim($CMD->DATA->DESCRIPTION) === ""){
				$CMD->INPUT = "INPUT-DESCRIPTION";
				$MSG_ERROR = "<script language='javascript'>$('#INPUT-DESCRIPTION').addClass('error').focus();</script>La saisie de la description de la galérie est obligatoire";
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
				return $CMD;
			}
			
			$id_unique = get_id();							
			$result = $this->SYSTEM->sql_select_one("select * from galery where name='".my_trim($DATA->DATA->NAME)."' limit 1");
			if($result !== false){				
				$MSG_ERROR = "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La galérie '".my_trim($DATA->NAME)."' existe déj&agrave;";
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
				return $CMD;
			}
			
			$isfree = 0;
			
			$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION = new stdClass;
			$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION->IS_FREE_2 = false;
			$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION->IS_FREE_3 = false;
			
			if(isset($CMD->DATA->PRICES->FREE) &&  $CMD->DATA->PRICES->FREE === true){
				
				$CMD->DATA->PRICES->DEFAULT = false;
				$CMD->DATA->PRICES->DEGRESSIVITY = false;
				$isfree = 1;		
			}
			elseif(isset($CMD->DATA->PRICES->DEFAULT) &&  $CMD->DATA->PRICES->DEFAULT === true){

				$price = ( !isset($CMD->DATA->PRICES->PRICE)  || my_trim($CMD->DATA->PRICES->PRICE) === "")? 0.0 : (float)$CMD->DATA->PRICES->PRICE;
									
				if($price <= 0.0){		
					$CMD->INPUT = "INPUT-PRICE";
					$MSG_ERROR = "<script language='javascript'>$('#INPUT-PRICE').addClass('error').focus();</script>Le prix d'une image par défaut doit être supérieur &agrave; 0€";
					$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
					return $CMD;
				}
				
				$isfree = ($price === 0.0)? 1 : 0;
				$CMD->DATA->PRICES->PRICE = $price;					
				$CMD->DATA->PRICES->DEGRESSIVITY = false;
				$CMD->DATA->PRICES->FREE = false;
			}
			else{
			
				$CMD->DATA->PRICES->LIMIT_PRICE_1 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_1) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_1) === "")? 0.0 : (float)$CMD->DATA->PRICES->LIMIT_PRICE_1;
				$CMD->DATA->PRICES->LIMIT_PRICE_2 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_2) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_2) === "")? 0.0 : (float)$CMD->DATA->PRICES->LIMIT_PRICE_2;
				$CMD->DATA->PRICES->LIMIT_PRICE_3 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_3) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_3) === "")? 0.0 : (float)$CMD->DATA->PRICES->LIMIT_PRICE_3;

				$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_1 = 1;
				$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2) === "")? 0 : (int)$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2;
				$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3) === "")? 0 : (int)$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3;
				
				if($CMD->DATA->PRICES->LIMIT_PRICE_1 <= 0.0){
					$CMD->INPUT = "INPUT-LIMIT_PRICE_1";	
					$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_1').addClass('error').focus();</script>Le prix(1) de l'image doit être supérieur &agrave; 0€ pour appliquer la dégressivité";
					$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
					return $CMD;
				}
				
				if($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2 > 0){
					if($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2 <= $CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_1){						
						$CMD->INPUT = "INPUT-LIMIT_PRICE_IMAGECOUNT_2";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_IMAGECOUNT_2').addClass('error').focus();</script>Le nombre de base d'image(2) de l'image doit être supérieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_1} pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}
					
					if($CMD->DATA->PRICES->LIMIT_PRICE_2 >= $CMD->DATA->PRICES->LIMIT_PRICE_1){
						$CMD->INPUT = "INPUT-LIMIT_PRICE_2";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_2').addClass('error').focus();</script>Le prix(1) de l'image doit être inférieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_1}€ pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}					
				}else $CMD->DATA->PRICES->LIMIT_PRICE_2 = 0.0;
				
				if($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3 > 0){
					if($CMD->DATA->PRICES->LIMIT_PRICE_2 === 0.0){
						$CMD->INPUT = "INPUT-LIMIT_PRICE_2";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_2').addClass('error').focus();</script>Le prix(2) de l'image doit être inférieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_1}€ et supérieur à 0€ pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}
					if($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3 <= $CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2){						
						$CMD->INPUT = "INPUT-LIMIT_PRICE_IMAGECOUNT_3";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_IMAGECOUNT_3').addClass('error').focus();</script>Le nombre de base d'image(2) de l'image doit être supérieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2} pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}
					if($CMD->DATA->PRICES->LIMIT_PRICE_3 >= $CMD->DATA->PRICES->LIMIT_PRICE_2){
						
						$CMD->INPUT = "INPUT-LIMIT_PRICE_3";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_3').addClass('error').focus();</script>Le prix(3) de l'image doit être inférieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_2}€ pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}
				}else $CMD->DATA->PRICES->LIMIT_PRICE_3 = 0.0;
								
				$isfree = 0;			
				$CMD->DATA->PRICES->DEGRESSIVITY = true;
				$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION = new stdClass;
				$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION->IS_FREE_2 = ($CMD->DATA->PRICES->LIMIT_PRICE_2 === 0.0)? true : false;
				$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION->IS_FREE_3 = ($CMD->DATA->PRICES->LIMIT_PRICE_3 === 0.0)? true : false;
				
				$CMD->DATA->PRICES->FREE = false;
				$CMD->DATA->PRICES->DEFAULT = false;
			}
			
			$images = false;	
			$images_count = 0;			
			if((isset($CMD->DATA->IMAGES))){
				$images = $CMD->DATA->IMAGES;	
				$images_count = count((array)$CMD->DATA->IMAGES);
			}
			
			$user = $this->ROOT->INFOS->id_unique;				
			$date = dateTimePARIS_FR();				
			$name = my_trim($CMD->DATA->NAME);    
			$description  = my_trim($CMD->DATA->DESCRIPTION);    
			$prices = json_encode($CMD->DATA->PRICES);

			$root = "null";			
			if(!isset($CMD->DATA->HAS_ROOT) && isset($CMD->DATA->ROOT) && my_trim($CMD->DATA->ROOT) !== "" ){
				$root = "'".$CMD->DATA->ROOT."'";
			}
			
			$roles_free = (isset($CMD->DATA->ROLES_FREE_DOWNLOAD)) ? "'".json_encode($CMD->DATA->ROLES_FREE_DOWNLOAD)."'" : "null";											
			$roles = (isset($CMD->DATA->ROLES)) ? "'".json_encode($CMD->DATA->ROLES)."'" : "null";					
			
			$ispublic = (isset($CMD->DATA->PUBLISH) && $CMD->DATA->PUBLISH === true) ? 1 : 0;
			
			$sql = "insert into galery(name,description,isfree,prices,root,roles,roles_free,usercreate,datecreate,id_unique,ispublic,images_count)
			values('$name','$description',$isfree,'$prices',$root,$roles,$roles_free,'$user','$date','$id_unique',$ispublic,$images_count)";						
			if($this->SYSTEM->sql_query($sql) === false) return $CMD;	
			if($this->SYSTEM->set_galery_images($id_unique,$images) !== false) $CMD->EXECUTE = true;					
			return $CMD;  
			
        }catch(Exception $e){
			$CMD->INPUT = "INPUT-NAME";
            $CMD->EXECUTE = false;
			$MSG_ERROR = "(1024)Une erreur importante s'est produire durant l'exécution.<br>veuillez nous en excuser.";	
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
			return $CMD;
        }
    }
	public function UPDATE_GALERY($CMD){
        try{
		
			$CMD->EXECUTE = false;  
			if( 				
				$this->SYSTEM->has_role("GALERY_UPDATE_ALL") === false
				&& $this->SYSTEM->has_role("GALERY_UPDATE_OWN") === false 
			){	
				$MSG_ERROR = "(2)Imposible de modifier la galérie, accès refusé";
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
				return $CMD;
			}
			
			$CMD->INPUT = "INPUT-NAME";
			$MSG_ERROR = "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>Une erreur(102) est survenue lors de l'exécution de la commande";			
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
			if(!isset($CMD->DATA->NAME) || my_trim($CMD->DATA->NAME) === ""){
				$MSG_ERROR = "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La saisie du nom de la galérie est obligatoire";
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
				return $CMD;
			}
			if(!isset($CMD->DATA->DESCRIPTION) || my_trim($CMD->DATA->DESCRIPTION) === ""){
				$CMD->INPUT = "INPUT-DESCRIPTION";
				$MSG_ERROR = "<script language='javascript'>$('#INPUT-DESCRIPTION').addClass('error').focus();</script>La saisie de la description de la galérie est obligatoire";
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
				return $CMD;
			}
			
			$id_unique = $CMD->ID_UNIQUE;							
			$result = $this->SYSTEM->sql_select_one("select * from galery where name='".my_trim($DATA->DATA->NAME)."' limit 1");
			if($result !== false && $result->id_unique !== $id_unique){				
				$MSG_ERROR = "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La galérie '".my_trim($DATA->NAME)."' existe déj&agrave;";
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
				return $CMD;
			}
			
			$isfree = 0;
			
			$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION = new stdClass;
			$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION->IS_FREE_2 = false;
			$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION->IS_FREE_3 = false;
				
			if(isset($CMD->DATA->PRICES->FREE) &&  $CMD->DATA->PRICES->FREE === true){
				
				$CMD->DATA->PRICES->DEFAULT = false;
				$CMD->DATA->PRICES->DEGRESSIVITY = false;
				$isfree = 1;		
			}
			elseif(isset($CMD->DATA->PRICES->DEFAULT) &&  $CMD->DATA->PRICES->DEFAULT === true){

				$price = ( !isset($CMD->DATA->PRICES->PRICE)  || my_trim($CMD->DATA->PRICES->PRICE) === "")? 0.0 : (float)$CMD->DATA->PRICES->PRICE;
									
				if($price <= 0.0){		
					$CMD->INPUT = "INPUT-PRICE";
					$MSG_ERROR = "<script language='javascript'>$('#INPUT-PRICE').addClass('error').focus();</script>Le prix d'une image par défaut doit être supérieur &agrave; 0€";
					$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
					return $CMD;
				}
				
				$isfree = ($price === 0.0)? 1 : 0;
				$CMD->DATA->PRICES->PRICE = $price;					
				$CMD->DATA->PRICES->DEGRESSIVITY = false;
				$CMD->DATA->PRICES->FREE = false;
			}
			else{
			
				$CMD->DATA->PRICES->LIMIT_PRICE_1 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_1) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_1) === "")? 0.0 : (float)$CMD->DATA->PRICES->LIMIT_PRICE_1;
				$CMD->DATA->PRICES->LIMIT_PRICE_2 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_2) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_2) === "")? 0.0 : (float)$CMD->DATA->PRICES->LIMIT_PRICE_2;
				$CMD->DATA->PRICES->LIMIT_PRICE_3 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_3) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_3) === "")? 0.0 : (float)$CMD->DATA->PRICES->LIMIT_PRICE_3;

				$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_1 = 1;
				$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2) === "")? 0 : (int)$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2;
				$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3 = ( !isset($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3) || my_trim($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3) === "")? 0 : (int)$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3;
				
				if($CMD->DATA->PRICES->LIMIT_PRICE_1 <= 0.0){
					$CMD->INPUT = "INPUT-LIMIT_PRICE_1";	
					$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_1').addClass('error').focus();</script>Le prix(1) de l'image doit être supérieur &agrave; 0€ pour appliquer la dégressivité";
					$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
					return $CMD;
				}
				
				if($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2 > 0){
					if($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2 <= $CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_1){						
						$CMD->INPUT = "INPUT-LIMIT_PRICE_IMAGECOUNT_2";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_IMAGECOUNT_2').addClass('error').focus();</script>Le nombre de base d'image(2) de l'image doit être supérieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_1} pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}
					
					if($CMD->DATA->PRICES->LIMIT_PRICE_2 >= $CMD->DATA->PRICES->LIMIT_PRICE_1){
						$CMD->INPUT = "INPUT-LIMIT_PRICE_2";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_2').addClass('error').focus();</script>Le prix(1) de l'image doit être inférieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_1}€ pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}					
				}else $CMD->DATA->PRICES->LIMIT_PRICE_2 = 0.0;
				
				if($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3 > 0){
					if($CMD->DATA->PRICES->LIMIT_PRICE_2 === 0.0){
						$CMD->INPUT = "INPUT-LIMIT_PRICE_2";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_2').addClass('error').focus();</script>Le prix(2) de l'image doit être inférieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_1}€ et supérieur à 0€ pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}
					if($CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_3 <= $CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2){						
						$CMD->INPUT = "INPUT-LIMIT_PRICE_IMAGECOUNT_3";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_IMAGECOUNT_3').addClass('error').focus();</script>Le nombre de base d'image(2) de l'image doit être supérieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_IMAGECOUNT_2} pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}
					if($CMD->DATA->PRICES->LIMIT_PRICE_3 >= $CMD->DATA->PRICES->LIMIT_PRICE_2){
						
						$CMD->INPUT = "INPUT-LIMIT_PRICE_3";	
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-LIMIT_PRICE_3').addClass('error').focus();</script>Le prix(3) de l'image doit être inférieur &agrave; {$CMD->DATA->PRICES->LIMIT_PRICE_2}€ pour appliquer la dégressivité";
						$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
						return $CMD;
					}
				}else $CMD->DATA->PRICES->LIMIT_PRICE_3 = 0.0;
					
				$isfree = 0;			
				$CMD->DATA->PRICES->DEGRESSIVITY = true;
				$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION = new stdClass;
				$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION->IS_FREE_2 = ($CMD->DATA->PRICES->LIMIT_PRICE_2 === 0.0)? true : false;
				$CMD->DATA->PRICES->DEGRESSIVITY_PRECISION->IS_FREE_3 = ($CMD->DATA->PRICES->LIMIT_PRICE_3 === 0.0)? true : false;
				$CMD->DATA->PRICES->FREE = false;
				$CMD->DATA->PRICES->DEFAULT = false;
			}						
						
			$images = false;	
			$images_count = 0;			
			if((isset($CMD->DATA->IMAGES))){
				$images = $CMD->DATA->IMAGES;	
				$images_count = count((array)$CMD->DATA->IMAGES);
			}
			
			$user = $this->ROOT->INFOS->id_unique;				
			$date = dateTimePARIS_FR();				
			$name = my_trim($CMD->DATA->NAME);    
			$description  = my_trim($CMD->DATA->DESCRIPTION);    
			$prices = json_encode($CMD->DATA->PRICES);

			$root = "null";			
			if(!isset($CMD->DATA->HAS_ROOT) && isset($CMD->DATA->ROOT) && my_trim($CMD->DATA->ROOT) !== "" ){
				$root = "'".$CMD->DATA->ROOT."'";
			}
						
			$roles_free = (isset($CMD->DATA->ROLES_FREE_DOWNLOAD)) ? "'".json_encode($CMD->DATA->ROLES_FREE_DOWNLOAD)."'" : "null";											
			$roles = (isset($CMD->DATA->ROLES)) ? "'".json_encode($CMD->DATA->ROLES)."'" : "null";					
			
			$ispublic = (isset($CMD->DATA->PUBLISH) && $CMD->DATA->PUBLISH === true) ? 1 : 0;
			
			$sql = "update galery set name='$name',description='$description',isfree=$isfree,prices='$prices',root=$root,roles=$roles,roles_free=$roles_free,userupdate='$user',dateupdate='$date',ispublic=$ispublic,images_count=$images_count where id_unique='$id_unique'";						
			if($this->SYSTEM->sql_query($sql) === false) return $CMD;
			
			$CMD->__img = $sql;
			
			if($this->SYSTEM->set_galery_images($id_unique,$images) !== false) $CMD->EXECUTE = true;					
			
			return $CMD;  

        }catch(Exception $e){
            $CMD->EXECUTE = false;
			$MSG_ERROR = "(1024)Une erreur importante s'est produire durant l'exécution.<br>veuillez nous en excuser.";	
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
			return $CMD;
        }
    }
	public function REMOVE_GALERY($CMD){
        try{
			$CMD->EXECUTE = false;
			if( 				
				$this->SYSTEM->has_role("GALERY_DELETE_ALL") === false
				&& $this->SYSTEM->has_role("GALERY_DELETE_OWN") === false 
			){								
				$CMD->CONTENT = "<font style='color:red;'>Vous n'avez pas les droits pour effectuer cette action</font>";
				return $CMD;
			}	
			
			$CMD->CONTENT = "<font style='color:red;'>Une erreur(102) est survenue lors de l'exécution de la commande.<br>Veuillez nous en excuser</font>";			
            $date = dateTimePARIS_FR();
            $user = $this->ROOT->INFOS->id_unique;
            $id_unique = $CMD->DATA->ID_UNIQUE;
           
            $this->SYSTEM->sql_query("update images set galeryid=NULL,userupdate='$user',dateupdate='$date' where galeryid='$id_unique' ");
                      
            if( $this->SYSTEM->sql_query("delete from galery WHERE id_unique='$id_unique' ; ") === false){				
				$CMD->CONTENT = "<font style='color:red;'>Une erreur(104) est survenue lors de l'exécution</font>";
				return $CMD;
			}	
			$CMD->EXECUTE = true;	
            return $CMD;
        }catch(Exception $e){
			$CMD->CONTENT = "<font style='color:red;'>Une erreur(1024) est survenue lors de l'exécution</font>";	
            $CMD->EXECUTE = false;	
            return $CMD;
        }
    }
	
	/************ IMPORT IMAGES **********/
	
	public function GET_DO_IMPORT_IMAGES($CMD){
         try{						
			$val = do_import_image($this->ROOT,$CMD->DATA);	
			$CMD->CONTENT ="Impossible d'enregistrer l'image à importer";
			$CMD->EXECUTE = false;
			if($val === false) return $CMD;			
			$sql = "insert into images(id_unique,name,roles,cryptname,smallname,bigname,bigname_notext,width,height,datecreate,usercreate)values('".$val->id_unique."','".$val->name."',null,'".$val->cryptname."','".$val->smallname."','".$val->bigname."','".$val->bigname_notext."',".$val->width.",".$val->height.",'".$val->datecreate."','".$val->usercreate."')";
			if($this->SYSTEM->sql_query($sql) === false) return $CMD;		
			$CMD->EXECUTE = true;
			$CMD->VALUE = $val;
			return $CMD;
        }catch(Exception $e){
			$CMD->CONTENT="Impossible d'enregistrer l'image à importer";
            $CMD->EXECUTE = false;			
            return $CMD;
        } 
    }
	public function GET_ALL_NO_IMPORT_IMAGES($CMD){
        try{			
			$CMD->DATA = get_import_image_one($this->ROOT,$CMD->DATA);
			return $CMD;
        }catch(Exception $e){
            $CMD->DATA = false;			
            return $CMD;
        } 
    }
	public function GET_ALL_NO_IMPORT_IMAGES_LIST($CMD){
        try{			
			$result = get_import_images(true,$CMD);
			$CMD->DATA->BANK = $result->TABLE;
			$CMD->DATA->LIST = $result->LIST;
			$CMD->DATA->COUNT_BANK = $result->COUNT;
			return $CMD;
        }catch(Exception $e){
            $CMD->DATA = false;
            return $CMD;
        }
    }
	public function REMOVE_IMAGE_IMPORT($CMD){
        try{			
			$CMD->CONTENT="Impossible de supprimer l'image à importer";
			$CMD->EXECUTE = remove_import_image($CMD->DATA->IMAGE);
			return $CMD;
        }catch(Exception $e){
			$CMD->CONTENT="Impossible de supprimer l'image à importer";	
            $CMD->EXECUTE = false;			
            return $CMD;
        } 
    }
	
	/************  IMAGES **********/
	
	public function GET_ALL_IMAGES($CMD){
        try{
			if( $this->SYSTEM->has_role("IMAGES_VIEW_ALL") === false && $this->SYSTEM->has_role("IMAGES_VIEW_OWN") === false ){
				$CMD->DATA->GALERY_ALL = false;
				$CMD->DATA->GALERY_AFFECTED = false;
				$CMD->DATA->GALERY_NO_AFFCTED = false;
				$CMD->DATA->URI = "src/process.php";
				$CMD->DATA->COUNT_GALERY_ALL = 0;
				$CMD->DATA->COUNT_GALERY_AFFECTED = 0;
				$CMD->DATA->COUNT_GALERY_NO_AFFCTED = 0;
				return $CMD;
			}
			
			$result_list = new stdClass;	
			$result_list->view = true;
			$result_list->data = false;
			$result_list->import = $this->SYSTEM->has_role("IMAGES_CREATE");			
			$result_list->update = $this->SYSTEM->has_role("IMAGES_UPDATE_ALL");
			$result_list->update_own = $this->SYSTEM->has_role("IMAGES_UPDATE_OWN");
			$result_list->delete = $this->SYSTEM->has_role("IMAGES_DELETE_ALL");
			$result_list->delete_own = $this->SYSTEM->has_role("IMAGES_DELETE_OWN");
            $usercreate = ($this->ROOT->IS_ROOT === true || $this->SYSTEM->has_role("IMAGES_VIEW_ALL") === true)? "" : " WHERE usercreate='".$this->ROOT->INFOS->id_unique."' ";           
            $result = $this->SYSTEM->sql_select("select * from images $usercreate  ORDER BY name ASC");                       
            if($result === false){
				$CMD->DATA->GALERY_ALL = false;
				$CMD->DATA->GALERY_AFFECTED = false;
				$CMD->DATA->GALERY_NO_AFFCTED = false;
				$CMD->DATA->URI = "src/process.php";
				$CMD->DATA->COUNT_GALERY_ALL = 0;
				$CMD->DATA->COUNT_GALERY_AFFECTED = 0;
				$CMD->DATA->COUNT_GALERY_NO_AFFCTED = 0;			
				return $CMD;
			}
			$all_list_remove = array();			
			$all_list = array();
			$affected_list = array();
			$not_affected_list = array();
            while ($row = mysqli_fetch_object($result)) {           
				$item =  new stdClass;
				if(!file_exists(str_replace("src/","",$row->bigname))){$all_list_remove[] = $row->id_unique; continue;}
				if(!file_exists(str_replace("src/","",$row->smallname))) {$all_list_remove[] = $row->id_unique; continue;}
				if(!file_exists($row->cryptname)) {$all_list_remove[] = $row->id_unique; continue;}
				$item->idx = $row->id_unique;
				$item->url_big = $row->bigname;
				$item->url_small = $row->smallname;
				$item->roles = false;
				$item->width = $row->width;
				$item->height = $row->height;
				$item->put_update =  false;
				if($result_list->update) $item->put_update =  true;
				elseif($result_list->update_own === true && $row->usercreate === $this->ROOT->INFOS->id_unique){
				   $item->put_update =  true;
				}
				$item->put_delete =  false;
				if($result_list->delete) $item->put_delete =  true;
				elseif($result_list->delete_own === true && $row->usercreate === $this->ROOT->INFOS->id_unique){
				   $item->put_delete =  true;
				}
				if( isset($row->roles) && my_trim($row->roles) !== "") $item->roles = json_decode($row->roles);
				$item->ispublic = ($item->roles === false )? true : false ;
				$all_list[$row->id_unique] = $item; 
				if(isset($row->galeryid) && my_trim($row->galeryid) !== "") $affected_list[$row->id_unique] = $item; 
				else $not_affected_list[$row->id_unique] = $item;         
            }
            mysqli_free_result($result);       
			$this->SYSTEM->sql_close();
			if(count($all_list_remove) > 0){
				$idx = "('".join("','",$idx)."')";
				$this->SYSTEM->sql_query("REMOVE FROM images where id_unique IN {$idx} ");
			}
			$CMD->DATA->URI = "src/process.php";
			$CMD->DATA->GALERY_ALL = $all_list;
			$CMD->DATA->GALERY_AFFECTED = $affected_list;
			$CMD->DATA->GALERY_NO_AFFCTED = $not_affected_list;			
			$CMD->DATA->COUNT_GALERY_ALL = count($all_list);
			$CMD->DATA->COUNT_GALERY_AFFECTED = count($affected_list);
			$CMD->DATA->COUNT_GALERY_NO_AFFCTED = count($not_affected_list);
			return $CMD;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }	
	
	/**** MOBULES GENERIC *****/
	
	public function GET_LIST($CMD){
		 try{
			
			$images_count  = $this->SYSTEM->purge_images();	
			
			$CMD->COUNT = 0;
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			if($this->SYSTEM->has_role($CMD->DOCUMENT."_VIEW_ALL") === false && $this->SYSTEM->has_role($CMD->DOCUMENT."_VIEW_OWN") === false){								
				$CMD->CONTENT = "<font style='color:red;font-size:16px;'>Vous n'avez pas les droits pour effectuer cette action</font>";
				return $CMD;
			}
			$filter = ($this->SYSTEM->has_role($CMD->DOCUMENT."_VIEW_ALL") === true)? "" : " where  usercreate='".$this->ROOT->INFOS->id_unique."' "; 					
			$result = $this->SYSTEM->sql_select("select * from ".$CMD->TABLE." $filter ORDER BY ".$CMD->TABLE_ORDER." ASC");               
			if($result === false){			
				$CMD->CONTENT = "<font style='color:black;font-size:16px;'>Liste vide </font>";
				return $CMD;
			}
			$btn = "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_DETAIL' {$CMD->ID_UNIQUE_STRING}_DETAIL=true ><div title='Détailler'></div></td>";
			$btn .= ($this->SYSTEM->has_role($CMD->DOCUMENT."_REMOVE_ALL") === true || $this->SYSTEM->has_role($CMD->DOCUMENT."_REMOVE_OWN") === true)? "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_REMOVE' {$CMD->ID_UNIQUE_STRING}_REMOVE=true ><div  title='Supprimer'></div></td>"  : "";
			$btn .= ($this->SYSTEM->has_role($CMD->DOCUMENT."_UPDATE_ALL") === true || $this->SYSTEM->has_role($CMD->DOCUMENT."_UPDATE_OWN") === true)? "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_UPDATE' {$CMD->ID_UNIQUE_STRING}_UPDATE=true ><div  title='Modifier'></div></td>"  : "";
			$tr = "";
			$parity = "impair";
			$i = 0;
            while ($row = mysqli_fetch_object($result)){
				$id_unique = $row->id_unique;
				$info_remove = "";				
				if(isset($CMD->FIELDS_REMOVE) && isset($CMD->FIELDS_REMOVE_LABEL)  ){
					foreach($CMD->FIELDS_REMOVE as $key => $__field){
						if(isset($row->$__field) && isset($CMD->FIELDS_REMOVE_LABEL->$key) ){
							$key_name = $CMD->FIELDS_REMOVE_LABEL->$key;
							$info_remove .= ($info_remove === "")? "$key_name=".$row->$__field : "|"."$key_name=".$row->$__field; 
						}
					}
				}		
				if($info_remove !== ""){$info_remove = " DATA_INFOS='".$info_remove."' ";}
				$tr .= "<tr ".$id_unique."_LINE_TR=true {$info_remove} class='{$parity}'>".str_replace("@@ID_UNIQUE@@",$id_unique,$btn);
				if($CMD->DOCUMENT === "GALERY"){
					$prices = json_decode($row->prices);
					$type_label = "gratuit";
					if($prices->DEFAULT === true) $type_label = "payant";
					elseif($prices->DEGRESSIVITY === true) $type_label = "degressif";
					$tr .= "<td valign=middle class='{$type_label}'>{$type_label}</td>";
				}
				
				++$i;
				foreach($CMD->FIELDS as $key => $__field){
					$_name = explode("-",$__field); 
					$_field = $_name[0];
					$_name = (count($_name) > 1)? $_name[1] : "";
					if(isset($row->$_field)){
						if($_field === "ispublic"){
							if((int)$row->$_field === 0) $tr .= "<td class='admin'><div title='administratif'></div></td>";
							else $tr .= "<td valign=middle class='client'><div title='client'></div></td>";
						}
						elseif($_field === "root" && $CMD->DOCUMENT === "GALERY"){
							$root =( isset($row->root) && my_trim($row->root) !== "")?$this->SYSTEM->get_galery_root($row->root) : false;													
							if($root  === false) $tr .= "<td valign=middle class='empty'></td>";	
							else $tr .= "<td valign=middle class='{$_field}'><div title='racine' {$id_unique}_{$_field}=true >".urldecode($root->name)." {$_name}</div></td>";	
						}
						elseif($_field === "images_count" && $CMD->DOCUMENT === "GALERY"){
							$count = 0;
							if($images_count->max_real > 0){
								$count = $this->SYSTEM->get_galery_image_count($id_unique);
							}
							if($count <= 0) $tr .= "<td valign=middle class='{$_field} no_image' UN_ESCAPE=true {$id_unique}_{$_field}=true >{$count} {$_name}</td>";	
							else $tr .= "<td valign=middle class='{$_field}'  {$id_unique}_{$_field}=true  UN_ESCAPE=true>{$count} {$_name}</td>";	
						}												
						elseif(my_trim($row->$_field) === "" || empty($row->$_field)) $tr .= "<td class='empty'>-</td>";					
						else $tr .= "<td valign=middle class='{$_field}' UN_ESCAPE=true>".$row->$_field." {$_name}</td>";						
					}elseif($_field === "roles"){
						$tr .= "<td valign=middle class='client'><div title='client'></div></td>";					
					}
					else{
						$tr .= "<td valign=middle class='empty'>-</td>";
					}
				}	
				$tr .= "</tr>";	
				$parity = ($parity === "impair")? "pair" :"impair";				
            }	
            mysqli_free_result($result);       
			$this->SYSTEM->sql_close();
			$CMD->EMPTY = false;
			$CMD->EXECUTE = true;
			$CMD->CONTENT = "<table id='".$CMD->ID_UNIQUE_STRING."_TABLE' cellspacing='0' cellpadding='0' border='0' style='width:100%;height:auto;'>{$tr}</table>";
			$CMD->COUNT = $i;
			return $CMD;
        }catch(Exception $e){
            $CMD->COUNT = 0;
			$CMD->EMPTY = true;
			$CMD->EXECUTE = false;
			$CMD->CONTENT = "<font style='color:red;font-size:16px;'>une erreur(1024) est survenue lors de l'exécution</font>";
			return $CMD;
        }
	}
	public function REMOVE_MODULE($CMD){
        try{
			$CMD->EXECUTE = false;
			if( 				
				$this->SYSTEM->has_role($CMD->DOCUMENT."_DELETE_ALL") === false
				&& $this->SYSTEM->has_role($CMD->DOCUMENT."_DELETE_OWN") === false 
			){								
				$CMD->CONTENT = "<font style='color:red;'>Vous n'avez pas les droits pour effectuer cette action</font>";
				return $CMD;
			}	
			$CMD->CONTENT = "<font style='color:red;'>Une erreur(102) est survenue lors de l'exécution de la commande.<br>Veuillez nous en excuser</font>";			
            if( $this->SYSTEM->sql_query("delete from ".$CMD->TABLE." WHERE id_unique='".$CMD->DATA->ID_UNIQUE."' ; ") === false){				
				$CMD->CONTENT = "<font style='color:red;'>Une erreur(104) est survenue lors de l'exécution</font>";
				return $CMD;
			}	
			$CMD->EXECUTE = true;	
            return $CMD;
        }catch(Exception $e){
			$CMD->CONTENT = "<font style='color:red;'>Une erreur(1024) est survenue lors de l'exécution</font>";	
            $CMD->EXECUTE = false;	
            return $CMD;
        }
    }	
	
	/******* PARAMS SYSTEMS (OPTIONS) ****/
	
	public function UPDATE_CONFIG($CMD){
		try{  			
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>Impossible d'effectuer la modification</font>";				
			if(update_config($data) === true){
				$CMD->CONTENT = "Enregistrement OK";
				$CMD->EXECUTE = false;
				$CMD->EMPTY = true;	
			}
			return $CMD;
        }catch(Exception $e){
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			return $CMD;
        }
	}	
	public function UPDATE_CONFIG_TEXT_IMAGE($CMD){
		try{  			
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			$val = $CMD->DATA;			
			$MSG_ERROR = (isset($val->image_copyright->text) && my_trim($val->image_copyright->text) !== "")? "" : "<script language='javascript'>$('#INPUT-text').addClass('error').focus();</script>La saisie du text est obligatoire";				
			if($MSG_ERROR === "") $MSG_ERROR = (isset($val->image_copyright->color->r) && is_numeric($val->image_copyright->color->r) === true)? "" : "<script language='javascript'>$('#INPUT-r').addClass('error').focus();</script>La saisie de la couleur ROUGE du text est obligatoire et doit être numérique";				
			if($MSG_ERROR === "") $MSG_ERROR = (isset($val->image_copyright->color->g) && is_numeric($val->image_copyright->color->g) === true)? "" : "<script language='javascript'>$('#INPUT-g').addClass('error').focus();</script>La saisie de la couleur VERTE du text est obligatoire et doit être numérique";
			if($MSG_ERROR === "") $MSG_ERROR = (isset($val->image_copyright->color->b) && is_numeric($val->image_copyright->color->b) === true)? "" : "<script language='javascript'>$('#INPUT-b').addClass('error').focus();</script>La saisie de la couleur BLEUE du text est obligatoire et doit être numérique";
			if($MSG_ERROR === "") $MSG_ERROR = (isset($val->image_copyright->rotation) && is_numeric($val->image_copyright->rotation) === true)? "" : "<script language='javascript'>$('#INPUT-rotation').addClass('error').focus();</script>La saisie de l'angle de ROTATION du text est obligatoire et doit être numérique";				
			if($MSG_ERROR === "") $MSG_ERROR = (isset($val->image_copyright->size) && is_numeric($val->image_copyright->size) === true)? "" : "<script language='javascript'>$('#INPUT-size').addClass('error').focus();</script>La saisie de la taille du text est obligatoire et doit être numérique";
			if($MSG_ERROR === "") $MSG_ERROR = (isset($val->image_copyright->x) && is_numeric($val->image_copyright->x) === true)? "" : "<script language='javascript'>$('#INPUT-x').addClass('error').focus();</script>La saisie de la position X du text est obligatoire et doit être numérique";
			if($MSG_ERROR === "") $MSG_ERROR = (isset($val->image_copyright->y) && is_numeric($val->image_copyright->y) === true)? "" : "<script language='javascript'>$('#INPUT-y').addClass('error').focus();</script>La saisie de la position Y du text est obligatoire et doit être numérique";
			if($MSG_ERROR === "" && update_config($val) === true){
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/info.png' width='20px' height='20px'> <font style='color:#06539F;'>Modification effectué avec succès</font>";				
				$CMD->EXECUTE = false;
				$CMD->EMPTY = true;	
				$MSG_ERROR = "Impossible de modifier les paramètre du text à afficher sur l'image";
			}
			else{
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";				
			}
			return $CMD;
        }catch(Exception $e){
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			return $CMD;
        }
	}
	public function GET_CONFIG_PARAMS($CMD){
		try{  			
			$val = load_params();
			$obj = new stdClass;
			$obj->r = $val->image_copyright->color->r;
			$obj->g = $val->image_copyright->color->g;
			$obj->b = $val->image_copyright->color->b;
			$obj->text = $val->image_copyright->text;
			$obj->rotation = $val->image_copyright->rotation;
			$obj->size =  $val->image_copyright->size;
			$obj->x = $val->image_copyright->x;
			$obj->y = $val->image_copyright->y;
			$obj->EMAIL = $val->paypal->login;
			$obj->pwd = $val->paypal->pwd;
			$obj->signature = $val->paypal->signature;
			$obj->price = $val->paypal->price;
			$CMD->EXECUTE = true;
			$CMD->CONTENT = $obj;
			return $CMD;
        }catch(Exception $e){
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			return $CMD;
        }
	}
	public function UPDATE_PAYPAL_EMAIL($CMD){
		try{  			
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			$MSG_ERROR = (isset($CMD->DATA->EMAIL) && my_trim($CMD->DATA->EMAIL) !== "")? "" : "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>La saisie de votre nouvelle adresse mail paypal est obligatoire";				
			if($MSG_ERROR === "") $MSG_ERROR = (filter_var($CMD->DATA->EMAIL, FILTER_VALIDATE_EMAIL) !== false) ? "" : "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>veuillez saisir une nouvelle adresse mail valide";			
			if($MSG_ERROR === "") $MSG_ERROR = (isset($CMD->DATA->EMAIL2) && my_trim($CMD->DATA->EMAIL2) !== "")? "" : "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Veuillez saisir à nouveau votre nouvelle adresse mail";			
			if($MSG_ERROR === "") $MSG_ERROR = ($CMD->DATA->EMAIL === $CMD->DATA->EMAIL2)? "" : "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Saisie incorrect. Veuillez saisir à nouveau votre adresse mail";
			if($MSG_ERROR === "") {
				$data = new stdClass;
				$data->paypal  = new stdClass;
				$data->paypal->login = $CMD->DATA->EMAIL;
				if(update_config($data) === false){
					$MSG_ERROR = "Impossible de modifier votre adresse mail paypal";
				}
				else{
					$content = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/MAIL/RENEW_EMAIL_PAYPAL.html",$CMD);
					$content = str_replace("@@ACCOUNT-EMAIL@@",$CMD->DATA->EMAIL,$content);								
					send_mail_to($this->ROOT->PARAMS_MAIL->ADMIN,$this->ROOT->INFOS->email,$result->prenom." ".$result->nom,"MODIFICATION ADRESSE MAIL PAYPAL",$content);					
					$CMD->EMPTY = false;
					$CMD->EXECUTE = true;
				}			
			}
			if($MSG_ERROR !== "") {
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";				
			}
			return $CMD;
        }catch(Exception $e){
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			return $CMD;
        }
	}
	
	/******* ACCESS MY ACCOUNT ****/
	
	public function UPDATE_PWD($CMD){
		try{  			
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			$MSG_ERROR = (isset($CMD->DATA->PWD) && my_trim($CMD->DATA->PWD) !== "")? "" : "<script language='javascript'>$('#INPUT-PWD').addClass('error').focus();</script>La saisie de votre nouveau mot de passe est obligatoire";							
			if($MSG_ERROR === "") $MSG_ERROR = (isset($CMD->DATA->PWD2) && my_trim($CMD->DATA->PWD2) !== "")? "" : "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Veuillez saisir à nouveau votre nouveau mot de passe";			
			if($MSG_ERROR === "") $MSG_ERROR = ($CMD->DATA->PWD === $CMD->DATA->PWD2)? "" : "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Saisie incorrect. Veuillez saisir à nouveau votre nouveau mot de passe";
			if($MSG_ERROR === "") {
				if($this->ROOT->IS_ROOT === true){
					if(update_root(false,$CMD->DATA->PWD,$this->ROOT->CRT) === false){
						$MSG_ERROR = "Impossible de modifier votre mot de passe";
					}
					else{
						$content = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/MAIL/UPDATE_PWD.html",$CMD);
						$content = str_replace("@@ACCOUNT-PWD@@",$CMD->DATA->PWD,$content);
						$content = str_replace("@@ACCOUNT-EMAIL@@",$this->ROOT->INFOS->email,$content);								
						send_mail_to($this->ROOT->PARAMS_MAIL->ADMIN,$this->ROOT->INFOS->email,$result->prenom." ".$result->nom,"MODIFICATION ADRESSE MAIL",$content);					
						$CMD->EMPTY = false;
						$CMD->EXECUTE = true;						
					}
				}
				else{
					$user = ($this->ROOT->CONNECTED === true)? $this->ROOT->INFOS->id_unique : md5("SYSTEM");
					$date = dateTimePARIS_FR();			
					$sql = "UPDATE users SET pwd='".md5($CMD->DATA->PWD)."',dateupdate='$date',userupdate='$user' WHERE id_unique='{$this->ROOT->INFOS->id_unique}' ;";
					if($this->SYSTEM->sql_query($sql) === false){
						$MSG_ERROR = "Impossible de modifier votre adresse mail";	
					}
					else{					
						$content = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/MAIL/UPDATE_PWD.html",$CMD);
						$content = str_replace("@@ACCOUNT-PWD@@",$CMD->DATA->PWD,$content);
						$content = str_replace("@@ACCOUNT-EMAIL@@",$this->ROOT->INFOS->email,$content);								
						send_mail_to($this->ROOT->PARAMS_MAIL->ADMIN,$this->ROOT->INFOS->email,$result->prenom." ".$result->nom,"MODIFICATION ADRESSE MAIL",$content);					
						$CMD->EMPTY = false;
						$CMD->EXECUTE = true;
					}
				}
			}
			if($MSG_ERROR !== "") {
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";				
			}
			return $CMD;
        }catch(Exception $e){
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			return $CMD;
        }
	}
	public function UPDATE_EMAIL($CMD){
		try{  			
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			$MSG_ERROR = (isset($CMD->DATA->EMAIL) && my_trim($CMD->DATA->EMAIL) !== "")? "" : "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>La saisie de votre nouvelle adresse mail est obligatoire";				
			if($MSG_ERROR === "") $MSG_ERROR = (filter_var($CMD->DATA->EMAIL, FILTER_VALIDATE_EMAIL) !== false) ? "" : "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>veuillez saisir une nouvelle adresse mail valide";			
			if($MSG_ERROR === "") $MSG_ERROR = (isset($CMD->DATA->EMAIL2) && my_trim($CMD->DATA->EMAIL2) !== "")? "" : "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Veuillez saisir à nouveau votre nouvelle adresse mail";			
			if($MSG_ERROR === "") $MSG_ERROR = ($CMD->DATA->EMAIL === $CMD->DATA->EMAIL2)? "" : "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Saisie incorrect. Veuillez saisir à nouveau votre adresse mail";
			if($MSG_ERROR === "") {
				if(($result = $this->SYSTEM->sql_select_one("select * from users where email='".$CMD->DATA->EMAIL."' limit 1")) !== false && $result->id_unique !== $this->ROOT->INFOS->id_unique){
					$MSG_ERROR = "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>L'adresse mail existe déjà ";	
				}
			}			
			if($MSG_ERROR === "") {
				if($this->ROOT->IS_ROOT === true){
					if(update_root($CMD->DATA->EMAIL,false,$this->ROOT->CRT) === false){
						$MSG_ERROR = "Impossible de modifier votre adresse mail";
					}
					else{
						$content = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/MAIL/RENEW_EMAIL.html",$CMD);
						$content = str_replace("@@ACCOUNT-EMAIL@@",$CMD->DATA->EMAIL,$content);								
						send_mail_to($this->ROOT->PARAMS_MAIL->ADMIN,$CMD->DATA->EMAIL,$result->prenom." ".$result->nom,"MODIFICATION ADRESSE MAIL",$content);					
						$CMD->EMPTY = false;
						$CMD->EXECUTE = true;
					}
				}
				else{
					$user = ($this->ROOT->CONNECTED === true)? $this->ROOT->INFOS->id_unique : md5("SYSTEM");
					$date = dateTimePARIS_FR();			
					$sql = "UPDATE users SET email='".my_trim($CMD->DATA->EMAIL)."',dateupdate='$date',userupdate='$user' WHERE id_unique='{$this->ROOT->INFOS->id_unique}' ;";
					if($this->SYSTEM->sql_query($sql) === false){
						$MSG_ERROR = "Impossible de modifier votre adresse mail";	
					}
					else{					
						$content = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/MAIL/RENEW_EMAIL.html",$CMD);
						$content = str_replace("@@ACCOUNT-EMAIL@@",$CMD->DATA->EMAIL,$content);								
						send_mail_to($this->ROOT->PARAMS_MAIL->ADMIN,$CMD->DATA->EMAIL,$result->prenom." ".$result->nom,"MODIFICATION ADRESSE MAIL",$content);					
						$CMD->EMPTY = false;
						$CMD->EXECUTE = true;
					}
				}
			}
			if($MSG_ERROR !== "") {
				$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";				
			}
			else{
				$this->ROOT->INFOS->email  = $CMD->DATA->EMAIL;
			}
			return $CMD;
        }catch(Exception $e){
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			return $CMD;
        }
	}
	public function USER_INFO($CMD){
		try{  			
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			$sql = "select * from users where id_unique='{$this->ROOT->INFOS->id_unique}' limit 1";
			$result = $this->SYSTEM->sql_select_one($sql);
			if($result !== false ){
				$obj = new stdClass;
				$obj->NAME = $result->nom;
				$obj->FIRSTNAME = $result->prenom;
				$obj->EMAIL = $result->email;
				$obj->CREATE = $result->datecreate;
				$obj->UPDATE = $result->dateupdate;
				$obj->LABEL = (isset($result->roles) && my_trim($result->roles) !== "")?"administrateur":"client" ;
				$obj->ADMIN = (isset($result->roles) && my_trim($result->roles) !== "")?"admin":"client" ;
				$CMD->EXECUTE = true;				
				$CMD->EMPTY = false;
				$CMD->CONTENT = $obj;
			}
			if($this->ROOT->IS_ROOT === true){
				$obj->LABEL = "root" ;
				$obj->ADMIN = "root" ;
				$CMD->EXECUTE = true;				
				$CMD->EMPTY = false;
				$CMD->CONTENT = true;
			}
			return $CMD;
        }catch(Exception $e){
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			return $CMD;
        }
	}
	public function MY_IMAGES($CMD){
		try{   
			$this->ROOT->MY_IMAGES = false;
			$CMD->COUNT = 0;
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			$sql = "select UNCOMPRESS(`data`) as data from users where id_unique='{$this->ROOT->INFOS->id_unique}' limit 1";
			$result = $this->SYSTEM->sql_select_one($sql);
			if($result !== false ){
							
				if(isset($result->data) && my_trim($result->data) !== ""){
					$_data = json_decode($result->data);
					$_list_img = array();
					foreach($_data as $key => $row){
						//if(local_images_exists($row) === false) continue;	
						$item =  new stdClass;						
						$item->name = $row->name;
						$item->idx = $row->idx;
						$item->url_big = $row->bigname;
						$item->url_small = $row->smallname;							  
						$item->width = (int)$row->width;
						$item->height = (int)$row->height;			   
						$item->roles = false;			    
						$item->isfree = true;
						$_list_img[$item->idx] = $item;
					}
					$CMD->EXECUTE = true;
					$CMD->COUNT = count((array)$_list_img);
					$CMD->EMPTY = ($CMD->COUNT > 0)? false : true;	
					$CMD->CONTENT = $_list_img;
				}
				$this->ROOT->MY_IMAGES = (array)$_data;
			}
			$CMD->PAY_RETURN = false;
			if(isset($this->ROOT->BASKET_PAY) && isset($this->ROOT->BASKET_PAY->PAY_PROCESS) && $this->ROOT->BASKET_PAY->PAY_PROCESS === true && isset($this->ROOT->BASKET_PAY->RESULT) && $this->ROOT->BASKET_PAY->ALREADY_USED === true){			
				$CMD->PAY_RETURN = $this->ROOT->BASKET_PAY->RESULT;				
				unset($this->ROOT->BASKET_PAY);
				if(isset($this->ROOT->BASKET_PAY->RESULT->buy) && $this->ROOT->BASKET_PAY->RESULT->buy === true){
					$this->ROOT->PANIER_COUNT = 0;
					foreach($this->ROOT->PANIER as $key => $img)unset($this->ROOT->PANIER[$key]);
				}
			}
			return $CMD;
        }catch(Exception $e){
			$CMD->COUNT = 0;
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			return $CMD;
        }
	}
	public function DO_CONNECT($CMD){
		try{			
			$MSG_ERROR = (isset($CMD->DATA->LOGIN) && my_trim($CMD->DATA->LOGIN) !== "")? "" : "<script language='javascript'>$('#INPUT-LOGIN').addClass('error').focus();</script>La saisie de votre identifiant est obligatoire";
			if($MSG_ERROR === "") $MSG_ERROR = (isset($CMD->DATA->PASSWORD) && my_trim($CMD->DATA->PASSWORD) !== "")? "" : "<script language='javascript'>$('#INPUT-PASSWORD').addClass('error').focus();</script>La saisie de votre mot de passe est obligatoire";
			if($MSG_ERROR === ""){
				if($this->SYSTEM->connect($CMD) === false)$MSG_ERROR = "<script language='javascript'>$('#INPUT-PASSWORD').addClass('error').focus();</script>Login ou mot de passe incorrect";
				else{					
					$CMD->DATA = $this->ROOT->INFOS->email;
					if(isset($CMD->CONTAINER_TO) && isset($CMD->PRECISION_TO)) {
						$CMD->CONTAINER = $CMD->CONTAINER_TO;
						$precision = $CMD->PRECISION_TO;
						return $this->$precision($CMD);
					}
					$DIR = (isset($CMD->DIR))? $CMD->DIR ."/".$CMD->PAGE : $CMD->PAGE;
					$CMD->RUN = "SHOW_CONTENT";					
					$CMD->CONTENT = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/{$DIR}.html",$CMD);							
					return $CMD;
				}					
			}		
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
			$CMD->DATA = false;
			return $CMD;
        }catch(Exception $e){
			$MSG_ERROR = "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>Une erreur non attendus est survenue lors de l'exécution.";
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
			$CMD->DATA = false;
            return $CMD;
        }
	}
	public function DO_DISCONNECT($CMD){
		try{			
			if($this->SYSTEM->disconnect($CMD) === true){				
				$DIR = (isset($CMD->DIR))? $CMD->DIR ."/".$CMD->PAGE : $CMD->PAGE;
				$CMD->RUN = "SHOW_CONTENT";
				$CMD->CONTENT = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/{$DIR}.html",$CMD);							
					return $CMD;
			}				
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
			$CMD->DATA = true;
			return $CMD;			
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}
	public function DO_RENEW_PWD($CMD){
		try{			
			$MSG_ERROR = "<script language='javascript'>$('#INPUT-EMAIL_RENEW').addClass('error').focus();</script>La saisie de votre adresse mail est obligatoire";
			if(isset($CMD->DATA) && $CMD->DATA !== false && isset($CMD->DATA->EMAIL_RENEW)){				
				$MSG_ERROR = (my_trim($CMD->DATA->EMAIL_RENEW) === "") ? "<script language='javascript'>$('#INPUT-EMAIL_RENEW').addClass('error').focus();</script>La saisie de votre adresse mail est obligatoire" : "" ;
				if($MSG_ERROR === "") $MSG_ERROR =(filter_var($CMD->DATA->EMAIL_RENEW, FILTER_VALIDATE_EMAIL) === false) ? "<script language='javascript'>$('#INPUT-EMAIL_RENEW').addClass('error').focus();</script>Veuillez saisir une adresse mail valide" : "" ;				
				if($MSG_ERROR === "") {
					if(($result = $this->SYSTEM->sql_select_one("select * from users where email='".$CMD->DATA->EMAIL_RENEW."' limit 1")) === false){
						$MSG_ERROR = "<script language='javascript'>$('#INPUT-EMAIL_RENEW').addClass('error').focus();</script>Le compte <font style='color:black;font-weight:bold;' ID_MAIL_ERROR_=true>".$CMD->DATA->EMAIL_RENEW."</font> n'existe pas ";	
					}
				}
			}
			if($MSG_ERROR === ""){				
				$MSG_ERROR = "<script language='javascript'>$('#INPUT-EMAIL_RENEW').addClass('error').focus();</script>Une erreur est survenue lors de la modification de votre mot de passe. Veuillez nous en excuser";	
				$idx = get_id(5);
				$pwd = md5($idx);  
				$user = ($this->ROOT->CONNECTED === true)? $this->ROOT->INFOS->id_unique : md5("SYSTEM");
				$date = dateTimePARIS_FR();			
				$sql = "update users set pwd='$pwd',userupdate='$user',dateupdate='$date' WHERE email='".$CMD->DATA->EMAIL_RENEW."'";			
				if( $this->SYSTEM->sql_query($sql) !== false){
					// SEND NEW PWD
					$MSG_ERROR = "<script language='javascript'>$('#INPUT-EMAIL_RENEW').addClass('error').focus();</script>Impossible d'envoyer le mail ";
					$content = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/MAIL/RENEW_PWD.html",$CMD);
					$content = str_replace("@@ACCOUNT-EMAIL@@",$CMD->DATA->EMAIL_RENEW,$content);
					$content = str_replace("@@ACCOUNT-PWD@@",$idx,$content);					
					if(send_mail_to($this->ROOT->PARAMS_MAIL->ADMIN,$CMD->DATA->EMAIL_RENEW,$result->prenom." ".$result->nom,"MODIFICATION MOT DE PASSE",$content) !== false){
						$CMD->CONTENT = "<font style='color:blue;font-size:14px;'><img src='images/info.png' width='20px' height='20px'>&nbsp;&nbsp;Votre nouveau mot de passe vous à été envoyé dans votre boîte mail &nbsp;:<font style='color:black;font-weight:bold;' ID_MAIL_ERROR_=true>".$CMD->DATA->EMAIL_RENEW."</font></font>";						
						return $CMD;
					}
				}				
			}	
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
			return $CMD;
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}
	public function DO_CREATE_ACCOUNT($CMD){
		try{			
			$MSG_ERROR = (isset($CMD->DATA->NAME) && my_trim($CMD->DATA->NAME) !== "")? "" : "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La saisie de votre nom est obligatoire";
			if($MSG_ERROR === "") $MSG_ERROR = (isset($CMD->DATA->FIRSTNAME) && my_trim($CMD->DATA->FIRSTNAME) !== "")? "" : "<script language='javascript'>$('#INPUT-FIRSTNAME').addClass('error').focus();</script>La saisie de votre prénom est obligatoire";
			if($MSG_ERROR === "") $MSG_ERROR = (isset($CMD->DATA->EMAIL) && my_trim($CMD->DATA->EMAIL) !== "")? "" : "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>La saisie de votre adresse mail est obligatoire";				
			if($MSG_ERROR === "") $MSG_ERROR = (filter_var($CMD->DATA->EMAIL, FILTER_VALIDATE_EMAIL) !== false) ? "" : "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>veuillez saisir une adresse mail valide";			
			if($MSG_ERROR === "") $MSG_ERROR = (isset($CMD->DATA->EMAIL2) && my_trim($CMD->DATA->EMAIL2) !== "")? "" : "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Veuillez saisir à nouveau votre adresse mail";			
			if($MSG_ERROR === "") $MSG_ERROR = ($CMD->DATA->EMAIL === $CMD->DATA->EMAIL2)? "" : "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Saisie incorrect. Veuillez saisir à nouveau votre adresse mail";					
			if($MSG_ERROR === "") $MSG_ERROR = (isset($CMD->DATA->PWD) && my_trim($CMD->DATA->PWD) !== "")? "" : "<script language='javascript'>$('#INPUT-PWD').addClass('error').focus();</script>La saisie de votre mot de passe est obligatoire";
			if($MSG_ERROR === "") $MSG_ERROR = (isset($CMD->DATA->PWD2) && my_trim($CMD->DATA->PWD2) !== "")? "" :  "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Veuillez saisir à nouveau votre mot passe";
			if($MSG_ERROR === "") $MSG_ERROR = ($CMD->DATA->PWD === $CMD->DATA->PWD2)? "" : "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Saisie incorrect. Veuillez saisir à nouveau votre mot de passe";
			if(($result = $this->SYSTEM->sql_select_one("select * from users where email='".$CMD->DATA->EMAIL."' limit 1")) !== false){
				$MSG_ERROR = "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>L'adresse mail existe déjà ";	
			}
			if($MSG_ERROR === ""){				
				$pwd = md5($CMD->DATA->PWD);  
				$user = ($this->ROOT->CONNECTED === true)? $this->ROOT->INFOS->id_unique : md5("SYSTEM");
				$date = dateTimePARIS_FR();
				$idx = get_id();
				$sql = "insert into users(nom,id_unique,prenom,pwd,email,roles,usercreate,datecreate,data) values('{$CMD->DATA->NAME}','$idx','{$CMD->DATA->FIRSTNAME}','$pwd','{$CMD->DATA->EMAIL}',null,'$user','$date',null)";			
				if( $this->SYSTEM->sql_query($sql) !== false){
					$MSG_ERROR = "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>Impossible d'envoyer le mail ";
					$content = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/MAIL/NEW_ACCOUNT.html",$CMD);
					$content = str_replace("@@ACCOUNT-EMAIL@@",$CMD->DATA->EMAIL,$content);
					$content = str_replace("@@ACCOUNT-PWD@@",$CMD->DATA->PWD,$content);					
					send_mail_to($this->ROOT->PARAMS_MAIL->ADMIN,$CMD->DATA->EMAIL,$CMD->DATA->FIRSTNAME." ".$CMD->DATA->NAME,"CREATION DE VOTRE COMPTE",$content);
					$this->ROOT->INFOS = new stdClass;
					$this->ROOT->INFOS->id_unique = $idx;
					$this->ROOT->INFOS->nom = $CMD->DATA->NAME;
					$this->ROOT->INFOS->prenom = $CMD->DATA->FIRSTNAME;
					$this->ROOT->INFOS->email = $CMD->DATA->EMAIL;
					$this->ROOT->INFOS->roles = false;
					$this->ROOT->CONNECTED = true;
					session_save($this->ROOT);
					$CMD->DATA = $CMD->DATA->EMAIL;
					if(isset($CMD->CONTAINER_TO) && isset($CMD->PRECISION_TO)) {
						$CMD->CONTAINER = $CMD->CONTAINER_TO;
						$precision = $CMD->PRECISION_TO;
						return $this->$precision($CMD);
					}
					$DIR = (isset($CMD->DIR))? $CMD->DIR ."/".$CMD->PAGE : $CMD->PAGE;
					$CMD->RUN = "SHOW_CONTENT";					
					$CMD->CONTENT = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/{$DIR}.html",$CMD);							
					return $CMD;
				}
				else{
					$MSG_ERROR = "Une erreur(1024) non attendue est survenue lors de l'exécution.";
					$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
					$CMD->DATA = false;
					return $CMD;
				}
			}
			$CMD->DATA = false;
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
			return $CMD;
        }catch(Exception $e){
			$MSG_ERROR = "Une erreur non attendue est survenue lors de l'exécution.";
			$CMD->CONTENT = "<script language='javascript'>$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'> <font style='color:red;'>".$MSG_ERROR."</font>";
			$CMD->DATA = false;
            return $CMD;
        }
	}
	public function MY_ACCOUNT($CMD){
		try{
			$PAGE =  ($this->ROOT->CONNECTED === true) ? "SUPPORT" : "CONNECT";			
			$CMD->CONTENT = $this->SYSTEM->prepare_file(dirname(__FILE__) ."/content/MY_ACCOUNT/{$PAGE}.html",$CMD);            
			return $CMD;
        }catch(Exception $e){
			$this->ERROR = $e;
            return false;
        }
	}		
			
	/******************* UPLOAD ********************/
	
	public function UPLOAD_FILE($CMD){
        try{
			$CMD->error = false;			
			$CMD->CONTENT = "Enregistrement terminé";
			$CMD->SAVE = true;	
			$val = $CMD->INFO;			
			$sql = "insert into images(id_unique,name,roles,cryptname,smallname,bigname,bigname_notext,width,height,datecreate,usercreate)values('".$val->id_unique."','".$val->name."',null,'".$val->cryptname."','".$val->smallname."','".$val->bigname."','".$val->bigname_notext."',".$val->width.",".$val->height.",'".$val->datecreate."','".$val->usercreate."')";
			if($this->SYSTEM->sql_query($sql) === false){
				$CMD->error = true;
				$CMD->CONTENT = "Impossible d'enregistrer l'image";
				$CMD->SAVE = false;	
			}
			return $this->get_info_cmd_simple($CMD);
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	public function REMOVE_IMAGE($CMD){
        try{
			$CMD->error = false;
			$CMD->TITLE = "Suppression d'image";
			$CMD->EXECUTE = true;
			$CMD->CONTENT = "OK";
			$idx = 	$CMD->DATA->IDX;		
			if($this->SYSTEM->sql_select_one("select * from images where id_unique='{$idx}' limit 1") === false){			
				$CMD->CONTENT = "L'image n'existe pas";
				$CMD->EXECUTE = false;
				return $CMD;
			}			
			if($this->SYSTEM->sql_query("DELETE FROM images where id_unique='{$idx}'") === false){
				$CMD->EXECUTE = false;
				$CMD->CONTENT = "Impossible de supprimer le fichier l'image";
			}			
			return $CMD;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	
	/******************* GENERIC CRUD ****************/
	
	private function get_fields($MODULE){
		try{		
			$fields = $this->SYSTEM->get_table_struct($MODULE);
			$obj = new stdClass;
			foreach($fields as $key => $val){
				if(strpos($val,"VARCHAR",0) !== false) $val = "";
				elseif(strpos($val,"TEXT",0) !== false) $val = ""; 
				elseif(strpos($val,"DATETIME",0) !== false) $val = ""; 
				elseif(strpos($val,"INT",0) !== false) $val = 0; 				
				$obj->$key = $val;
			}
			if($simple === false)$obj->SOURCES = new stdClass;
			return $obj;
		}catch(Exception $e){
            return false;
        }	
	}
	
	/******************* ROLES ****************/
	
	public function CREATE_ROLE($CMD){
		try{			
			$CMD->EXECUTE = false;
			$ERROR_MSG = (isset($CMD->DATA->NAME) && my_trim($CMD->DATA->NAME) !== "")? "": "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La saisie du nom de rôle est obligatoire";
			if($ERROR_MSG === "") {
				$NAME = my_trim($CMD->DATA->NAME);
				if($this->SYSTEM->sql_select_one("select * from roles where name='{$NAME}' limit 1") !== false){					
					$error = "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>Le rôle existe déjà";
					$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
					return $CMD;
				}
			}
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->DESCRIPTION) && my_trim($CMD->DATA->DESCRIPTION) !== "")? "": "<script language='javascript'>$('#INPUT-DESCRIPTION').addClass('error').focus();</script>La saisie de la description de rôle est obligatoire";
			if($ERROR_MSG === "") {		
				$CMD->DATA->DESCRIPTION = my_trim($CMD->DATA->DESCRIPTION);
				$usercreate = $this->ROOT->INFOS->id_unique;
				$date = dateTimePARIS_FR(); 
				$name = my_trim($CMD->DATA->NAME);
				$description = my_trim($CMD->DATA->DESCRIPTION);
				$roles = (isset($CMD->DATA->ROLES)) ? "'".json_encode($CMD->DATA->ROLES)."'" : "null"; 
				$sql = "insert into roles(name,id_unique,description,usercreate,datecreate,data) values('".$name."','".get_id()."','".$description."','$usercreate','".$date."',$roles)";
				if($this->SYSTEM->sql_query($sql) === false) $ERROR_MSG = "Impossible de créer le rôle, une erreur inattendue est survenue";
				else $CMD->EXECUTE = true;
			}
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$ERROR_MSG;			
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function UPDATE_ROLE($CMD){
		try{			
			$CMD->EXECUTE = false;
			if($this->SYSTEM->sql_select_one("select * from roles where id_unique='{$CMD->ID_UNIQUE}' limit 1") === false){					
				$error = "Le rôle n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			$ERROR_MSG = (isset($CMD->DATA->NAME) && my_trim($CMD->DATA->NAME) !== "")? "": "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La saisie du nom de rôle est obligatoire";
			if($ERROR_MSG === "") {
				$CMD->DATA->NAME = my_trim($CMD->DATA->NAME);
				if( ($result = $this->SYSTEM->sql_select_one("select * from roles where name='{$CMD->DATA->NAME}' limit 1") )!== false && $result->id_unique !== $CMD->ID_UNIQUE){					
					$error = "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>Le rôle existe déjà";
					$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
					return $CMD;
				}
			}			
			if($ERROR_MSG === "")$ERROR_MSG = (isset($CMD->DATA->DESCRIPTION) && my_trim($CMD->DATA->DESCRIPTION) !== "")? "": "<script language='javascript'>$('#INPUT-DESCRIPTION').addClass('error').focus();</script>La saisie de la description de rôle est obligatoire";
			if($ERROR_MSG === "") {
				$CMD->DATA->DESCRIPTION = my_trim($CMD->DATA->DESCRIPTION);
				$userupdate = $this->ROOT->INFOS->id_unique;
				$date = dateTimePARIS_FR(); 
				$name = my_trim($CMD->DATA->NAME);
				$description = my_trim($CMD->DATA->DESCRIPTION);
				$roles = (isset($CMD->DATA->ROLES)) ? "'".json_encode($CMD->DATA->ROLES)."'" : "null"; 
				$sql = "UPDATE roles SET name='$name',description='$description',userupdate='$userupdate',dateupdate='$date',data=$roles WHERE id_unique='{$CMD->ID_UNIQUE}' ";
				if($this->SYSTEM->sql_query($sql) === false) $ERROR_MSG = "Impossible de modifier le rôle, une erreur inattendue est survenue";
				else $CMD->EXECUTE = true;
			}
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$ERROR_MSG;			
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function UPDATE_ROLE_ROLES($CMD){
		try{			
			$CMD->EXECUTE = false;
			if($this->SYSTEM->sql_select_one("select * from roles where id_unique='{$CMD->ID_UNIQUE}' limit 1") === false){					
				$error = "Le rôle n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			
			$userupdate = $this->ROOT->INFOS->id_unique;
			$date = dateTimePARIS_FR(); 
			$roles = (isset($CMD->DATA->ROLES)) ? "'".json_encode($CMD->DATA->ROLES)."'" : "null"; 
			$sql = "UPDATE roles SET userupdate='$userupdate',dateupdate='$date',data=$roles WHERE id_unique='{$CMD->ID_UNIQUE}' ";
			if($this->SYSTEM->sql_query($sql) === false) $ERROR_MSG = "Impossible de modifier le rôle, une erreur inattendue est survenue";
			else $CMD->EXECUTE = true;
			
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$ERROR_MSG;			
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function UPDATE_ROLE_INFOS($CMD){
		try{			
			$CMD->EXECUTE = false;
			if($this->SYSTEM->sql_select_one("select * from roles where id_unique='{$CMD->ID_UNIQUE}' limit 1") === false){					
				$error = "Le rôle n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			$ERROR_MSG = (isset($CMD->DATA->NAME) && my_trim($CMD->DATA->NAME) !== "")? "": "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La saisie du nom de rôle est obligatoire";
			if($ERROR_MSG === "") {
				$CMD->DATA->NAME = my_trim($CMD->DATA->NAME);
				if( ($result = $this->SYSTEM->sql_select_one("select * from roles where name='{$CMD->DATA->NAME}' limit 1") )!== false && $result->id_unique !== $CMD->ID_UNIQUE){					
					$error = "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>Le rôle existe déjà";
					$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
					return $CMD;
				}
			}			
			if($ERROR_MSG === "")$ERROR_MSG = (isset($CMD->DATA->DESCRIPTION) && my_trim($CMD->DATA->DESCRIPTION) !== "")? "": "<script language='javascript'>$('#INPUT-DESCRIPTION').addClass('error').focus();</script>La saisie de la description de rôle est obligatoire";
			if($ERROR_MSG === "") {
				$CMD->DATA->DESCRIPTION = my_trim($CMD->DATA->DESCRIPTION);
				$userupdate = $this->ROOT->INFOS->id_unique;
				$date = dateTimePARIS_FR(); 
				$name = my_trim($CMD->DATA->NAME);
				$description = my_trim($CMD->DATA->DESCRIPTION);
				$sql = "UPDATE roles SET name='$name',description='$description',userupdate='$userupdate',dateupdate='$date' WHERE id_unique='{$CMD->ID_UNIQUE}' ";
				if($this->SYSTEM->sql_query($sql) === false) $ERROR_MSG = "Impossible de modifier le rôle, une erreur inattendue est survenue";
				else $CMD->EXECUTE = true;
			}
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$ERROR_MSG;			
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function GET_ROLE($CMD){
		try{			
			$CMD->EXECUTE = false;
			if(($result = $this->SYSTEM->sql_select_one("select * from roles where id_unique='{$CMD->ID_UNIQUE}' limit 1")) === false){					
				$error = "Le rôle n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
				return $CMD;
			}	
			$CMD->EXECUTE = true;	
			$obj = new stdClass;
			
			if(isset($result->data) && trim($result->data) !== "") $obj = json_decode($result->data);
			
			$obj->CREATE_DATE = $result->datecreate;
			$obj->UPDATE_DATE = (isset($result->dateupdate))? $result->dateupdate : "";
			$obj->NAME = $result->name;
			$obj->DESCRIPTION = $result->description;
			
			$CMD->CONTENT = $obj;	
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function REMOVE_ROLE($CMD){
		try{			
			$CMD->EXECUTE = false;
			if(($result = $this->SYSTEM->sql_select_one("select * from roles where id_unique='{$CMD->DATA->ID_UNIQUE}' limit 1")) === false){					
				$error = "Le rôle n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script>&nbsp;&nbsp;".$error;				
				return $CMD;
			}	
			if($this->SYSTEM->sql_query("DELETE FROM roles where id_unique='{$CMD->DATA->ID_UNIQUE}'") === false){
				$error = "Impossible de supprimer le rôle";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			$CMD->EXECUTE = true;	
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function ROLES_LIST($CMD){
		 try{
			$CMD->COUNT = 0;
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			if($this->SYSTEM->has_role("ROLES_VIEW_ALL") === false && $this->SYSTEM->has_role("ROLES_VIEW_OWN") === false){								
				$CMD->CONTENT = "<font style='color:red;font-size:16px;'>Vous n'avez pas les droits pour effectuer cette action</font>";
				return $CMD;
			}
			$filter = ($this->SYSTEM->has_role("ROLES_VIEW_ALL") === true)? "" : " where  usercreate='".$this->ROOT->INFOS->id_unique."' "; 					
			$result = $this->SYSTEM->sql_select("select * from roles $filter ORDER BY name,datecreate ASC");               
			if($result === false){			
				$CMD->CONTENT = "<font style='color:black;font-size:16px;'>Liste vide </font>";
				return $CMD;
			}
			$btn = "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_DETAIL' {$CMD->ID_UNIQUE_STRING}_DETAIL=true ><div title='Détailler'></div></td>";
			$btn .= ($this->SYSTEM->has_role("ROLES_REMOVE_ALL") === true || $this->SYSTEM->has_role("ROLES_REMOVE_OWN") === true)? "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_REMOVE' {$CMD->ID_UNIQUE_STRING}_REMOVE=true ><div ID_UNIQUE='@@ID_UNIQUE@@'  title='Supprimer'></div></td>"  : "";
			$btn .= ($this->SYSTEM->has_role("ROLES_UPDATE_ALL") === true || $this->SYSTEM->has_role("ROLES_UPDATE_OWN") === true)? "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_UPDATE' {$CMD->ID_UNIQUE_STRING}_UPDATE=true ><div ID_UNIQUE='@@ID_UNIQUE@@'  title='Modifier'></div></td>"  : "";
			$tr = "";
			$parity = "impair";
			$i = 0;
            while ($row = mysqli_fetch_object($result)){
				$id_unique = $row->id_unique;					
				$tr .= "<tr ".$id_unique."_LINE_TR=true {$info_remove} class='{$parity}'>".str_replace("@@ID_UNIQUE@@",$id_unique,$btn);
				if(isset($row->data) && my_trim($row->data) !== "") $tr .= "<td class='admin'></td>";
				else $tr .= "<td valign=middle class='admin_empty'><div title='aucun droit'></div></td>";
				$tr .= "<td valign=middle class='name' REMOVE_INFO=true LABEL='Nom'  UN_ESCAPE=true>".$row->name."</td>";	
				$tr .= "<td valign=middle class='description' REMOVE_INFO=true LABEL='Description' UN_ESCAPE=true>".$row->description."</td>";	
				$tr .= "<td valign=middle class='datecreate' REMOVE_INFO=true LABEL='Date de création'  >".$row->datecreate."</td>";	
				if(isset($row->dateupdate) && my_trim($row->dateupdate) !== "") $tr .= "<td valign=middle REMOVE_INFO=true LABEL='Date de modification'   class='dateupdate'>".$row->dateupdate."</td>";
				else $tr .= "<td valign=middle class='dateupdate_empty'></td>";
				++$i;
				$tr .= "</tr>";	
				$parity = ($parity === "impair")? "pair" :"impair";				
            }	
            mysqli_free_result($result);       
			$this->SYSTEM->sql_close();
			$CMD->EMPTY = false;
			$CMD->EXECUTE = true;
			$CMD->CONTENT = "<table id='".$CMD->ID_UNIQUE_STRING."_TABLE' cellspacing='0' cellpadding='0' border='0' style='width:100%;height:auto;'>{$tr}</table>";
			$CMD->COUNT = $i;
			return $CMD;
        }catch(Exception $e){
            $CMD->COUNT = 0;
			$CMD->EMPTY = true;
			$CMD->EXECUTE = false;
			$CMD->CONTENT = "<font style='color:red;font-size:16px;'>une erreur(1024) est survenue lors de l'exécution</font>";
			return $CMD;
        }
	}
	public function USERS_LIST($CMD){
		 try{
			$CMD->COUNT = 0;
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			if($this->SYSTEM->has_role("USERS_VIEW_ALL") === false && $this->SYSTEM->has_role("USERS_VIEW_OWN") === false){								
				$CMD->CONTENT = "<font style='color:red;font-size:16px;'>Vous n'avez pas les droits pour effectuer cette action</font>";
				return $CMD;
			}
			$filter = ($this->SYSTEM->has_role("USERS_VIEW_ALL") === true)? "" : " where  usercreate='".$this->ROOT->INFOS->id_unique."' "; 					
			$result = $this->SYSTEM->sql_select("select * from users $filter ORDER BY nom,datecreate ASC");               
			if($result === false){			
				$CMD->CONTENT = "<font style='color:black;font-size:16px;'>Liste vide </font>";
				return $CMD;
			}
			$btn = "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_DETAIL' {$CMD->ID_UNIQUE_STRING}_DETAIL=true ><div title='Détailler'></div></td>";
			$btn .= ($this->SYSTEM->has_role("USERS_REMOVE_ALL") === true || $this->SYSTEM->has_role("USERS_REMOVE_OWN") === true)? "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_REMOVE' {$CMD->ID_UNIQUE_STRING}_REMOVE=true ><div ID_UNIQUE='@@ID_UNIQUE@@'  title='Supprimer'></div></td>"  : "";
			$btn .= ($this->SYSTEM->has_role("USERS_UPDATE_ALL") === true || $this->SYSTEM->has_role("USERS_UPDATE_OWN") === true)? "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_UPDATE' {$CMD->ID_UNIQUE_STRING}_UPDATE=true ><div ID_UNIQUE='@@ID_UNIQUE@@'  title='Modifier'></div></td>"  : "";
			$tr = "";
			$parity = "impair";
			$i = 0;
            while ($row = mysqli_fetch_object($result)){
				$id_unique = $row->id_unique;					
				$tr .= "<tr ".$id_unique."_LINE_TR=true {$info_remove} class='{$parity}'>".str_replace("@@ID_UNIQUE@@",$id_unique,$btn);
				if(isset($row->roles) && my_trim($row->roles) !== "") $tr .= "<td class='admin'><div></div></td>";
				else $tr .= "<td valign=middle class='client'><div title='aucun droit'></div></td>";
				$tr .= "<td valign=middle class='name' REMOVE_INFO=true LABEL='Nom'  UN_ESCAPE=true>".$row->nom."</td>";	
				$tr .= "<td valign=middle class='firstname' REMOVE_INFO=true LABEL='Prénom' UN_ESCAPE=true>".$row->prenom."</td>";	
				$tr .= "<td valign=middle class='email' REMOVE_INFO=true LABEL='Adresse mail' UN_ESCAPE=true>".$row->email."</td>";
				$tr .= "<td valign=middle class='datecreate' REMOVE_INFO=true LABEL='Date de création'  >".$row->datecreate."</td>";	
				if(isset($row->dateupdate) && my_trim($row->dateupdate) !== "") $tr .= "<td valign=middle REMOVE_INFO=true LABEL='Date de modification'   class='dateupdate'>".$row->dateupdate."</td>";
				else $tr .= "<td valign=middle class='dateupdate_empty'></td>";
				++$i;
				$tr .= "</tr>";	
				$parity = ($parity === "impair")? "pair" :"impair";				
            }	
            mysqli_free_result($result);       
			$this->SYSTEM->sql_close();
			$CMD->EMPTY = false;
			$CMD->EXECUTE = true;
			$CMD->CONTENT = "<table id='".$CMD->ID_UNIQUE_STRING."_TABLE' cellspacing='0' cellpadding='0' border='0' style='width:100%;height:auto;'>{$tr}</table>";
			$CMD->COUNT = $i;
			return $CMD;
        }catch(Exception $e){
            $CMD->COUNT = 0;
			$CMD->EMPTY = true;
			$CMD->EXECUTE = false;
			$CMD->CONTENT = "<font style='color:red;font-size:16px;'>une erreur(1024) est survenue lors de l'exécution</font>";
			return $CMD;
        }
	}
	
	/******************* USERS ****************/
	
	public function CREATE_USER($CMD){
		try{	
			$CMD->EXECUTE = false;
			$ERROR_MSG = (isset($CMD->DATA->NAME) && my_trim($CMD->DATA->NAME) !== "")? "": "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La saisie du nom de l'utilisateur est obligatoire";
			if($ERROR_MSG === ""){
				$CMD->DATA->NAME = my_trim($CMD->DATA->NAME);
				$ERROR_MSG = (isset($CMD->DATA->FIRSTNAME) && my_trim($CMD->DATA->FIRSTNAME) !== "")? "": "<script language='javascript'>$('#INPUT-FIRSTNAME').addClass('error').focus();</script>La saisie de la prénom de l'utilisateur est obligatoire";
			}
			if($ERROR_MSG === ""){				
				$CMD->DATA->FIRSTNAME = my_trim($CMD->DATA->FIRSTNAME);
				$ERROR_MSG = (isset($CMD->DATA->EMAIL) && my_trim($CMD->DATA->EMAIL) !== "")? "": "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>La saisie de l'adresse mail de l'utilisateur est obligatoire";			
			}
			if($ERROR_MSG === ""){
				$CMD->DATA->EMAIL = my_trim2($CMD->DATA->EMAIL);
				$ERROR_MSG = (filter_var($CMD->DATA->EMAIL, FILTER_VALIDATE_EMAIL) !== false)? "": "<script language='javascript'>$('#INPUT-EMAIL').addClass('error');</script>Veuillez saisir une adresse mail valide";
			}
			if($ERROR_MSG === "") {
				if( ($result = $this->SYSTEM->sql_select_one("select * from users where email='{$CMD->DATA->EMAIL}' limit 1") )!== false){					
					$error = "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>L'adresse email saisie existe déjà";
					$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
					return $CMD;
				}
			}
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->EMAIL2) && my_trim($CMD->DATA->EMAIL2) !== "")? "": "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Veuillez ressaisir à nouveau l'adresse mail";			
			if($ERROR_MSG === "") $ERROR_MSG = ($CMD->DATA->EMAIL === $CMD->DATA->EMAIL2)? "": "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Les deux adresses mail doivent être égales";			
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->PWD) && my_trim($CMD->DATA->PWD) !== "")? "": "<script language='javascript'>$('#INPUT-PWD').addClass('error').focus();</script>Veuillez saisir le mot de passe de l'utilisateur";			
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->PWD2) && my_trim($CMD->DATA->PWD2) !== "")? "": "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Veuillez ressaisir à nouveau le mot de passe de l'utilisateur";			
			if($ERROR_MSG === "") $ERROR_MSG = ($CMD->DATA->PWD === $CMD->DATA->PWD2)? "": "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Les deux mots de passe doivent être égaux";			
			if($ERROR_MSG === "") {				
				$usercreate = $this->ROOT->INFOS->id_unique;
				$date = dateTimePARIS_FR(); 
				$name = my_trim($CMD->DATA->NAME);
				$firstname = my_trim($CMD->DATA->FIRSTNAME);
				$email = my_trim2($CMD->DATA->EMAIL);
				$pwd = md5($CMD->DATA->PWD);
				$roles = (isset($CMD->DATA->ROLES)) ? "'".json_encode($CMD->DATA->ROLES)."'" : "null"; 
				$sql = "insert into users(nom,id_unique,prenom,pwd,email,roles,usercreate,datecreate) values('$name','".get_id()."','$firstname','$pwd','$email',$roles,'$usercreate','$date')";
				if($this->SYSTEM->sql_query($sql) === false) $ERROR_MSG = "Impossible de créer l'utilisateur, une erreur inattendue est survenue";
				else $CMD->EXECUTE = true;
			}
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$ERROR_MSG;			
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function UPDATE_USER($CMD){
		try{	
			$CMD->EXECUTE = false;
			if($this->SYSTEM->sql_select_one("select * from users where id_unique='{$CMD->ID_UNIQUE}' limit 1") === false){					
				$error = "Le compte de l'utilisateur n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			$ERROR_MSG = (isset($CMD->DATA->NAME) && my_trim($CMD->DATA->NAME) !== "")? "": "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La saisie du nom de l'utilisateur est obligatoire";
			if($ERROR_MSG === ""){
				$CMD->DATA->NAME = my_trim($CMD->DATA->NAME);
				$ERROR_MSG = (isset($CMD->DATA->FIRSTNAME) && my_trim($CMD->DATA->FIRSTNAME) !== "")? "": "<script language='javascript'>$('#INPUT-FIRSTNAME').addClass('error').focus();</script>La saisie de la prénom de l'utilisateur est obligatoire";
			}
			if($ERROR_MSG === ""){				
				$CMD->DATA->FIRSTNAME = my_trim($CMD->DATA->FIRSTNAME);
				$ERROR_MSG = (isset($CMD->DATA->EMAIL) && trim($CMD->DATA->EMAIL) !== "")? "": "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>La saisie de l'adresse mail de l'utilisateur est obligatoire";			
			}
			if($ERROR_MSG === ""){
				$CMD->DATA->EMAIL = trim($CMD->DATA->EMAIL);
				$ERROR_MSG = (filter_var($CMD->DATA->EMAIL, FILTER_VALIDATE_EMAIL) !== false)? "": "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>Veuillez saisir une adresse mail valide";
			}
			if($ERROR_MSG === "") {
				if( ($result = $this->SYSTEM->sql_select_one("select * from users where email='{$CMD->DATA->EMAIL}' limit 1") )!== false && $result->id_unique !== $CMD->ID_UNIQUE){					
					$error = "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>L'adresse email saisie existe déjà";
					$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
					return $CMD;
				}
			}
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->EMAIL2) && my_trim($CMD->DATA->EMAIL2) !== "")? "": "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Veuillez ressaisir à nouveau l'adresse mail";			
			if($ERROR_MSG === "") $ERROR_MSG = ($CMD->DATA->EMAIL === $CMD->DATA->EMAIL2)? "": "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error');</script>Les deux adresse mail doivent être égales";			
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->PWD) && my_trim($CMD->DATA->PWD) !== "")? "": "<script language='javascript'>$('#INPUT-PWD').addClass('error').focus();</script>Veuillez saisir le mot de passe de l'utilisateur";			
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->PWD2) && my_trim($CMD->DATA->PWD2) !== "")? "": "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Veuillez ressaisir à nouveau le mot de passe de l'utilisateur";			
			if($ERROR_MSG === "") $ERROR_MSG = ($CMD->DATA->PWD === $CMD->DATA->PWD2)? "": "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Les deux mot de passe doivent être égaux";			
			if($ERROR_MSG === "") {				
				$userupdate = $this->ROOT->INFOS->id_unique;
				$date = dateTimePARIS_FR(); 
				$name = my_trim($CMD->DATA->NAME);
				$firstname = my_trim($CMD->DATA->FIRSTNAME);
				$email = trim($CMD->DATA->EMAIL);
				$pwd = md5($CMD->DATA->PWD);
				$roles = (isset($CMD->DATA->ROLES)) ? "'".json_encode($CMD->DATA->ROLES)."'" : "null"; 
				$sql = "UPDATE users SET nom='$name',prenom='$firstname',pwd='$pwd',email='$email',roles=$roles,userupdate='$userupdate',dateupdate='$date' WHERE id_unique='{$CMD->ID_UNIQUE}'";
				if($this->SYSTEM->sql_query($sql) === false) $ERROR_MSG = "Impossible de modifier l'utilisateur, une erreur inattendue est survenue";
				else $CMD->EXECUTE = true;
			}
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$ERROR_MSG;			
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function UPDATE_USER_INFOS($CMD){
		try{	
			$CMD->EXECUTE = false;
			if($this->SYSTEM->sql_select_one("select * from users where id_unique='{$CMD->ID_UNIQUE}' limit 1") === false){					
				$error = "Le compte de l'utilisateur n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			$ERROR_MSG = (isset($CMD->DATA->NAME) && my_trim($CMD->DATA->NAME) !== "")? "": "<script language='javascript'>$('#INPUT-NAME').addClass('error').focus();</script>La saisie du nom de l'utilisateur est obligatoire";
			if($ERROR_MSG === ""){
				$CMD->DATA->NAME = my_trim($CMD->DATA->NAME);
				$ERROR_MSG = (isset($CMD->DATA->FIRSTNAME) && my_trim($CMD->DATA->FIRSTNAME) !== "")? "": "<script language='javascript'>$('#INPUT-FIRSTNAME').addClass('error').focus();</script>La saisie de la prénom de l'utilisateur est obligatoire";
			}
			if($ERROR_MSG === ""){				
				$CMD->DATA->FIRSTNAME = my_trim($CMD->DATA->FIRSTNAME);
				$ERROR_MSG = (isset($CMD->DATA->EMAIL) && trim($CMD->DATA->EMAIL) !== "")? "": "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>La saisie de l'adresse mail de l'utilisateur est obligatoire";			
			}
			if($ERROR_MSG === ""){
				$CMD->DATA->EMAIL = trim($CMD->DATA->EMAIL);
				$ERROR_MSG = (filter_var($CMD->DATA->EMAIL, FILTER_VALIDATE_EMAIL) !== false)? "": "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>Veuillez saisir une adresse mail valide";
			}
			if($ERROR_MSG === "") {
				if( ($result = $this->SYSTEM->sql_select_one("select * from users where email='{$CMD->DATA->EMAIL}' limit 1") )!== false && $result->id_unique !== $CMD->ID_UNIQUE){					
					$error = "<script language='javascript'>$('#INPUT-EMAIL').addClass('error').focus();</script>L'adresse email saisie existe déjà";
					$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
					return $CMD;
				}
			}
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->EMAIL2) && my_trim($CMD->DATA->EMAIL2) !== "")? "": "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error').focus();</script>Veuillez ressaisir à nouveau l'adresse mail";			
			if($ERROR_MSG === "") $ERROR_MSG = ($CMD->DATA->EMAIL === $CMD->DATA->EMAIL2)? "": "<script language='javascript'>$('#INPUT-EMAIL2').addClass('error');</script>Les deux adresse mail doivent être égales";			
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->PWD) && my_trim($CMD->DATA->PWD) !== "")? "": "<script language='javascript'>$('#INPUT-PWD').addClass('error').focus();</script>Veuillez saisir le mot de passe de l'utilisateur";			
			if($ERROR_MSG === "") $ERROR_MSG = (isset($CMD->DATA->PWD2) && my_trim($CMD->DATA->PWD2) !== "")? "": "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Veuillez ressaisir à nouveau le mot de passe de l'utilisateur";			
			if($ERROR_MSG === "") $ERROR_MSG = ($CMD->DATA->PWD === $CMD->DATA->PWD2)? "": "<script language='javascript'>$('#INPUT-PWD2').addClass('error').focus();</script>Les deux mot de passe doivent être égaux";			
			if($ERROR_MSG === "") {				
				$userupdate = $this->ROOT->INFOS->id_unique;
				$date = dateTimePARIS_FR(); 
				$name = my_trim($CMD->DATA->NAME);
				$firstname = my_trim($CMD->DATA->FIRSTNAME);
				$email = trim($CMD->DATA->EMAIL);
				$pwd = md5($CMD->DATA->PWD);
				$sql = "UPDATE users SET nom='$name',prenom='$firstname',pwd='$pwd',email='$email',userupdate='$userupdate',dateupdate='$date' WHERE id_unique='{$CMD->ID_UNIQUE}'";
				if($this->SYSTEM->sql_query($sql) === false) $ERROR_MSG = "Impossible de modifier l'utilisateur, une erreur inattendue est survenue";
				else $CMD->EXECUTE = true;
			}
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$ERROR_MSG;			
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function UPDATE_USER_ROLES($CMD){
		try{	
			$CMD->EXECUTE = false;
			if($this->SYSTEM->sql_select_one("select * from users where id_unique='{$CMD->ID_UNIQUE}' limit 1") === false){					
				$error = "Le compte de l'utilisateur n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			
			$userupdate = $this->ROOT->INFOS->id_unique;
			$date = dateTimePARIS_FR(); 

			$roles = (isset($CMD->DATA->ROLES)) ? "'".json_encode($CMD->DATA->ROLES)."'" : "null"; 
			$sql = "UPDATE users SET roles=$roles,userupdate='$userupdate',dateupdate='$date' WHERE id_unique='{$CMD->ID_UNIQUE}'";
			if($this->SYSTEM->sql_query($sql) === false) $ERROR_MSG = "Impossible de modifier l'utilisateur, une erreur inattendue est survenue";
			else $CMD->EXECUTE = true;
			
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$ERROR_MSG;			
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function GET_USER($CMD){
		try{
			$CMD->EXECUTE = false;
			if( ($result = $this->SYSTEM->sql_select_one("select * from users where id_unique='{$CMD->ID_UNIQUE}' limit 1")) === false){					
				$error = "Le compte de l'utilisateur n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;				
				return $CMD;
			}			
			$CMD->EXECUTE = true;
			$obj = new stdClass;
			
			if(isset($result->roles) && trim($result->roles) !== "") $obj = json_decode($result->roles);
			
			$obj->CREATE_DATE = $result->datecreate;
			$obj->UPDATE_DATE = (isset($result->dateupdate))? $result->dateupdate : "";
			$obj->NAME = $result->nom;
			$obj->FIRSTNAME = $result->prenom;
			$obj->EMAIL = $result->email;
			
			$CMD->CONTENT = $obj;
			
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script><img src='images/error.png' width='20px' height='20px'>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	public function REMOVE_USER($CMD){
		try{			
			$CMD->EXECUTE = false;
			if(($result = $this->SYSTEM->sql_select_one("select * from users where id_unique='{$CMD->DATA->ID_UNIQUE}' limit 1")) === false){					
				$error = "L'utilisateur n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script>&nbsp;&nbsp;".$error;				
				return $CMD;
			}	
			if($this->SYSTEM->sql_query("DELETE FROM users where id_unique='{$CMD->DATA->ID_UNIQUE}'") === false){
				$error = "Impossible de supprimer le compte utilisateur";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			$CMD->EXECUTE = true;	
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}
	
	/*********** BILLING *********/
	
	public function MY_BILLING_LIST($CMD){
		try{
			$CMD->COUNT = 0;
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
					
			$result = $this->SYSTEM->sql_select("select * from achats WHERE userid='".$this->ROOT->INFOS->id_unique."'  ORDER BY achatid ASC");               
			if($result === false){			
				$CMD->CONTENT = "<font style='color:black;font-size:16px;'>Liste vide </font>";
				return $CMD;
			}
			$btn = "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_DETAIL' {$CMD->ID_UNIQUE_STRING}_DETAIL=true ><div title='Détailler'></div></td>";
//			$btn .= ($this->SYSTEM->has_role("BILLING_REMOVE") === true )? "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_REMOVE' {$CMD->ID_UNIQUE_STRING}_REMOVE=true ><div ID_UNIQUE='@@ID_UNIQUE@@'  title='Supprimer'></div></td>"  : "";			
			$tr = "";
			$parity = "impair";
			$i = 0;
			
			$tr .= "<tr><td class='header_btn'></td>";
			//if($this->SYSTEM->has_role("BILLING_REMOVE") === true )$tr .= "<td class='header_btn'></td>";
			
			$tr .= "<td valign=middle class='header_label' >Date d'achat</td>";	
			$tr .= "<td align=left valign=middle class='header_label'>Nombre d'image</td>";
			$tr .= "<td align=left valign=middle class='header_label'>Montant intial</td>";	
			$tr .= "<td align=left valign=middle class='header_label'>Réduction</td>";	
			$tr .= "<td align=left valign=middle class='header_label' >Montant à régler</td>";	
			$tr .= "<td align=left valign=middle class='header_label' >Paiement effectué</td>";	
			$tr .= "<td align=left valign=middle class='header_label' >Erreur(s) rencontrée(s)</td>";							
			$tr .= "</tr>";
				
            while ($row = mysqli_fetch_object($result)){
				$id_unique = $row->id_unique;					
				$tr .= "<tr ".$id_unique."_LINE_TR=true {$info_remove} class='{$parity}'>".str_replace("@@ID_UNIQUE@@",$id_unique,$btn);
				
				$tr .= "<td valign=middle class='datecreate' REMOVE_INFO=true LABEL='Date de paiement'  >".$row->datecreate."</td>";	
				$tr .= "<td align=left valign=middle class='images_count' REMOVE_INFO=true LABEL='Nombre d&apos;image'>".$row->nbimages."</td>";
				$tr .= "<td align=left valign=middle class='price' REMOVE_INFO=true LABEL='Montant initial'>".$row->price."&nbsp;€</td>";	
				$tr .= "<td align=left valign=middle class='reduce' REMOVE_INFO=true LABEL='Réduction appliquée'>".$row->reduce."&nbsp;€</td>";	
				$tr .= "<td align=left valign=middle class='amount' REMOVE_INFO=true LABEL='Montant à payer'>".$row->amount."&nbsp;€</td>";	
				if((int)$row->succes === 1)$tr .= "<td align=left valign=middle class='boolean_yes' REMOVE_INFO=true LABEL='Paiement effectué'>Oui</td>";	
				else  $tr .= "<td align=left valign=middle class='boolean_no' REMOVE_INFO=true LABEL='Paiement effectué'>Non</td>";	
				if((int)$row->nberror > 0) $tr .= "<td align=left valign=middle class='error_yes' REMOVE_INFO=true LABEL='Erreur(s) rencontrée(s)'>".$row->nberror."</td>";	
				else $tr .= "<td align=left valign=middle class='error_no' REMOVE_INFO=true LABEL='Erreur(s) rencontrée(s)'>".$row->nberror."</td>";	
				
				++$i;
				$tr .= "</tr>";	
				$parity = ($parity === "impair")? "pair" :"impair";				
            }	
            mysqli_free_result($result);       
			$this->SYSTEM->sql_close();
			$CMD->EMPTY = false;
			$CMD->EXECUTE = true;
			$CMD->CONTENT = "<table id='".$CMD->ID_UNIQUE_STRING."_TABLE' cellspacing='0' cellpadding='0' border='0' style='width:100%;height:auto;'>{$tr}</table>";
			$CMD->COUNT = $i;
			return $CMD;
        }catch(Exception $e){
            $CMD->COUNT = 0;
			$CMD->EMPTY = true;
			$CMD->EXECUTE = false;
			$CMD->CONTENT = "<font style='color:red;font-size:16px;'>une erreur(1024) est survenue lors de l'exécution</font>";
			return $CMD;
        }
	}
	public function BILLING_LIST($CMD){
		try{
			$CMD->COUNT = 0;
			$CMD->EXECUTE = false;
			$CMD->EMPTY = true;
			if($this->SYSTEM->has_role("BILLING_VIEW") === false){								
				$CMD->CONTENT = "<font style='color:red;font-size:16px;'>Vous n'avez pas les droits pour effectuer cette action</font>";
				return $CMD;
			}				
			$result = $this->SYSTEM->sql_select("select * from achats ORDER BY achatid ASC");               
			if($result === false){			
				$CMD->CONTENT = "<font style='color:black;font-size:16px;'>Liste vide </font>";
				return $CMD;
			}
			$btn = "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_DETAIL' {$CMD->ID_UNIQUE_STRING}_DETAIL=true ><div title='Détailler'></div></td>";
			$btn .= ($this->SYSTEM->has_role("BILLING_REMOVE") === true )? "<td ID_UNIQUE='@@ID_UNIQUE@@' class='BTN_REMOVE' {$CMD->ID_UNIQUE_STRING}_REMOVE=true ><div ID_UNIQUE='@@ID_UNIQUE@@'  title='Supprimer'></div></td>"  : "";			
			$tr = "";
			$parity = "impair";
			$i = 0;
			
			$tr .= "<tr><td class='header_btn'></td>";
			if($this->SYSTEM->has_role("BILLING_REMOVE") === true )$tr .= "<td class='header_btn'></td>";
			
			$tr .= "<td valign=middle class='header_label'>Nom du client</td>";	
			$tr .= "<td valign=middle class='header_label'>Prénom</td>";	
			$tr .= "<td valign=middle class='header_label'>Adrese mail</td>";
			$tr .= "<td valign=middle class='header_label' >Date d'achat</td>";	
			$tr .= "<td align=left valign=middle class='header_label'>Nombre d'image</td>";
			$tr .= "<td align=left valign=middle class='header_label'>Montant intial</td>";	
			$tr .= "<td align=left valign=middle class='header_label'>Réduction</td>";	
			$tr .= "<td align=left valign=middle class='header_label' >Montant à régler</td>";	
			$tr .= "<td align=left valign=middle class='header_label' >Paiement effectué</td>";	
			$tr .= "<td align=left valign=middle class='header_label' >Erreur(s) rencontrée(s)</td>";							
			$tr .= "</tr>";
				
            while ($row = mysqli_fetch_object($result)){
				$id_unique = $row->id_unique;					
				$tr .= "<tr ".$id_unique."_LINE_TR=true {$info_remove} class='{$parity}'>".str_replace("@@ID_UNIQUE@@",$id_unique,$btn);
				
				$tr .= "<td valign=middle class='name' REMOVE_INFO=true LABEL='Nom du client'  UN_ESCAPE=true>".$row->name."</td>";	
				$tr .= "<td valign=middle class='firstname' REMOVE_INFO=true LABEL='Prénom du client' UN_ESCAPE=true>".$row->firstname."</td>";	
				$tr .= "<td valign=middle class='email' REMOVE_INFO=true LABEL='Adresse mail du client'>".$row->email."</td>";
				$tr .= "<td valign=middle class='datecreate' REMOVE_INFO=true LABEL='Date de paiement'  >".$row->datecreate."</td>";	
				$tr .= "<td align=left valign=middle class='images_count' REMOVE_INFO=true LABEL='Nombre d&apos;image'>".$row->nbimages."</td>";
				$tr .= "<td align=left valign=middle class='price' REMOVE_INFO=true LABEL='Montant initial'>".$row->price."&nbsp;€</td>";	
				$tr .= "<td align=left valign=middle class='reduce' REMOVE_INFO=true LABEL='Réduction appliquée'>".$row->reduce."&nbsp;€</td>";	
				$tr .= "<td align=left valign=middle class='amount' REMOVE_INFO=true LABEL='Montant à payer'>".$row->amount."&nbsp;€</td>";	
				if((int)$row->succes === 1)$tr .= "<td align=left valign=middle class='boolean_yes' REMOVE_INFO=true LABEL='Paiement effectué'>Oui</td>";	
				else  $tr .= "<td align=left valign=middle class='boolean_no' REMOVE_INFO=true LABEL='Paiement effectué'>Non</td>";	
				if((int)$row->nberror > 0) $tr .= "<td align=left valign=middle class='error_yes' REMOVE_INFO=true LABEL='Erreur(s) rencontrée(s)'>".$row->nberror."</td>";	
				else $tr .= "<td align=left valign=middle class='error_no' REMOVE_INFO=true LABEL='Erreur(s) rencontrée(s)'>".$row->nberror."</td>";	
				
				++$i;
				$tr .= "</tr>";	
				$parity = ($parity === "impair")? "pair" :"impair";				
            }	
            mysqli_free_result($result);       
			$this->SYSTEM->sql_close();
			$CMD->EMPTY = false;
			$CMD->EXECUTE = true;
			$CMD->CONTENT = "<table id='".$CMD->ID_UNIQUE_STRING."_TABLE' cellspacing='0' cellpadding='0' border='0' style='width:100%;height:auto;'>{$tr}</table>";
			$CMD->COUNT = $i;
			return $CMD;
        }catch(Exception $e){
            $CMD->COUNT = 0;
			$CMD->EMPTY = true;
			$CMD->EXECUTE = false;
			$CMD->CONTENT = "<font style='color:red;font-size:16px;'>une erreur(1024) est survenue lors de l'exécution</font>";
			return $CMD;
        }
	}
	public function REMOVE_BILLING($CMD){
		try{			
			$CMD->EXECUTE = false;
			if(($result = $this->SYSTEM->sql_select_one("select * from achats where id_unique='{$CMD->DATA->ID_UNIQUE}' limit 1")) === false){					
				$error = "Le relevé d'achat n'existe pas";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script>&nbsp;&nbsp;".$error;				
				return $CMD;
			}	
			if($this->SYSTEM->sql_query("DELETE FROM achats where id_unique='{$CMD->DATA->ID_UNIQUE}'") === false){
				$error = "Impossible de supprimer le relevé d'achat";
				$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script>&nbsp;&nbsp;".$error;				
				return $CMD;
			}
			$CMD->EXECUTE = true;	
			return $CMD;				
        }catch(Exception $e){
			$error = "Une erreur(1024) inattendue s'est produite, veuillez contacter l'administrateur";
			$CMD->CONTENT = "<script language='javascript'>$('textarea').removeClass('error');$('input').removeClass('error');</script>&nbsp;&nbsp;".$error;
			$CMD->EXECUTE = false;
			return $CMD;
        }
	}

	/******************** RUN ************************/    
    
	public function run($CMD,$__SYS = false){
        return $this->SYSTEM->run_cmd ($this,$CMD);
    }
}
?>    				