<?php
 class TSYSTEM{
   
    public $ROOT = false;
    private $ERROR = false;
    private $NAME = "SYSTEM";
	private $db  = false;
    public $msg = false;
    public $CURRENT = false;
	public $ROOT_INFO = false;
	private $TITLE_MODULE = false;
    
	function __construct( &$PARENT ){        			
		$this->ROOT = $PARENT;
		$this->ROOT_INFO = get_root($this->ROOT->CRT);	  
	}   
	
	/*************** DATABASE TABLE MANAGE *********************/
	
	public function get_table_struct($DOCUMENT){
		$MODULES = array(
			"GALERY" => array(
				"id_unique" => "varchar(255)",
				"name" => "VARCHAR(255)",
				"description" => "VARCHAR(255)",
				"addhome" => "INT(1)",
				"roles" => "TEXT",
				"roles_free" => "TEXT",
				"root" => "VARCHAR(255)",
				"root_name" => "VARCHAR(255)",
				"download" => "TEXT",
				"datecreate" => "DATETIME",
				"dateupdate" => "DATETIME",
				"datedelete" => "DATETIME",
				"usercreate" => "VARCHAR(255)",
				"userupdate" => "VARCHAR(255)",
				"userdelete" => "VARCHAR(255)",
				"isdelete" => "INT(1)",
				"sfree" => "INT(1)",
				"images_count" => "INT(11)",
				"prices" => "TEXT"
			),		
			"ROLES" => array(
				"id_unique" => "VARCHAR(255)",
				"name" => "VARCHAR(255)",
				"description" => "VARCHAR(255)",
				"data" => "TEXT",			
				"datecreate" => "DATETIME",
				"dateupdate" => "DATETIME",
				"datedelete" => "DATETIME",
				"usercreate" => "VARCHAR(255)",
				"userupdate" => "VARCHAR(255)",
				"userdelete" => "VARCHAR(255)",
				"isdelete" => "INT(1)"
			),		
			"USERS" => array(
				"id_unique" => "VARCHAR(255)",
				"pwd" => "VARCHAR(100)",
				"role" => "VARCHAR(255)",
				"email" => "VARCHAR(255)",
				"nom" => "VARCHAR(255)",
				"prenom" => "VARCHAR(255)",
				"roles" => "TEXT",
				"data" => "TEXT",
				"infos" => "TEXT",
				"datecreate" => "DATETIME",
				"dateupdate" => "DATETIME",
				"datedelete" => "DATETIME",
				"usercreate" => "VARCHAR(255)",
				"userupdate" => "VARCHAR(255)",
				"userdelete" => "VARCHAR(255)",
				"isdelete" => "INT(1)"
			)
		);
		return isset($MODULES[$DOCUMENT])? $MODULES[$DOCUMENT] : false;
	}	
	public function get_table_prepare_insert($DOCUMENT,$data){	
		try{
			if( ($fields = $this->get_table_struct($DOCUMENT)) === false) return false;
			$str_fields = "";
			$str_values = "";
			foreach($fields as $key => $val){
				$str_fields .= ($str_fields === "")? $key : ",".$key;				
				if($key === "id_unique") $val = "'".get_id()."'"; 
				elseif($key === "usercreate") $val = "'".$this->ROOT->INFOS->id_unique."'"; 	
				elseif($key === "datecreate") $val = "'".dateTimePARIS_FR()."'"; 										
				else {
					if(strpos($val,"VARCHAR",0) !== false) $val = (trim($data->$key) === "")? "''" : "'".$data->$key."'";
					elseif(strpos($val,"TEXT",0) !== false){
						if(is_object($data->$key) || is_array($data->$key)) $val = "'".json_encode($data->$key)."'";
						else $val = (trim($data->$key) === "")? "''" : "'".$data->$key."'";
					}					
					elseif(strpos($val,"INT",0) !== false) $val = $data->$key; 	
					elseif(strpos($val,"DATETIME",0) !== false) $val = (trim($data->$key) === "")? "null" : "'".$data->$key."'";
				}
				$str_values .= ($str_values === "")? $val : ",".$val;
			}
			$obj = new stdClass;
			$obj->FIELDS = $str_fields;
			$obj->VALUES = $str_values;
			return $obj;
		}catch(Exception $e){
			return false;
		}
	}
	public function get_table_prepare_update($DOCUMENT,$data,$already_compress = false){	
		try{
			if( ($fields = $this->get_table_struct($DOCUMENT)) === false) return false;
			$str_values = "";
			
			foreach($fields as $key => $val){				
				
				if($key === "id_unique") continue;
				if($key === "userupdate") $val = "'".$this->ROOT->INFOS->id_unique."'";
				elseif($key === "dateupdate") $val = "'".dateTimePARIS_FR()."'"; 	
				else {					
					if(strpos($val,"VARCHAR",0) !== false) $val = (trim($data->$key) === "")? "" : "'".$data->$key."'";
					elseif(strpos($val,"TEXT",0) !== false){
						if(is_object($data->$key) || is_array($data->$key)) $val = "'".json_encode($data->$key)."'";
						else $val = (trim($data->$key) === "")? "" : "'".$data->$key."'";
					}					
					elseif(strpos($val,"INT",0) !== false) $val = $data->$key; 	
					elseif(strpos($val,"DATETIME",0) !== false) $val = (trim($data->$key) === "")? "" : "'".$data->$key."'";					
				}				
				$str_values .= ($str_values === "")? "$key=$val" : ",$key=$val";
			}
			return $str_values;
		}catch(Exception $e){
			return false;
		}
	}
	
	/******************** GET DATA BASE ELEMENT ************************/
   
    public function sql_query($query){
        try{ 
			return (sql_execute($query,false) === false)? false : true;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	public function sql_select_one($query){
        try{   
			return sql_execute($query);
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	public function sql_close(){
        try{ 
			if($this->db === false) return false;
			mysqli_close($this->db);
			$this->db = false;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	public function sql_select($query){
        try{ 
			$result = sql_execute($query,true,true);
			if($result === false) return false;
			$this->db = $result->LINK;
			return $result->DATA;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
    public function get($module,$filter = ""){
        try{
            $filter = ($filter === "")? "" : $filter . " and ";
            return $this->sql_select_one("select * from $module where ".$filter."' isdelete<>1 limit 1");
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }

    /*********** ACCESS ****/
	
    public function action_denied($CMD){
        try{
            if($this->ROOT->IS_ROOT === true) return false;
			if(isset($this->ROOT->TOKEN) && isset($CMD->TOKEN) && get_id_process($this->ROOT->TOKEN) === $CMD->TOKEN) return false;
            return true;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }      
    
	/*********** LOAD FILE CONTENT ****/
	
	public function replace_content_elt($elt,$obj,$content){
        try{	
			if(strpos($content,$elt,0) !== false && isset($obj)) return str_replace($elt,$obj,$content);	
			return str_replace($elt,"",$content);				
		}catch(Exception $e){
            return str_replace($elt,"",$content);
        }
    } 
	public function prepare_content($content,$CMD){
        try{
            if(trim($content) === "") return "";
		
			$content = $this->replace_content_elt("@@CURRENT_TOKEN@@",isset($CMD->TOKEN)? $CMD->TOKEN : "",$content);
			$content = $this->replace_content_elt("@@CURRENT_DOCUMENT@@",isset($CMD->DOCUMENT)? $CMD->DOCUMENT : "",$content);
			$content = $this->replace_content_elt("@@MODULE_NAME@@",(isset($this->CURRENT) && isset($this->CURRENT->NAME))? $this->CURRENT->NAME : "" ,$content);
			$content = $this->replace_content_elt("@@MODULE@@",isset($CMD->MODULE)? $CMD->MODULE : "",$content);			
			
			if(strpos($content,"@@PUT_ACTIONS@@",0) !== false){
				$content = str_replace("@@PUT_ACTIONS@@",isset($CMD->DATA->PUT_ACTIONS)? " ACTIONS='".$CMD->DATA->PUT_ACTIONS."' " : " style='display:none;' ",$content);                    
			}
					
            $content = $this->replace_content_elt("@@CONTAINER@@",isset($CMD->CONTAINER)?$CMD->CONTAINER : "",$content);            
			$content = $this->replace_content_elt("@@ID@@",$this->ROOT->ID,$content);
			
			if(strpos($content,"@@ID-ELEMENT@@",0) !== false){
				if(isset($CMD->DATA->ID)) $content = str_replace("@@ID-ELEMENT@@",$CMD->DATA->ID,$content);
				elseif(isset($CMD->PARAMS->ID)) $content = str_replace("@@ID-ELEMENT@@",$CMD->PARAMS->ID,$content);
			}
			
			if(strpos($content,"@@ID_UNIQUE_EDIT@@",0) !== false && isset($CMD->DATA->ID_UNIQUE_EDIT)){
				$content = str_replace("@@ID_UNIQUE_EDIT@@",$CMD->DATA->ID_UNIQUE_EDIT,$content);				
			}
						
			if(strpos($content,"@@TOKEN-UNIQUE@@",0) !== false){
				if(isset($CMD->ID_UNIQUE))$content = str_replace("@@TOKEN-UNIQUE@@",$CMD->ID_UNIQUE,$content);			
				else $content = str_replace("@@TOKEN-UNIQUE@@",get_id(),$content);
			}
			if(strpos($content,"@@TOKEN-UNIQUE-STRING@@",0) !== false){
				if(isset($CMD->ID_UNIQUE_STRING))$content = str_replace("@@TOKEN-UNIQUE-STRING@@",$CMD->ID_UNIQUE_STRING,$content);			
				else $content = str_replace("@@TOKEN-UNIQUE-STRING@@",get_string_id(),$content);
			}						
			
			$content = $this->replace_content_elt("@@DNS@@",$this->ROOT->PARAMS->DNS,$content);
			$content = $this->replace_content_elt("@@WWW-IMAGES@@",$this->ROOT->PARAMS->WWW."/",$content);
			$content = $this->replace_content_elt("@@WWW@@",$this->ROOT->PARAMS->WWW,$content);
			$content = $this->replace_content_elt("@@WWW-DEV@@",$this->ROOT->PARAMS->WWW_DEV,$content);
			
			$content = $this->replace_content_elt("@@PAYPAL-WWW@@",$this->ROOT->PARAMS->WWW."/?",$content);
			$content = $this->replace_content_elt("@@PAYPAL-WWW-DEV@@",$this->ROOT->PARAMS->WWW_DEV."/?",$content);
			
			
			$content = $this->replace_content_elt("@@ROOT_TOKEN@@",$CMD->TOKEN,$content);			

			/**** LIST FILTER ****/			
			$content = $this->replace_content_elt("@@ALL_ELEMENT@@",md5("ALL_ELEMENT"),$content);
			$content = $this->replace_content_elt("@@ALL_WITH_NO_ARCHIVED_ELEMENT@@",md5("ALL_WITH_NO_ARCHIVED_ELEMENT"),$content);
			$content = $this->replace_content_elt("@@ARCHIVED_ELEMENT_ONLY@@",md5("ARCHIVED_ELEMENT_ONLY"),$content);


			if($this->ROOT->CONNECTED === true){	
				$content = $this->replace_content_elt("@@EMAIL@@", $this->ROOT->INFOS->email, $content);
				$content = $this->replace_content_elt("@@MODE@@",md5("CONNECTED"),$content);				
			}
			elseif(strpos($content,"@@MODE@@",0) !== false){
				$content = str_replace("@@MODE@@",md5("DISCONNECTED"),$content);
			}

			if(strpos($content,"[ROLE-ATTRIBUTE][BEGIN]",0) !== false) $content = $this->parse_role($content); 
			if(strpos($content,"[CONNECTED-CONTENT][BEGIN]",0) !== false) $content = $this->parse_content($content);			
			if(strpos($content,"@@TOKENS=",0) !== false) $content = $this->parse_tokens($content);
			
			if(strpos($content,"@@DATA=",0) !== false) $content = $this->get_datas($content);			
			if(strpos($content,"[ROOTCONTENT][BEGIN]",0) !== false) $content = $this->parse_root_content($content);
			if(strpos($content,"[NOT-ROOTCONTENT][BEGIN]",0) !== false) $content = $this->parse_notroot_content($content);
			
			if(strpos($content,"@@RUNCMD=",0) !== false) $content = $this->exec_cmd($content);
						
			if(strpos($content,"@@MD5-",0) !== false){
				preg_match_all("|@@MD5-(.*)@@|U",$content,$tokens, PREG_PATTERN_ORDER);
				$tokensUnique = array_unique($tokens[1]);
				foreach ($tokensUnique as $t){	
					$content = str_replace("@@MD5-$t@@",md5($t.$this->ROOT->ID),$content);
				}
			}
			
			if(strpos($content,"@@PRINTCRYPT-",0) !== false){
				preg_match_all("|@@PRINTCRYPT-(.*)@@|U",$content,$tokens, PREG_PATTERN_ORDER);
				$tokensUnique = array_unique($tokens[1]);
				foreach ($tokensUnique as $t){	
					$content = str_replace("@@PRINTCRYPT-$t@@",encrypt_content($t,$this->ROOT->ID),$content);					
				}
			}
			if(strpos($content,"@@INPUT_DATA=",0) !== false) $content = $this->parse_input_data($content);
			
			/***** ROLES LIST ****/
			
			if(strpos($content,"@@ROLES-",0) !== false){
				$roles_list = $this->roles_list($CMD);        // LOAD ROLES			
				if($roles_list !== false) {				
					//@@ROLES-LIST-XX@@ : DEFAULT
					preg_match_all("|@@ROLES-LIST-(.*)@@|U",$content,$tokens, PREG_PATTERN_ORDER);
					$tokensUnique = array_unique($tokens[1]);
					foreach ($tokensUnique as $t){					
						$content = str_replace("@@ROLES-LIST-$t@@",str_replace("DEFAULT_ID",$t,$roles_list->VALUE),$content);					
					}				
				}else{
					$content = str_replace("@@ROLES-ONLY@@",$roles_list->MESSAGE,$content);
				}
			}
			
			if(strpos($content,"@@LIST-GALERY@@",0) !== false){								
				$content = str_replace("@@LIST-GALERY@@",$this->get_galery_li($CMD,true)->LI,$content);
			}
			
			return $content;
			
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	
	/*********** LISTING ****/
	
    public function roles_list($CMD){
        try{  
            $usercreate = $this->ROOT->INFOS->id_unique;
			$sql =  "select * from roles  and usercreate='$usercreate' ";			
			if( $this->has_role($obj->NAME."_VIEW_ALL") === true) $sql = "select * from roles ";
			$val = new stdClass;
            if(($result = $this->sql_select($sql)) === false){
				
				if($this->has_role("ROLES_CREATE") === true){
					$val->VALUE ="             
                        <tr SPACE_TR_LIST_ROLES=true>                
                            <td  align='center' valign='middle'></td>
                        </tr> 
						<tr style='height:50px;'>                
                            <td  align='center' valign='middle'>                              
                                <img src='images/warning.png' width='25px' height='25px'><br><br>Aucun role n'a été trouvé                                
                            </td>
                        </tr>  
						 <tr style='height:50px;'>                
                            <td  align='center' valign='middle'>                              
                                <input BTN_CREATE_ROLES=true type='button' class='button' value='Créer un rôle'  >                               
                            </td>
                        </tr>  	
					"; 
				}
				else{
					$val->VALUE = " 
						<tr SPACE_TR_LIST_ROLES=true>                
                            <td  align='center' valign='middle'></td>
                        </tr> 
						<tr style='height:50px;'>                
                            <td  align='center' valign='middle'>                              
                                <img src='images/warning.png' width='25px' height='25px'><br><br>Aucun role n'a été trouvé                                
                            </td>
                        </tr>";
				}	
				
				$val->MESSAGE =	'<tr style="height:145px;"><td  align="center" valign="middle">'.$this->msg->ERROR->LISTING->ROLES.'</td></tr>';
				return $val;
            }         
            $list = "";       
            $color = "white";         
            while ($row = mysqli_fetch_object($result)) {
              $list .= '
                    <tr>
                        <td align=center valign=middle style="width:40px;border:1px solid gray;padding-left:2px;border-top:none;border-right:none;border-left:none;background:'.$color.';height:30px;">
                            <input type="checkbox"  IS_DATA=true PUT_IN="DEFAULT_ID" DEFAULT_ID="'.$row->id_unique.'" id="INPUT-'.$row->id_unique.'" style="cursor:pointer;">                        
                        </td>
                        <td align=left valign=middle style="width:150px;border:1px solid gray;padding-left:5px;font-size:14px;border-top:none;border-right:none;background:'.$color.';color:black;"><span UN_ESCAPE=true>'.$row->name.'</span></td>
                        <td align=left valign=middle style="border:1px solid gray;padding-left:5px;font-size:14px;border-top:none;border-right:none;background:'.$color.';color:black;"><span UN_ESCAPE=true>'.$row->description.'</span></td>
                    </tr>
              ';
              $color = ($color === "white")? "#C8C2F3" : "white";
            }
            mysqli_free_result($result);  
			$this->sql_close();	
            $val->VALUE = $list;         
			$val->MESSAGE =	"";
			return $val;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }   
    
	/****** PARSE CONTENT ******/	
   
    public function prepare_file($path,$CMD){
        try{
            if(!file_exists($path)) return "";			
			return $this->prepare_content(file_get_contents($path),$CMD);			
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	
	/********* PARSE LIST ******/
	
	public function parse_input_data($content = false){		
		try{				
			if($content === false) return "";	
			preg_match_all("|@@INPUT_DATA=(.*)@@|U",$content,$tokens, PREG_PATTERN_ORDER);
			$tokensUnique = array_unique($tokens[1]);
			foreach ($tokensUnique as $t){	
				
				if( ($actions = explode("&",$t)) === false){
					$content = str_replace("@@INPUT_DATA=$t@@","",$content);	
					continue;
				}
				$count = count($actions);	
				
				$obj =  new stdClass;				
				$obj->TOKEN = get_id();
				for($i = 0; $i < $count; $i++){
					if( (($data = explode("=",$actions[$i])) === false) || count($data) !== 2) continue;
					$token = strtoupper($data[0]);					
					$obj->$token = (strpos($data[1], "|") === false)? $data[1] : explode("|",$data[1]);
				}				
				$this->ROOT->TOKENS[$obj->TOKEN] = parse_object($obj);		
				$content = str_replace("@@INPUT_DATA=$t@@",$obj->TOKEN,$content);									
			}
			return $content;
		}catch(Exception $e){
			return false;
		}
	}
	public function exec_cmd($content = false){		
		try{				
			if($content === false) return "";			
			preg_match_all("|@@RUNCMD=(.*)@@|U",$content,$tokens, PREG_PATTERN_ORDER);
			$tokensUnique = array_unique($tokens[1]);			
			foreach ($tokensUnique as $t){					
				if( ($actions = explode("&",$t)) === false) continue;
				$count = count($actions);		
				$obj =  new_cmd($this->ROOT->ID_SESSION);	
				for($i = 0; $i < $count; $i++){
					if( (($data = explode("=",$actions[$i])) === false) || count($data) !== 2) continue;
					$token = strtoupper($data[0]);				
					$obj->$token = (strpos($data[1], "|") === false)? $data[1] : explode("|",$data[1]);
				}	
				$str = "";				
				if(isset($obj->MODULE)){					
					$MODULE = "T".$obj->MODULE;
					if(is_a($this->ROOT->MODULES->$MODULE,$MODULE)){
						
						if(isset($obj->ROOT_TOKEN) &&  isset($this->ROOT->TOKENS[$obj->ROOT_TOKEN])){
							$_CMD = $this->ROOT->TOKENS[$obj->ROOT_TOKEN];
							
							if(isset($obj->LOAD_PARAMS)){
								for($i ; $i < count($obj->LOAD_PARAMS); $i++){
									$key = $obj->LOAD_PARAMS[$i];
									if(isset($_CMD->$key)) $obj->$key = $_CMD->$key;
								}
							}
						}
						
						$CMD = $this->run_cmd($this->ROOT->MODULES->$MODULE,parse_object($obj),$this);
						if($CMD !== false && $CMD->error !== true && $CMD->CONTENT !== false) $str = $CMD->CONTENT;
					}
				}
				$content = str_replace("@@RUNCMD=$t@@",$str,$content);	
			}		
			return $content;
		}catch(Exception $e){
			return false;
		}
	}
	
	/********* PARSE LIST ******/
	
	public function get_datas($content = false){		
		try{			
			if($content === false) return "";
			preg_match_all("|@@DATA=(.*)@@|U",$content,$tokens, PREG_PATTERN_ORDER);
			$tokensUnique = array_unique($tokens[1]);			
			foreach ($tokensUnique as $t){					
				if( ($actions = explode("&",$t)) === false) continue;
				$count = count($actions);					
				$obj =  new stdClass;						
				for($i = 0; $i < $count; $i++){
					if( (($data = explode("=",$actions[$i])) === false) || count($data) !== 2) continue;
					$token = strtoupper($data[0]);				
					$obj->$token = (strpos($data[1], "|") === false)? $data[1] : explode("|",$data[1]);
				}												
				$str = $this->get_data_values(parse_object($obj));
				$content = str_replace("@@DATA=$t@@",$str,$content);	
			}		
			return $content;
		}catch(Exception $e){
			return "";
		}
	}
	public function get_data_values(&$obj){
		try{
			$format = array("JSON","SELECT","TABLE","LISTBOX","CHECKBOX_LIST","RADIO_LIST","CHECKBOX_TABLE","RADIO_TABLE");
			$str = "";
			if(isset($obj->SOURCE) && isset($obj->FORMAT) && in_array($obj->FORMAT,$format)){					
				$first = true;
				if($obj->SOURCE === "DB" && isset($obj->DOCUMENT) && isset($obj->FIELDS_DISPLAY)){
					
					/************* FORMAT FIELD ************/
					
					$fields = array();

					$query_field = "";
					foreach($obj->FIELDS_DISPLAY as $key => $field_source){
						$field =  new stdClass;
						$field->SOURCE = $key ;
						$field->DISPLAY = $field_source;
						$field->VISIBLE = true;
						$fields[] = $field;								
						$query_field .= ($query_field === "")? $field->SOURCE : ",".$field->SOURCE;
					}
					
					if( isset($obj->FIELDS_NO_DISPLAY)){
						foreach($obj->FIELDS_NO_DISPLAY as $key => $field_source){
							$field =  new stdClass;
							$field->SOURCE = $key ;
							$field->DISPLAY = $field_source;
							$field->VISIBLE = false;
							$fields[] = $field;								
							$query_field .= ($query_field === "")? $field->SOURCE : ",".$field->SOURCE;
						}
					}
					
					/************* ORDER BY ************/
					
					$obj->FILEDS_ASC = new stdClass;
					$order_by_asc =  "";
					if(isset($obj->ORDER_BY_ASC)){
						
						$fieds = new stdClass;							
						if(is_string($obj->ORDER_BY_ASC)){
							$val = $obj->ORDER_BY_ASC;
							$order_by_asc =  $val." ASC";
							$fieds->$val = new stdClass;
							$fieds->$val->ASC = true;
						}
						else{
							$order_by_asc = join(",",(array)$obj->ORDER_BY_ASC) ." ASC";
							foreach($obj->ORDER_BY_ASC as $key => $val){
								$fieds->$val = new stdClass;
								$fieds->$val->ASC = true;
							}
						}
						$obj->FILEDS_ASC = $fieds;
					}
					
					$obj->ORDER_BY_DESC_VAL  = new stdClass;
					$obj->FILEDS_DESC = new stdClass;
					$order_by_desc =  "";
					if(isset($obj->ORDER_BY_DESC)){
						
						$fieds = new stdClass;							
						if(is_string($obj->ORDER_BY_DESC)){
							$val = $obj->ORDER_BY_DESC;
							$order_by_desc =  $val." DESC";
							$fieds->$val = new stdClass;
							$fieds->$val->DESC = true;
							
							$obj->ORDER_BY_DESC_VAL->$val = true;
							
						}
						else{
							$order_by_desc = join(",",(array)$obj->ORDER_BY_DESC) ." DESC";
							foreach($obj->ORDER_BY_DESC as $key => $val){
								$fieds->$val = new stdClass;
								$fieds->$val->DESC = true;
								$obj->ORDER_BY_DESC_VAL->$val = true;
							}
						}
						$obj->FILEDS_DESC = $fieds;
					}
					
					$order_by =  ($order_by_desc === "")? "" : "ORDER BY {$order_by_desc}";
					if($order_by_asc !== "")$order_by .=  ($order_by === "")? "ORDER BY {$order_by_asc}" : ", {$order_by_asc}";
					
					$filter_fields = "";
					
					if( isset($obj->FILTER_IDX) && $obj->FILTER_IDX !== false){						
						$filter_fields = " WHERE id_unique IN ('".join("','",array_keys((array)$obj->FILTER_IDX))."')";		
					}
										
					if(isset($obj->FILTER_FIELDS)){
						foreach($obj->FILTER_FIELDS as $key => $val){
							if(trim($val) === "") continue;
							if($key === "datecreate" || $key === "dateupdate" || $key === "datedelete" ) $val = urldecode($val);
							if($obj->FILTER_STRICT === false){
								$filter_fields .= ($filter_fields === "")? " WHERE $key LIKE '%$val%' " : " AND $key LIKE '%$val%'  ";	
							}
							else{
								$filter_fields .= ($filter_fields === "")? " WHERE $key='$val' " : " AND $key='$val' ";	
							}
						}
					}
			
					/*************** DETECT ROLES *********/
									
					$module_ALL = "LIST_".$obj->DOCUMENT."_ALL";
					$module_OWN = "LIST_".$obj->DOCUMENT."_OWN";
					if(!isset($this->ROOT->INFOS->ROLES->$module_ALL) && !isset($this->ROOT->INFOS->ROLES->$module_OWN)) return "";
					
					$LOAD_ALL = "";					
					if(!isset($this->ROOT->INFOS->ROLES->$module_ALL)) $LOAD_ALL = " usercreate='{$this->ROOT->INFOS->id_unique}' ";
					
					/*************** RUN QUERY *********/
					
					$LOAD_ARCHIVED = "";
					if($obj->LOAD_ARCHIVED === md5("ALL_WITH_NO_ARCHIVED_ELEMENT")) $LOAD_ARCHIVED = " IS_ARCHIVE=0 ";
					elseif($obj->LOAD_ARCHIVED === md5("ARCHIVED_ELEMENT_ONLY")) $LOAD_ARCHIVED = " IS_ARCHIVE=1 ";
								
					if($LOAD_ARCHIVED !== "")$filter_fields .= ($filter_fields === "")? " WHERE {$LOAD_ARCHIVED} " : " AND {$LOAD_ARCHIVED} ";
					if($LOAD_ALL !== "")$filter_fields .= ($filter_fields === "")? " WHERE {$LOAD_ALL} " : " AND {$LOAD_ALL} ";
					
					$sql_max_count = "SELECT COUNT(*) as max_count FROM  {$obj->DOCUMENT} {$filter_fields} {$order_by};";										
					if( ($result_max_count = $this->sql_select_one($sql_max_count)) === false) return "";
					
					$offset = $obj->BEGIN * $obj->MAX;
					$sql = "SELECT id_unique,{$query_field},IS_ARCHIVE FROM  {$obj->DOCUMENT} {$filter_fields} {$order_by} LIMIT {$obj->MAX} OFFSET {$offset};";
					if( ($result = $this->sql_select($sql)) === false) return "";
					
					$_line_max = $result_max_count->max_count;					
					$rowcount = mysqli_num_rows($result) - 1;
					
					$i = 0;
					$obj->class_party = "";
					
					$obj->ROLES = $this->user_module_role($obj->DOCUMENT);
					
					while ($row = mysqli_fetch_object($result)) {											
						$obj->class_party = ($obj->class_party === "pair")? "impair" : "pair";
						$last = ($i === $rowcount)? true : false;
						
						$roles = new stdClass;
						
						$roles->remove = false;
						if($obj->ROLES->REMOVE->ALL === true )$roles->remove = true;
						elseif($obj->ROLES->REMOVE->OWN === true && $row->id_unique === $this->ROOT->INFOS->id_unique) $roles->remove = true;
						
						$roles->archive = $roles->remove;
						
						$roles->update = false;
						if($obj->ROLES->UPDATE->ALL === true )$roles->update = true;
						elseif($obj->ROLES->UPDATE->OWN === true && $row->id_unique === $this->ROOT->INFOS->id_unique) $roles->update = true;
						
						//if($roles->detail === true)
						
						$roles->detail = false;
						if($obj->ROLES->DETAIL->ALL === true )$roles->detail = true;
						elseif($obj->ROLES->DETAIL->OWN === true && $row->id_unique === $this->ROOT->INFOS->id_unique) $roles->detail = true;
											
						$roles->show_checkbox = ($roles->remove === true || $roles->update === true)? true : false;
						
						$val = $this->get_datas_format($obj,$row,$roles,$fields,$first,$last);								
						if($val === false) continue;	
						$str .= $val;
						++$i;
						$first = false;
					}
					mysqli_free_result($result);  
					$this->sql_close();	
					
					++$rowcount;
					$_page_curr = $obj->BEGIN + 1;
					$nb_page = $_line_max / $obj->MAX;
					if($nb_page <= 1){
						$str .= "
							<script language='javascript'>
								$('[COUNT_NAV_PAGE=true]').hide();
								$('[BTN_NAV_PAGE=true]').hide();												
								$('[NB_MAX_LINE=true]').html('Nombre de lignes maximum {$_line_max}');
								$('[NB_LINE=true]').html('{$rowcount} lignes affichée(s)');									
								$('[MAX_LINES_MEM=true]').val({$rowcount});
								$('[MAX_PAGE_MEM=true]').val({$nb_page});									
								$('[CURRENT_PAGE_MEM=true]').val({$obj->BEGIN});								
							</script>
						";
					}
					else{													
						$nb_page = ( ($_line_max % $obj->MAX) > 0) ? intVal($nb_page) + 1: intVal($nb_page);
						
						$btn_first = "$('[BTN_GO_TO_FIRST=true]').show();";
						$btn_prev = "$('[BTN_GO_TO_PREV=true]').show();";
						$btn_next = "$('[BTN_GO_TO_NEXT=true]').show();";
						$btn_last = "$('[BTN_GO_TO_LAST=true]').show();";
						
						if($_page_curr === 1) {
							$btn_first = "";
							$btn_prev = "";
						}
						if($_page_curr >= $nb_page){
							$btn_last = "";
							$btn_next = "";
						}
						
						$str .= "
							<script language='javascript'>
								$('[PAGE_CURRENT=true]').html({$_page_curr});
								$('[PAGE_MAX=true]').html({$nb_page});
								$('[COUNT_NAV_PAGE=true]').show();
								$('[BTN_NAV_PAGE=true]').hide();
								{$btn_first}
								{$btn_prev}
								{$btn_next}
								{$btn_last}
								$('[NB_MAX_LINE=true]').html('Nombre de lignes maximum {$_line_max}');
								$('[NB_LINE=true]').html('{$rowcount} lignes affichée(s)');
								$('[MAX_LINES_MEM=true]').val({$rowcount});									
								$('[MAX_PAGE_MEM=true]').val({$nb_page});									
								$('[CURRENT_PAGE_MEM=true]').val({$obj->BEGIN});
							</script>
						";
					}
				}	
				elseif($obj->SOURCE === "FILE" && isset($obj->DIR)  && isset($obj->FILENAME) && isset($obj->FIELDS_DISPLAY)){										
					$list = get_file_data_content(dirname(__FILE__) ."/{$obj->DIR}/{$obj->FILENAME}.json");
					if($list !== false){					
						for($i = 0; $i < count($list);$i++){
							$last = ($i === (count($list) - 1))? true : false;													
							$val = $this->get_datas_format($obj,parse_object($list[$i]),false,$obj->FIELDS_DISPLAY,$first,$last);								
							if($val === false)continue;
							$str .= $val;
							$first = false;
						}
					}						
				}
			}
			return $str;
		}catch(Exeception $e){
			return "";
		}
	}
	public function format_date($value){
		try{
			$_val = explode(" ",$value);
			$valdate = explode("-",$_val[0]);			
			return (count($valdate) > 2)?$valdate[2]."/".$valdate[1]."/".$valdate[0]." à ".$_val[1] : $value;
		}catch(Exeception $e){
			return $value;
		}
	}
	private function get_datas_format(&$obj,$row,$roles,$fields,$first,$last ){
		try{
			$key = get_string_id();
			$val = "";
			if($obj->SOURCE === "DB"){				
				$key = $row->id_unique;
			}			
			if($obj->FORMAT === "JSON"){
				$val = new stdClass;
				foreach($fields as $key => $item) {			
					$val->$item = $row->$item;
				}	
				if(isset($obj->NOT_FORMAT) && $obj->NOT_FORMAT === true) return $val;
				$val = json_encode($val);
			}					
			elseif($obj->FORMAT === "SELECT"){										
				$val = ($first === true)? "<select id='".$obj->ID."'><option value='".$key."' UN_ESCAPE=true>" : "<option value='".$key."' UN_ESCAPE=true>";
				for($i = 0; $i < count($fields);$i++) {
					$item = $fields[$i]->SOURCE;
					$val .= ($i === 0)? $row->$item : " ".$row->$item;
				}
				$val .= ($last === true)? "</option></select>":  "</option>";
			}
			elseif($obj->FORMAT === "LISTBOX"){
				$val = ($first === true)? "<select id='".$obj->ID."' size=20><option value='".$key."' UN_ESCAPE=true>" : "<option value='".$key."' UN_ESCAPE=true>";
				for($i = 0; $i < count($fields);$i++) {
					$item = $fields[$i]->SOURCE;
					$val .= ($i === 0)? $row->$item : " ".$row->$item;
				}
				$val .= ($last === true)? "</option></select>":  "</option>";
			}
			elseif($obj->FORMAT === "TABLE" ){
				
				if($first === true){
					$val = "<table id='".$obj->ID_SUPPORT."' class='{$obj->CLASS_NAME}' cellpacing=0 cellpadding=0 border=0>";
					if(isset($obj->PUT_HEADER) && $obj->PUT_HEADER === true){
						$val .= "<tr IS_HEAD_LINE=true  class='head' ID_UNIQUE='".$key."'>";					
						if(isset($obj->PUT_CHECKBOX) && $obj->PUT_CHECKBOX === true){
							if($obj->ROLES->PUT_CHECKBOX === true){
								$val .= "<td IS_HEAD='{$obj->ID_UNIQUE_STRING}' IS_HEADER_ACTIONS=true ID_UNIQUE='".$key."' title='Tous sélectionner' ><div class='action_checkbox_header' ><input BTN_SELECT_ALL=true onclick='javascript:".$obj->ID_SUPPORT."_HEADER_CHECKED(this);'  type='checkbox'></div></td>";
							}
							else{
								$val .= "<td IS_HEAD='{$obj->ID_UNIQUE_STRING}' class='empty_actions' ></td>";
							}
						}
						if(isset($obj->PUT_UPDATE) && $obj->PUT_UPDATE === true){				
							$val .= "<td IS_HEAD='{$obj->ID_UNIQUE_STRING}' class='empty_actions' ></td>";												
						}
						if(isset($obj->PUT_ARCHIVED) && $obj->PUT_ARCHIVED === true){
							if($obj->ROLES->REMOVE->EXISTS === true){
								$val .= "<td IS_HEAD='{$obj->ID_UNIQUE_STRING}' IS_HEADER_ACTIONS=true ><div onclick='javascript:".$obj->BTN_ACTION_LIST_ARCHIVED."(this,{ACTION : \"ARCHIVE\"});' class='actions_archived_header' title='Archiver les éléments cochés' BTN_ACTIONS_HEADER=true BTN_ARCHIVED_CHECKED=true></div></td>";
							}
							else{
								$val .= "<td IS_HEAD='{$obj->ID_UNIQUE_STRING}' class='empty_actions' ></td>";
							}							
						}
						if(isset($obj->PUT_DELETE) && $obj->PUT_DELETE === true){
							if($obj->ROLES->REMOVE->EXISTS === true){
								$val .= "<td IS_HEAD='{$obj->ID_UNIQUE_STRING}' IS_HEADER_ACTIONS=true ><div onclick='javascript:".$obj->BTN_ACTION_LIST_DELETE."(this,{ACTION : \"DELETE\"});' class='actions_delete_header' title='Supprimer les éléments cochés' BTN_ACTIONS_HEADER=true BTN_DELETE_CHECKED=true></div></td>";
							}
							else{
								$val .= "<td IS_HEAD='{$obj->ID_UNIQUE_STRING}' class='empty_actions' ></td>";
							}
						}
						if(isset($obj->PUT_DETAIL) && $obj->PUT_DETAIL === true){
							$val .= "<td IS_HEAD='{$obj->ID_UNIQUE_STRING}' class='empty_actions' ></td>";
						}
						
						for($i = 0; $i < count($fields);$i++) {
							$display = ($fields[$i]->VISIBLE === true)? " MEMORY_FIELD=false " : " style='display:none;' MEMORY_FIELD=true ";
							$item = $fields[$i]->DISPLAY;
							$item_src = $fields[$i]->SOURCE;													
							$order = (isset($obj->ORDER_BY_DESC_VAL->$item_src))? "desc": "asc";												
							$val .= "<td IS_HEAD='{$obj->ID_UNIQUE_STRING}' align=center valign=middle ID_UNIQUE='".$item_src."' UN_ESCAPE=true class='{$item_src}' {$display} ><span BTN_HEADER_COLUMN=true class='{$order}' onclick='javascript:".$obj->FILTER_CLICK."(this);' ID_UNIQUE='".$item_src."' >".$item."</span></td>";
						}						
						$val .= "</tr>";
					}
				}
				$val .= "<tr IS_BODY_LINE='{$obj->ID_UNIQUE_STRING}' class='body' id='TR_LINE_{$key}' LINE_UNIQUE='".$key."'>";
				
				if(isset($obj->PUT_CHECKBOX) && $obj->PUT_CHECKBOX === true){
					if($roles->show_checkbox === true){
						$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true ID_UNIQUE='".$key."' class='action_checkbox' ><input BTN_SELECT=true  ID_UNIQUE='".$key."' onclick='javascript:".$obj->ID_SUPPORT."_BODY_CHECKED(this);'   type='checkbox' id='".$key."'></td>";
					}
					else{
						$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true  class='action_checkbox' ></td>";
					}
				}
				if(isset($obj->PUT_UPDATE) && $obj->PUT_UPDATE === true){					
					if($roles->update){
						$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true BTN_ACTION_LIST_UPDATE=true onclick='javascript:".$obj->BTN_ACTION_LIST_UPDATE."(this);'  ID_UNIQUE='".$key."' class='actions_update' ><div title='Modifier' BTN_UPDATE=true ID_UNIQUE='".$key."'></div></td>";
					}
					else{
						$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true class='actions_update' ></td>";
					}
				}
				if(isset($obj->PUT_ARCHIVED) && $obj->PUT_ARCHIVED === true){
					if((int)$row->IS_ARCHIVE === 1){												
						$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true class='actions_archived' ></td>";
					}
					else{
						if($roles->archive === true){
							$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true BTN_ACTION_LIST_ARCHIVED=true onclick='javascript:".$obj->BTN_ACTION_LIST_ARCHIVED."(this);' ID_UNIQUE='".$key."' class='actions_archived' ><div title='Archiver' BTN_ARCHIVED=true BTN_ARCHIVED_ID='".$key."'  ID_UNIQUE='".$key."'></div></td>";
						}
						else{
							$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true class='actions_archived' ></td>";
						}						
					}
				}
				if(isset($obj->PUT_DELETE) && $obj->PUT_DELETE === true){
					if($roles->remove === true){
						$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true BTN_ACTION_LIST_DELETE=true onclick='javascript:".$obj->BTN_ACTION_LIST_DELETE."(this);'   ID_UNIQUE='".$key."' class='actions_delete' ><div title='Supprimer' BTN_DELETE=true BTN_DELETE_ID='".$key."' ID_UNIQUE='".$key."'></div></td>";
					}
					else{
						$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true BTN_ACTION_LIST_DELETE=true class='actions_delete' ></td>";
					}					
				}
				if(isset($obj->PUT_DETAIL) && $obj->PUT_DETAIL === true){
					if($roles->detail === true){
						$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true BTN_ACTION_LIST_DETAIL=true onclick='javascript:".$obj->BTN_ACTION_LIST_DETAIL."(this);'  ID_UNIQUE='".$key."' class='actions_detail' ><div title='Détailler' BTN_DETAIL=true ID_UNIQUE='".$key."'></div></td>";
					}
					else{
						$val .= "<td IS_BODY=true IS_BODY_ACTIONS=true BTN_ACTION_LIST_DETAIL=true class='actions_detail' ></td>";
					}
				}				
				
				$class_party = "";
				for($i = 0; $i < count($fields);$i++) {					
					$item = $fields[$i]->SOURCE;
					$type_date = "empty";
					$value = $row->$item;
					if(trim($value) !== ""){
						$type_date = (validateDate($row->$item))? "date" : "";
						if($item === "datecreate" || $item === "dateupdate"  || $item === "datedelete" ){							
							$value = $this->format_date($value);
						}
						else{							
							if($type_date === "" && is_numeric($row->$item)){
								$type_date = "integer ";						
								if(is_float($value))$value = number_format($value, 2, ',', ' ');
								else $value = number_format($value, 0, '', ' ');
							}
							else $value = trim(strtolower($value));
						}
					}
					$display = ($fields[$i]->VISIBLE === true)? "MEMORY_FIELD=false " : "style='display:none;' MEMORY_FIELD=true ";
					$val .= "<td IS_BODY=true IS_BODY_CONTENT=true SOURCE_CELL='{$item}' valign=middle  ID_UNIQUE='".$key."' class='{$obj->class_party} {$item} {$type_date}' UN_ESCAPE=true {$display}>".$value."</td>";
				}
				$val .= ($last === true)? "</tr></table>":  "</tr>";
			}
			return $val;
		}catch(Exception $e){
			return false;
		}
	}	
	
	/********* PARSE TOKEN ******/
		
	public function save_token($obj,$update = false){
		try{
			if($update === false) $obj->TOKEN = get_id();
			$this->ROOT->TOKENS[$obj->TOKEN] = $obj;
			return $obj;	
		}catch(Exception $e){
			return false;
		}
	}
	public function parse_tokens($content = false){		
		try{			
			if($content === false) return "";
			preg_match_all("|@@TOKENS=(.*)@@|U",$content,$tokens, PREG_PATTERN_ORDER);
			$tokensUnique = array_unique($tokens[1]);
			foreach ($tokensUnique as $t){					
				if( ($actions = explode("&",$t)) === false){
					$content = str_replace("@@TOKENS=$t@@","",$content);
					continue;
				}
				$count = count($actions);	
				
				$obj =  new_cmd($this->ROOT->ID_SESSION);
				$ACTION_NAME = "ACTIONS";
				for($i = 0; $i < $count; $i++){
					if( (($data = explode("=",$actions[$i])) === false) || count($data) !== 2) continue;
					$token = strtoupper($data[0]);
					if($token === "ACTION_NAME"){
						$ACTION_NAME = $data[1];
						continue;
					}
					$obj->$token = (strpos($data[1], "|") === false)? $data[1] : explode("|",$data[1]);
				}				
				$this->ROOT->TOKENS[$obj->TOKEN] = parse_object($obj);		
				if(isset($obj->TOKEN_ONLY)) $content = str_replace("@@TOKENS=$t@@",$obj->TOKEN,$content);	
				else $content = str_replace("@@TOKENS=$t@@",' '.$ACTION_NAME.'="'.$obj->TOKEN.'" ',$content);	
			}
			return $content;
		}catch(Exception $e){
			return "";
		}
	}
	private function parse_content($content = false){		
		try{			
			if($content === false) return "";
			
			$tag = array(
				array(CONNECTED => true, BEGIN_BLOC => "[CONNECTED-CONTENT][BEGIN]",END_BLOC => "[END][CONNECTED-CONTENT]"),
				array(CONNECTED => false, BEGIN_BLOC => "[DISCONNECTED-CONTENT][BEGIN]",END_BLOC => "[END][DISCONNECTED-CONTENT]")
			);
			for($i = 0; $i < count($tag);$i++){
				
				$BEGIN_BLOC = $tag[$i]["BEGIN_BLOC"];
				$END_BLOC = $tag[$i]["END_BLOC"];
				$CONNECTED_MODE = $tag[$i]["CONNECTED"];
				
				do{				
					$BEGIN 	= strpos($content,$BEGIN_BLOC,0);
					$END	= strpos($content,$END_BLOC,0);
					if(($BEGIN === false) || ($END === false)) break;
					
					$END = ($END-$BEGIN) + strlen($END_BLOC);
					$CMD_STR_SRC = substr($content,$BEGIN,$END);
								
					if($this->ROOT->CONNECTED === $CONNECTED_MODE){					
						$content =str_replace($BEGIN_BLOC, "", $content);
						$content =str_replace($END_BLOC, "", $content);				
					}
					else $content=  str_replace( $CMD_STR_SRC, "", $content);
									
				}while( (strpos($content,$BEGIN_BLOC,0) !== false) && (strpos($content,$END_BLOC,0) !== false));
			}						
			return  $content;
			
		}catch(Exception $e){
			return "";
		}
	}
	private function parse_root_content($content = false){		
		try{			
			if($content === false) return "";
			
			$BEGIN_BLOC = "[ROOTCONTENT][BEGIN]";
			$END_BLOC = "[END][ROOTCONTENT]";				
			if($this->ROOT->CONNECTED === false || $this->ROOT->IS_ROOT === false) return $this->remove_content($content,$BEGIN_BLOC,$END_BLOC);			
			$content =	str_replace($BEGIN_BLOC, "", $content);
			$content =	str_replace($END_BLOC, "", $content);	
			return  $content;
			
		}catch(Exception $e){
			return "";
		}
	}
	private function parse_notroot_content($content = false){		
		try{			
			if($content === false) return "";
			$BEGIN_BLOC = "[NOT-ROOTCONTENT][BEGIN]";
			$END_BLOC = "[END][NOT-ROOTCONTENT]";				
			if($this->ROOT->IS_ROOT === true) return $this->remove_content($content,$BEGIN_BLOC,$END_BLOC);	
			$content =	str_replace($BEGIN_BLOC, "", $content);
			$content =	str_replace($END_BLOC, "", $content);
			return  $content;			
		}catch(Exception $e){
			return "";
		}
	}
	public function remove_content($content,$BEGIN_BLOC,$END_BLOC){		
		try{
			do{				
				$BEGIN 	= strpos($content,$BEGIN_BLOC,0);
				$END	= strpos($content,$END_BLOC,0);
				if(($BEGIN === false) || ($END === false)) break;				
				$END = ($END-$BEGIN) + strlen($END_BLOC);
				$CMD_STR_SRC = substr($content,$BEGIN,$END);							
				$content =  str_replace( $CMD_STR_SRC, "", $content);								
			}while( (strpos($content,$BEGIN_BLOC,0) !== false) && (strpos($content,$END_BLOC,0) !== false));
			return  $content;			
		}catch(Exception $e){
			return "";
		}
	}
   
	/*************** USER INFOS *********************/
	
	public function get_user_names($id_unique){
		try{

			if($this->ROOT_INFO->id_unique === $id_unique) return "Administrateur";
			
			$fields = $this->get_table_select_struct();
			$result = $this->sql_select_one("select {$fields} FROM UTILISATEURS where id_unique='$id_unique'");      
			if($result !== false){
				$infos = json_encode(unserialize(urldecode($result->INFOS)));
				return $infos->INFORMATION->NAME."  ".$infos->INFORMATION->SURNAME;
			}			
			return "Système";
		}catch(Exception $e){
			return "";
		}
	}
	public function get_user_information($id_unique){
		try{
			$fields = $this->get_table_select_struct();
			$result = $this->sql_select_one("select {$fields} FROM UTILISATEURS where id_unique='$id_unique'");      
			if($result !== false){
				$infos = json_encode(unserialize(urldecode($result->INFOS)));
				return $infos->INFORMATION;
			}
			$root = get_root($this->ROOT->CRT);
			if($root->id_unique === $id_unique) return $root;
			return false;
		}catch(Exception $e){
			return false;
		}
	}
	public function get_user_email($id_unique){
		try{
			$fields = $this->get_table_select_struct();
			$result = $this->sql_select_one("select {$fields} FROM UTILISATEURS where id_unique='$id_unique'");      
			if($result !== false){
				$infos = json_encode(unserialize(urldecode($result->INFOS)));
				return $infos->INFORMATION->EMAIL;
			}
			$root = get_root($this->ROOT->CRT);
			if($root->id_unique === $id_unique) return $root->email;
			return "";
		}catch(Exception $e){
			return "";
		}
	}
	public function get_user_roles($id_unique){
		try{
			$fields = $this->get_table_select_struct();
			$result = $this->sql_select_one("select {$fields} FROM UTILISATEURS where id_unique='$id_unique'");      
			if($result !== false){
				$infos = json_encode(unserialize(urldecode($result->INFOS)));
				return $infos->ROLES;
			}
			$root = get_root($this->ROOT->CRT);
			if($root->id_unique === $id_unique) return true;
			return false;
		}catch(Exception $e){
			return false;
		}
	}
	public function get_user_data($id_unique,$key){
		try{
			$fields = $this->get_table_select_struct();
			$result = $this->sql_select_one("select {$fields} FROM UTILISATEURS where id_unique='$id_unique'");      
			if($result !== false) return $infos->$key;			
			return false;
		}catch(Exception $e){
			return false;
		}
	}
	
	/*************** ROLES MANAGE *********************/
	
	private function user_module_role($DOCUMENT){
		try{
			$action = array("LIST","CREATE","UPDATE","REMOVE","DETAIL");
			$ROLES = new stdClass;
			
			for($i=0; $i < count($action); $i++){
				$act = $action[$i];
				$module_ALL = $act."_".$DOCUMENT."_ALL";
				$module_OWN = $act."_".$DOCUMENT."_OWN";				
				$ROLES->$act = new stdClass;
				$ROLES->$act->ALL = (isset($this->ROOT->INFOS->ROLES->$module_ALL))? true : false;
				$ROLES->$act->OWN = (isset($this->ROOT->INFOS->ROLES->$module_OWN))? true : false;
				$ROLES->$act->EXISTS =  ($ROLES->$act->ALL === true || $ROLES->$act->OWN === true)? true : false;
			}
			$ROLES->PUT_CHECKBOX = ($ROLES->UPDATE->EXISTS === true || $ROLES->REMOVE->EXISTS === true )? true : false;
			
			return $ROLES;
		}catch(Exception $e){
			return false;
		}
	}
	private function parse_role($content = false){		
		try{			
			if($content === false) return "";			
			do{
				$NEW_CMD_STR_SRC = "";
				$content = trim($content);				
				$BEGIN 	= strpos($content,"[ROLE-ATTRIBUTE][BEGIN]",0);
				$END	= strpos($content,"[BEGIN][ROLE-ATTRIBUTE]",0);
				if(($BEGIN === false) || ($END === false)) break;				
				$CMD = substr($content,$BEGIN,$END-$BEGIN);
				$CMD = trim(str_replace("[ROLE-ATTRIBUTE][BEGIN]", "", $CMD));							
				$BEGIN_BLOC = "[ROLE-ATTRIBUTE][BEGIN]{$CMD}[BEGIN][ROLE-ATTRIBUTE]";				
				$END_BLOC = "[ROLE-ATTRIBUTE][END]{$CMD}[END][ROLE-ATTRIBUTE]";				
				$END = (strpos($content,$END_BLOC,0)-$BEGIN) + strlen($END_BLOC);
				$CMD_STR_SRC = substr($content,$BEGIN,$END);				
				$HAS_ROLES = $this->ROOT->IS_ROOT;				
				if($HAS_ROLES === false && $this->ROOT->ADMIN === true){					
					$HAS_ROLES = false;
					$_roles = explode("|",$CMD);					
					for($n =0; $n < count($_roles);$n++){
						if(	isset($this->ROOT->INFOS->roles->$_roles[$n])){
							$HAS_ROLES = true;
							break;
						}
					}
					unset($_roles);						
				}				
				if($HAS_ROLES === true){					
					$NEW_CMD_STR_SRC =str_replace($BEGIN_BLOC, "", $CMD_STR_SRC);
					$NEW_CMD_STR_SRC =str_replace($END_BLOC, "", $NEW_CMD_STR_SRC);
					$content=  str_replace( $CMD_STR_SRC, $NEW_CMD_STR_SRC, $content);					
				}
				else $content=  str_replace( $CMD_STR_SRC, "", $content);								
			}while( (strpos($content,"[ROLE-ATTRIBUTE][BEGIN]",0) !== false) && (strpos($content,"[BEGIN][ROLE-ATTRIBUTE]",0) !== false));			
			return  $content;			
		}catch(Exception $e){
			return "";
		}
	}	
	public function get_roles($roles_id){
		try{
			 
            $idx = false;
			
			foreach($roles_id as $key => $value){
				if($idx === false) $idx = array();
				$idx[] = $key;
            }
 
            if($idx === false) return false;
            if(count($idx) > 0) $idx = "('".join("','",$idx)."')";
 
			$result = $this->sql_select("select data from roles where id_unique IN $idx and data IS NOT NULL ");
			if($result === false) return false;
			
			$list = array();
			
			while ($row = mysqli_fetch_object($result)) { 				
				$list = array_merge($list,(array)json_decode($row->data));
            }
            
			mysqli_free_result($result);
			$this->sql_close();	
			
			return (object)$list;
			
		}catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
	}
	public function has_role($role){		
		try{
			if($this->ROOT->IS_ROOT === true) return true;
			if(	isset($this->ROOT->INFOS->roles->$role)) return true;
			return false;			
		}catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
	}	
	public function check_connect_only($LOGIN,$PASSWORD){
        try{           
            $result = $this->sql_select_one("select * from users where email='".$LOGIN."' and pwd='".md5($PASSWORD)."'  limit 1");
            if($result !== false) return true;
			return ($this->ROOT_INFO->email === $LOGIN && $this->ROOT_INFO->key === md5($PASSWORD) )? true : false;           			
        }catch(Exception $e){
            return false;
        }
    }
	public function refresh_roles(){
		try{
			
			if($this->ROOT->IS_ROOT === true) return true;
			if($this->ROOT->CONNECTED === false) return true;
		
			$result = $this->sql_select_one("select * from users where id_unique='".$this->ROOT->INFOS->id_unique."' limit 1");      
				         
			$this->ROOT->ADMIN = false;
			$this->ROOT->IS_ROOT = false; 
			
            $this->ROOT->INFOS->roles_names = false;  
			$this->ROOT->INFOS->roles_values = false;			
            if(isset($result->roles) && trim($result->roles) !== "" && isJSON($result->roles) === true){
                $this->ROOT->ADMIN = true;
				$this->ROOT->INFOS->roles_names = $result->roles;
				$this->ROOT->INFOS->roles_values = json_decode($this->ROOT->INFOS->roles_names);
                $this->ROOT->INFOS->roles = $this->get_roles($this->ROOT->INFOS->roles_values);					
            }
			session_save($this->ROOT);
			
			return true;
		}catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
	}
	
	/************ GALERY *********/  
	
		
	public function purge_images(){
		 try{           
						
			$count = new stdClass;				
            $count->max = 0;           
			$count->max_unreal = 0;           
			$count->max_real = 0;           
			
			if( ($result = $this->sql_select("select * from images")) === false) return $count;
			
            while ($row = mysqli_fetch_object($result)) {               
			    ++$count->max;
				if(local_images_exists($row) === false){					
					$this->sql_query("delete from images where id_unique='{$row->id_unique}'  ");
					++$count->max_unreal; 
				}
				++$count->max_real;             
            }     
			return $count;	
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	public function get_galery_image_count($id_unique){
        try{           
			$images_count = 0;                   
			if(($result = $this->sql_select_one("select count(*) as images_count from images where galeryid='$id_unique'  ")) !== false) $images_count = (int)$result->images_count;				
            return ( $this->sql_query("update galery set images_count={$images_count} where id_unique='$id_unique'  ") === false)? 0 : $images_count;				
        }catch(Exception $e){
            $this->ERROR = $e;
            return 0;
        }
    }
	public function get_galery_root($id_unique){
        try{           
			$date = dateTimePARIS_FR();
            $result = $this->sql_select_one("select * from galery where id_unique='$id_unique'  ");           			
			return ($result === false)? false : $result; 			
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	public function set_galery_images($id_unique,$id_images = false){
        try{
           
            $user = $this->ROOT->INFOS->id_unique;
            $date = dateTimePARIS_FR();

            $result = $this->sql_query("update images set galeryid=null,userupdate='$user',dateupdate='$date' where galeryid='$id_unique'  ");
            if($result === false) return false;

            if($id_images ===  false ) return true;
            $idx = false;
 
            foreach($id_images as $key => $value){
				if($idx === false) $idx = array();
				$idx[] = $key;
            }
 
            if($idx === false) return false;
			$idx = "('".join("','",$idx)."')";
            $sql = "update images set galeryid='$id_unique',userupdate='$user',dateupdate='$date' where id_unique IN $idx  ";           
			if($this->sql_query($sql) === false) return false;            
            return ($this->get_galery_image_count($id_unique) === false)? false : true ;
			
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	public function get_galery_images($galeries,$_exclude = array(),$public = false){
        try{
            $list = array();   
            $i = 0;
			foreach($galeries as $key => $row ){
				$item =  new stdClass;                             
				$item->idx = $row->id_unique;
				$item->name = $row->name;
				$item->description = $row->description;     
				$item->ispublic = ($row->ispublic === 0)? false : true;		
				$item->prices = $row->prices;
						
				$list[$row->id_unique] = $item;	
								
				if(trim(join("",$_exclude)) !== ""){
					$exclude = "('".join("','",$_exclude)."')";					
					$exclude = " AND id_unique NOT IN $exclude ";
				}else $exclude = "";
				
				$item->images = $this->galery_images($row->id_unique," roles IS NULL {$exclude} ",$item->prices->FREE,$public);											
				$item->count = ($item->images === false)? 0 :count((array)$item->images);
            }
            return $list;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	public function &_get_item_list(&$list,$itemkey){
		try{
			foreach($list as $key => &$value){
				if($key === $itemkey) return $value;
				if(isset($value->items)){
					$val = $this->_get_item_list($value->items,$itemkey);
					if($val !== false) return $val;
				}
			}
			return false;
		}catch(Exception $e){
            return false;
        }
	}	
	public function purge_display_item_list($list){
		try{
			foreach($list as $key => $value){
				if($value->display === false){
					unset($list[$key]);
					continue;
				}
				if(isset($value->items))$value->items = $this->purge_display_item_list($value->items);			
			}
			return $list;
		}catch(Exception $e){            
			return array();
        }
	}
	public function get_galery_li($CMD,$public = false,$with_image = false){
		try{
			
			$filter = ($this->has_role("GALERY_VIEW_ALL") === true)? "" : " where  usercreate='".$this->ROOT->INFOS->id_unique."' "; 
			
			if($public === true)$filter = " where ispublic=1  ";							
			$result = $this->sql_select("select * from galery $filter ORDER BY name ASC");
			
			$list = Array();
			$id_list = Array();
			
			if($result === false){
				if($public === true) return false;
				$val = new stdClass;
				$val->LI = $list;
				$val->GALERIES = $id_list;   
				return $val;				
			}			
			
			$id_unique  = (isset($CMD->ID_UNIQUE))?  $CMD->ID_UNIQUE : false;	
			
            while ($item = mysqli_fetch_object($result)){       				
				
				$row = parse_object($item);	
				$row->is_root = false;				
				
				if( $this->get_galery_image_count($row->id_unique) === 0) continue;				
				if($row->id_unique === $id_unique ) continue;
				
				$row->prices = json_decode($row->prices);							
											
				if($public === true){ //VISIBILITY & FREE DOWNLOAD
					
					$roles_free = (my_trim($row->roles_free) === "")? false : (array)json_decode($row->roles_free);
					$roles = (my_trim($row->roles) === "")? false : (array)json_decode($row->roles);
					$display = ($roles === false)? true : false;					
					if($this->ROOT->CONNECTED === true && $this->ROOT->INFOS->roles_values !== false ){					
						if($roles !== false){//VISIBILITY									
							
							foreach($this->ROOT->INFOS->roles_values as $key => $val){						
								if(isset($roles[$key])){								
									$display = true;
									break;
								}						
							}
							//if($display === false) continue;
						}
						if($row->prices->FREE === false && $roles_free !== false ){//FREE DOWNLOAD									
							foreach($this->ROOT->INFOS->roles_values as $key => $val){						
								if(isset($roles_free[$key])){
									$row->prices->FREE = true;
									break;
								}						
							}					
						}					
					}					
					//if($display === false) continue;					
					$row->display = $display;
				}
				
				unset($row->roles);
				unset($row->roles_free);
				
				if(isset($row->root) && trim($row->root) !== "" && $row->root !== $id_unique ){
					$root = &$this->_get_item_list($list,$row->root);
					
					if($root === false){
						$list[$row->root] = new stdClass;
						$list[$row->root]->id_unique = $row->root;
						$list[$row->root]->name = $row->root_name;
						$list[$row->root]->items = array();
						$root = &$list[$row->root];
					}
					$id_list[$row->id_unique] = $row;
					$root->is_root = true;
					$root->items[$row->id_unique] = $row;
					continue;
				}			
				elseif(isset($list[$row->id_unique])) continue;				
				$list[$row->id_unique] = $row;
				$id_list[$row->id_unique] = $row; 
				
			}
			mysqli_free_result($result);       
			$this->sql_close();
			
			if($public === true){
				$list = $this->purge_display_item_list($list);
				$id_list = $this->purge_display_item_list($id_list);
			}
			$val = new stdClass;
			$val->LI = $list;
			$val->GALERIES = $id_list;
			return $val;
			
		}catch(Exception $e){
            $this->ERROR = $e;           
			return "";
        }
	}
	public function galery_list($public = true,$no_image = false,$no_menu = false){
        try{
            $filter = ($public === true)?" roles IS NULL and  " : "";
            $result = $this->sql_select("select * from galery where $filter isdelete<>1  ORDER BY datecreate ASC ");                        
            if($result === false) return false;
			$galey_menu = "";
            $list = array();   
            $i = 0;
            while ($row = mysqli_fetch_object($result)) {
				$item =  new stdClass;  
				if($no_image === false){
					if( ($item->images = $this->galery_images($row->id_unique," roles IS NULL ",$item->prices->FREE)) === false) continue;	
				}
				
				$item->idx = $row->id_unique;				
				$item->name = $row->name;
				$item->description = $row->description;     
				$item->roles = false;
				if( isset($row->roles) && trim($row->roles) !== "") $item->roles = json_decode($row->roles);				
				$item->ispublic = ($item->roles === false)? true : false ;					
				$item->prices = json_decode($row->prices);				
				$list[$row->id_unique] = $item;
				
										
				if($no_menu === false) $galey_menu .= '<li class="PUBLIC-GALERY-SUB-MENU" TARGET="'.$row->id_unique.'" UN_ESCAPE=true>'.$row->name.'</li>';          		     
            }
            mysqli_free_result($result);       
			$this->sql_close();	

			$result = new stdClass;
			$result->GALERY_LIST = $list;
			$result->GALERY_MENU = $galey_menu;
            return $result;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
	public function galery_images($id_unique, $filter = "",$isfree = false,$public = false){
         try{           
            $filter = ($filter === "")? "" : " and $filter ";
			$result = $this->sql_select("select * from images where galeryid='$id_unique' $filter ORDER BY name ASC");
		
            if($result === false) return false;
            $list = array();
           
            while ($row = mysqli_fetch_object($result)) {           
               
			    if(local_images_exists($row) === false) continue;
															
				$item =  new stdClass;
				$item->root = $id_unique;
				$item->name = $row->name;
				$item->idx = $row->id_unique;
				$item->url_big = $row->bigname;
				$item->url_small = $row->smallname;
				$item->__uri = $row->cryptname;			   
				$item->width = $row->width;
				$item->height = $row->height;			   
				$item->roles = false;			    
				$item->isfree = $isfree;
				
				if($public === true && $this->ROOT->CONNECTED === true && isset($this->ROOT->MY_IMAGES) && isset($this->ROOT->MY_IMAGES[$row->id_unique]) ){
					$item->isfree = true;
				}
				
				if( isset($row->roles) && trim($row->roles) !== "") $item->roles = json_decode($row->roles);
				$list[$row->id_unique] = $item;             
            }
            mysqli_free_result($result); 
			$this->sql_close();	
			
			if(count($list) <= 0) return false;
            return $list;
        }catch(Exception $e){
            $this->ERROR = $e;
            return  false;
        }
    }
	public function load_images_with_id($idx_list = false){
         try{           
            
			if($idx_list === false) return false;
			
			if( ($result = $this->galery_list(true,true,true))  === false) return false;
			$galeries = $result->GALERY_LIST;
			
			$idx = false;
			
			foreach($idx_list as $key => $value){
				if($idx === false) $idx = array();
				$idx[] = $key;
            }
 
            if($idx === false) return false;
            if(count($idx) > 0) $idx = "('".join("','",$idx)."')";
 
			$result = $this->sql_select("select * from images where id_unique IN $idx  ORDER BY name ASC ");                       
            if($result === false) return false;
            $list = array();
           
            while ($row = mysqli_fetch_object($result)) {           
				
				$galerie = $galeries[$row->galeryid];

				$item =  new stdClass;
				$item->root = $row->galeryid;
				$item->name = $row->name;
				$item->idx = $row->id_unique;
				$item->url_big = $row->bigname;
				$item->url_small = $row->smallname;

				$item->width = $row->width;
				$item->height = $row->height;			   
				$item->roles = false;			  
				$item->download = $galerie->download;			  
				$item->isfree = $galerie->isfree;
				$item->price = 0.0;
				if($galerie->prices !== false && isset($galerie->prices->PRICE)) $item->price = (float)$galerie->prices->PRICE;

				if( isset($row->roles) && trim($row->roles) !== "") $item->roles = json_decode($row->roles);
				$list[$row->id_unique] = $item;             
            }
            mysqli_free_result($result); 
			$this->sql_close();	
			
            return $list;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
    
	/********************* CONNECT DISCONNECT ***********/
		
	public function connect($CMD){
        try{   
            
			$result = $this->sql_select_one("select id_unique,pwd,email,nom,prenom,roles,datecreate,dateupdate,usercreate,datecreate,dateupdate,userupdate,UNCOMPRESS(`data`) as data from users where email='".$CMD->DATA->LOGIN."' and pwd='".md5($CMD->DATA->PASSWORD)."'  limit 1");      
			
			$this->ROOT->ADMIN = false;
			$this->ROOT->IS_ROOT = false; 
			$this->ROOT->MY_IMAGES = array();
						
            if($result === false ){				
				if( $this->ROOT_INFO->email === $CMD->DATA->LOGIN && $this->ROOT_INFO->key === md5($CMD->DATA->PASSWORD) ){ 
					$result = $this->ROOT_INFO;
					$this->ROOT->IS_ROOT = true; 
					$this->ROOT->ADMIN = true;
				}
				else return false;
			}   
            $result->roles_names = false;  
			$result->roles_values = false;			
            if($this->ROOT->IS_ROOT === false && isset($result->roles) && trim($result->roles) !== "" && isJSON($result->roles) === true){
                $this->ROOT->ADMIN = true;
				$result->roles_names = $result->roles;
				$result->roles_values = json_decode($result->roles_names);
                $result->roles = $this->get_roles($result->roles_values);					
            }
			
			$this->ROOT->MY_IMAGES = (isset($result->data) && trim($result->data) !== "" )? (array)json_decode($result->data) : array();
			$result->infos = (isset($result->infos) && trim($result->infos) !== "" )? json_decode($result->infos) : false;
			if($result->infos === false){
				$result->infos = new stdClass;
				$result->infos->LAST_BUY = "";
				$result->infos->NB_BUY = 0;				
				$result->infos->IMAGES_COUNT = 0;
				$result->infos->LAST_IMAGES_COUNT =0;
			}
            $this->ROOT->INFOS = $result;           
            $this->ROOT->CONNECTED = true;
		
			return true;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }
    public function disconnect($CMD){
        try{		
			$this->ROOT->INFOS = false;
			$this->ROOT->CONNECTED = false;
			$this->ROOT->IS_ROOT = false;
			$this->ROOT->ADMIN = false;
			$this->ROOT->MEMORY = new stdClass;
			$this->ROOT->STAND_BY = false;
			$this->ROOT->LAST_TOKEN = false;
			if(isset($this->ROOT->PANIER) && $this->ROOT->PANIER !== false){
				foreach($this->ROOT->PANIER as $key => $img)unset($this->ROOT->PANIER[$key]);
				$this->ROOT->PANIER_COUNT = 0;
			}
			session_save($this->ROOT,true);			
            return true;
        }catch(Exception $e){
            $this->ERROR = $e;
            return false;
        }
    }

	
	/***********  GLOBAL RUN ********/
	
	public function run_cmd (&$obj,$CMD,$__SYS = false){
        try{
			$CMD->sign = md5(serialize($this->ROOT));
            $CMD->error = false;
			
			$sign = md5(serialize($this->ROOT));
			
			if($this->ROOT->CONNECTED === true){
				$this->refresh_roles();
			}
			if(isset($CMD->JS_ONLY) && $CMD->JS_ONLY === true) return $CMD;
			
			$name = $obj->NAME;			
			$obj->ERROR = false;
			$result = false;
			
			$precision = $CMD->PRECISION;				
            if(method_exists($obj,$precision)) $result = $obj->$precision($CMD,$__SYS); 

			if($obj->ERROR !== false || $result === false){
				$CMD->CONTENT =  ($obj->ERROR !== false)? $obj->ERROR : $CMD->CONTENT;				
				if(isset($CMD->KO_CONTAINER) && !isset($CMD->KO_ISDEFINED)){					
					$CMD->CONTENT = "<img src='images/error.png' width='25px' height='25px'><br><font style='color:red;'>".$CMD->CONTENT."</font>";
					$CMD->CONTAINER = $CMD->KO_CONTAINER;
				}
				else $CMD->error = true;
				
				return $CMD;
			}	
			
			if(is_string($result) === false) $CMD = $result;				
			else $CMD->CONTENT = $result;  	
			
			$last_sign = md5(serialize($this->ROOT));
			if($sign !== $last_sign){				
				$this->ROOT->DATE_UPDATE = dateTimePARIS_FR();
				
				if(isset($CMD->SAVE_SESSION)){
					if($CMD->SAVE_SESSION === true)session_save($this->ROOT);
					unset($CMD->SAVE_SESSION);
				}else session_save($this->ROOT);
				
			}
			if(isset($CMD->MODULES))unset($CMD->MODULES);
			if(isset($CMD->PRECISION))unset($CMD->PRECISION);		
			return $CMD;
			
        }catch(Exception $e){
            $CMD->error = true;
            $CMD->CONTENT = $e;
            return $CMD;
        }
    }
   
}
?>

